/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class QualityUtils {
    public static final byte MAX_SAM_QUAL_SCORE = 93;
    public static final double PHRED_TO_LOG_PROB_MULTIPLIER = -Math.log(10.0) / 10.0;
    public static final double LOG_PROB_TO_PHRED_MULTIPLIER = 1.0 / PHRED_TO_LOG_PROB_MULTIPLIER;
    private static final double MIN_LOG10_SCALED_QUAL = Math.log10(Double.MIN_VALUE);
    protected static final double MIN_PHRED_SCALED_QUAL = -10.0 * MIN_LOG10_SCALED_QUAL;
    public static final byte MAX_REASONABLE_Q_SCORE = 60;
    public static final byte MIN_USABLE_Q_SCORE = 6;
    public static final int MAPPING_QUALITY_UNAVAILABLE = 255;
    public static final int MAX_QUAL = 254;
    private static final double[] qualToErrorProbCache = new double[255];
    private static final double[] qualToProbLog10Cache = new double[255];

    private QualityUtils() {
    }

    public static double qualToProb(byte qual) {
        return 1.0 - QualityUtils.qualToErrorProb(qual);
    }

    public static double qualToProb(double qual) {
        Utils.validateArg(qual >= 0.0, () -> "qual must be >= 0.0 but got " + qual);
        return 1.0 - QualityUtils.qualToErrorProb(qual);
    }

    public static double qualToProbLog10(byte qual) {
        return qualToProbLog10Cache[qual & 0xFF];
    }

    public static double logProbToPhred(double prob) {
        return prob * LOG_PROB_TO_PHRED_MULTIPLIER;
    }

    public static double qualToErrorProb(double qual) {
        Utils.validateArg(qual >= 0.0, () -> "qual must be >= 0.0 but got " + qual);
        return Math.pow(10.0, qual / -10.0);
    }

    public static double qualToErrorProb(byte qual) {
        return qualToErrorProbCache[qual & 0xFF];
    }

    public static double qualToErrorProbLog10(byte qual) {
        return QualityUtils.qualToErrorProbLog10(qual & 0xFF);
    }

    public static double qualToErrorProbLog10(double qual) {
        Utils.validateArg(qual >= 0.0, () -> "qual must be >= 0.0 but got " + qual);
        return qual * -0.1;
    }

    public static byte errorProbToQual(double errorRate) {
        return QualityUtils.errorProbToQual(errorRate, (byte)93);
    }

    public static byte errorProbToQual(double errorRate, byte maxQual) {
        Utils.validateArg(MathUtils.isValidProbability(errorRate), () -> "errorRate must be good probability but got " + errorRate);
        double d = Math.round(-10.0 * Math.log10(errorRate));
        return QualityUtils.boundQual((int)d, maxQual);
    }

    public static byte errorProbToQual(double prob, int maxQual) {
        Utils.validateArg(maxQual >= 0 && maxQual <= 255, () -> "maxQual must be between 0-255 but got " + maxQual);
        return QualityUtils.errorProbToQual(prob, (byte)(maxQual & 0xFF));
    }

    public static byte trueProbToQual(double prob) {
        return QualityUtils.trueProbToQual(prob, (byte)93);
    }

    public static byte trueProbToQual(double trueProb, byte maxQual) {
        Utils.validateArg(MathUtils.isValidProbability(trueProb), () -> "trueProb must be good probability but got " + trueProb);
        double lp = Math.round(-10.0 * MathUtils.log10OneMinusX(trueProb));
        return QualityUtils.boundQual((int)lp, maxQual);
    }

    public static byte trueProbToQual(double prob, int maxQual) {
        Utils.validateArg(maxQual >= 0 && maxQual <= 255, () -> "maxQual must be between 0-255 but got " + maxQual);
        return QualityUtils.trueProbToQual(prob, (byte)(maxQual & 0xFF));
    }

    public static double phredScaleCorrectRate(double trueRate) {
        return QualityUtils.phredScaleLog10ErrorRate(MathUtils.log10OneMinusX(trueRate));
    }

    public static double phredScaleErrorRate(double errorRate) {
        return QualityUtils.phredScaleLog10ErrorRate(Math.log10(errorRate));
    }

    public static double phredScaleLog10ErrorRate(double errorRateLog10) {
        Utils.validateArg(MathUtils.isValidLog10Probability(errorRateLog10), () -> "errorRateLog10 must be good probability but got " + errorRateLog10);
        return Math.abs(-10.0 * Math.max(errorRateLog10, MIN_LOG10_SCALED_QUAL));
    }

    public static double phredScaleLog10CorrectRate(double trueRateLog10) {
        return QualityUtils.phredScaleCorrectRate(Math.pow(10.0, trueRateLog10));
    }

    public static byte boundQual(int qual) {
        return QualityUtils.boundQual(qual, (byte)93);
    }

    public static byte boundQual(int qual, byte maxQual) {
        return (byte)(Math.max(Math.min(qual, maxQual & 0xFF), 1) & 0xFF);
    }

    public static double phredSum(double[] phreds) {
        switch (phreds.length) {
            case 0: {
                return Double.MAX_VALUE;
            }
            case 1: {
                return phreds[0];
            }
            case 2: {
                return QualityUtils.phredSum(phreds[0], phreds[1]);
            }
            case 3: {
                return QualityUtils.phredSum(phreds[0], phreds[1], phreds[2]);
            }
        }
        double[] log10Vals = new double[phreds.length];
        for (int i = 0; i < log10Vals.length; ++i) {
            log10Vals[i] = phreds[i] * -0.1;
        }
        return -10.0 * MathUtils.log10SumLog10(log10Vals);
    }

    public static double phredSum(double a, double b) {
        return -10.0 * MathUtils.log10SumLog10(a * -0.1, b * -0.1);
    }

    public static double phredSum(double a, double b, double c) {
        return -10.0 * MathUtils.log10SumLog10(a * -0.1, b * -0.1, c * -0.1);
    }

    static {
        for (int i = 0; i <= 254; ++i) {
            QualityUtils.qualToErrorProbCache[i] = QualityUtils.qualToErrorProb(i);
            QualityUtils.qualToProbLog10Cache[i] = Math.log10(1.0 - qualToErrorProbCache[i]);
        }
    }
}

