/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.R;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.R.RScriptExecutorException;
import org.broadinstitute.hellbender.utils.R.RScriptLibrary;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.runtime.ScriptExecutor;

public final class RScriptExecutor
extends ScriptExecutor {
    private static final Logger logger = LogManager.getLogger(RScriptExecutor.class);
    private final List<RScriptLibrary> libraries = new ArrayList<RScriptLibrary>();
    private final List<Resource> scriptResources = new ArrayList<Resource>();
    private final List<File> scriptFiles = new ArrayList<File>();
    private final List<String> args = new ArrayList<String>();

    public RScriptExecutor() {
        this(false);
    }

    public RScriptExecutor(boolean ensureExecutableExists) {
        super("Rscript");
        if (ensureExecutableExists && !this.externalExecutableExists()) {
            this.executableMissing();
        }
    }

    public void addLibrary(RScriptLibrary library) {
        this.libraries.add(library);
    }

    public void addScript(Resource script) {
        this.scriptResources.add(script);
    }

    public void addScript(File script) {
        this.scriptFiles.add(script);
    }

    public void addArgs(Object ... args) {
        for (Object arg : args) {
            this.args.add(arg.toString());
        }
    }

    @Override
    public String getApproximateCommandLine() {
        StringBuilder command = new StringBuilder("Rscript");
        for (Resource resource : this.scriptResources) {
            command.append(" (resource)").append(resource.getFullPath());
        }
        for (File file : this.scriptFiles) {
            command.append(" ").append(file.getAbsolutePath());
        }
        for (String string : this.args) {
            command.append(" ").append(string);
        }
        return command.toString();
    }

    @Override
    public RScriptExecutorException getScriptException(String message) {
        return new RScriptExecutorException(message.toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean exec() {
        try {
            void var5_15;
            File tempLibSourceDir = IOUtils.createTempDir("RlibSources.");
            File tempLibInstallationDir = IOUtils.createTempDir("Rlib.");
            StringBuilder expression = new StringBuilder("tempLibDir = '").append(tempLibInstallationDir).append("';");
            if (!this.libraries.isEmpty()) {
                Iterator<File> tempLibraryPaths = new ArrayList();
                for (RScriptLibrary library : this.libraries) {
                    File tempLibrary = library.writeLibraryToTempFile(tempLibSourceDir);
                    tempLibraryPaths.add((File)((Object)tempLibrary.getAbsolutePath()));
                }
                expression.append("install.packages(");
                expression.append("pkgs=c('").append(StringUtils.join(tempLibraryPaths, (String)"', '")).append("'), lib=tempLibDir, repos=NULL, type='source', ");
                expression.append("INSTALL_opts=c('--no-libs', '--no-data', '--no-help', '--no-demo', '--no-exec')");
                expression.append(");");
                for (RScriptLibrary library : this.libraries) {
                    expression.append("library('").append(library.getLibraryName()).append("', lib.loc=tempLibDir);");
                }
            }
            for (Resource resource : this.scriptResources) {
                File tempScript = IOUtils.writeTempResource(resource);
                expression.append("source('").append(tempScript.getAbsolutePath()).append("');");
            }
            for (File file : this.scriptFiles) {
                expression.append("source('").append(file.getAbsolutePath()).append("');");
            }
            String[] cmd = new String[this.args.size() + 3];
            int n = 0;
            cmd[n] = this.externalScriptExecutableName;
            cmd[++var5_13] = "-e";
            ++var5_15;
            cmd[++var5_14] = expression.toString();
            for (String arg : this.args) {
                cmd[++var5_16] = arg;
            }
            return this.executeCuratedArgs(cmd);
        }
        catch (GATKException e) {
            if (!this.ignoreExceptions) {
                throw e;
            }
            logger.warn(e.getMessage());
            return false;
        }
    }
}

