/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.R;

import java.io.File;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;

public enum RScriptLibrary {
    GSALIB("gsalib");

    public static final String R_LIBRARY_SUFFIX = ".tar.gz";
    private final String name;

    private RScriptLibrary(String name) {
        this.name = name;
    }

    public String getLibraryName() {
        return this.name;
    }

    public String getResourcePath() {
        return this.name + R_LIBRARY_SUFFIX;
    }

    public File writeTemp() {
        return IOUtils.writeTempResourceFromPath(this.getResourcePath(), RScriptLibrary.class);
    }

    public File writeLibraryToTempFile(File targetDir) {
        File libraryFile = IOUtils.createTempFileInDirectory(this.getLibraryName(), R_LIBRARY_SUFFIX, targetDir);
        IOUtils.writeResource(new Resource(this.getResourcePath(), RScriptLibrary.class), libraryFile);
        return libraryFile;
    }
}

