/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

public class SATagBuilder {
    private List<SARead> supplementaryReads;
    private final GATKRead read;
    private SARead thisRead;
    private static final String cigarRe = "\\*|([0-9]+[MIDNSHPX=])+";

    public SATagBuilder(GATKRead read) {
        Utils.nonNull(read);
        this.read = read;
        this.supplementaryReads = new LinkedList<SARead>();
        this.parseSATag();
    }

    public SATagBuilder clear() {
        this.supplementaryReads.clear();
        return this;
    }

    public SATagBuilder setSATag() {
        if (this.supplementaryReads.isEmpty()) {
            return this;
        }
        this.read.setAttribute("SA", this.getTag());
        return this;
    }

    private String getTag() {
        StringBuilder stringBuilder = new StringBuilder();
        for (SARead sa : this.supplementaryReads) {
            stringBuilder.append(sa.toString());
        }
        return stringBuilder.toString();
    }

    private void setPrimary(boolean p) {
        this.read.setIsSupplementaryAlignment(!p);
    }

    public SATagBuilder addTag(SATagBuilder otherTag) {
        if (otherTag.isPrimary()) {
            this.supplementaryReads.add(0, otherTag.getThisRead());
        } else {
            this.supplementaryReads.add(otherTag.getThisRead());
        }
        return this;
    }

    public SATagBuilder addTag(GATKRead otherRead) {
        if (!otherRead.isSupplementaryAlignment()) {
            this.supplementaryReads.add(0, new SARead(otherRead));
        } else {
            this.supplementaryReads.add(new SARead(otherRead));
        }
        return this;
    }

    public SATagBuilder removeTag(GATKRead read) {
        return this.removeTag(read.getContig(), read.getStart());
    }

    public SATagBuilder removeTag(SATagBuilder otherBuilder) {
        return this.removeTag(otherBuilder.read.getContig(), otherBuilder.read.getStart());
    }

    public SATagBuilder removeTag(String contig, int start) {
        String s = Integer.toString(start);
        for (int i = 0; i < this.supplementaryReads.size(); ++i) {
            SARead saRead = this.supplementaryReads.get(i);
            if (!saRead.contig.equals(contig) || !saRead.pos.equals(s)) continue;
            this.supplementaryReads.remove(i);
            --i;
        }
        return this;
    }

    private void parseSATag() {
        if (!this.read.hasAttribute("SA")) {
            return;
        }
        String[] tags = this.read.getAttributeAsString("SA").split(";");
        this.supplementaryReads = Arrays.stream(tags).map(r -> new SARead((String)r)).collect(Collectors.toList());
    }

    private boolean isPrimary() {
        return !this.read.isSupplementaryAlignment();
    }

    private SARead getThisRead() {
        if (this.thisRead == null && this.read != null) {
            this.thisRead = new SARead(this.read);
        }
        return this.thisRead;
    }

    public List<GATKRead> getArtificialReadsBasedOnSATag(SAMFileHeader header) {
        ArrayList<GATKRead> output = new ArrayList<GATKRead>(this.supplementaryReads.size());
        GATKRead readCopy = this.read.copy();
        readCopy.setAttribute("SA", this.getTag());
        SAMRecord record = readCopy.convertToSAMRecord(header);
        List readRecords = SAMUtils.getOtherCanonicalAlignments((SAMRecord)record);
        for (SAMRecord artificialRead : readRecords) {
            output.add(new SAMRecordToGATKReadAdapter(artificialRead));
        }
        return output;
    }

    public static void setReadsAsSupplemental(GATKRead primaryRead, List<GATKRead> supplementalReads) {
        ArrayList<SATagBuilder> supplementalTags = new ArrayList<SATagBuilder>();
        supplementalTags.add(new SATagBuilder(primaryRead));
        for (GATKRead read : supplementalReads) {
            read.setIsSupplementaryAlignment(true);
            supplementalTags.add(new SATagBuilder(read));
        }
        for (int i = 0; i < supplementalTags.size(); ++i) {
            for (int j = 0; j < supplementalTags.size(); ++j) {
                if (i == j) continue;
                ((SATagBuilder)supplementalTags.get(i)).addTag((SATagBuilder)supplementalTags.get(j));
            }
        }
        for (SATagBuilder read : supplementalTags) {
            read.setSATag();
        }
    }

    private static class SARead {
        String contig;
        String pos;
        String strand;
        String cigar;
        String mapQ;
        String NM;

        private SARead(String SATag) {
            String[] values = SATag.split(",", -1);
            if (values.length != 6) {
                throw new GATKException("Could not parse SATag: " + SATag);
            }
            if (!values[1].equals("*") && Integer.parseInt(values[1]) < 0) {
                throw new GATKException("Could not parse POS in SATag: " + SATag);
            }
            if (!values[3].matches(SATagBuilder.cigarRe)) {
                throw new GATKException("Could not parse cigar in SATag: " + SATag);
            }
            if (!values[4].equals("*") && Integer.parseInt(values[4]) < 0) {
                throw new GATKException("Could not parse MapQ in SATag: " + SATag);
            }
            this.contig = values[0];
            this.pos = values[1];
            this.strand = values[2];
            this.cigar = values[3];
            this.mapQ = values[4];
            this.NM = values[5];
        }

        private SARead(GATKRead read) {
            Utils.nonNull(read);
            this.contig = read.getContig();
            this.pos = read.getStart() + "";
            this.strand = read.isReverseStrand() ? "-" : "+";
            this.cigar = read.getCigar().toString();
            this.mapQ = read.getMappingQuality() + "";
            this.NM = read.hasAttribute("NM") ? read.getAttributeAsString("NM") : "*";
        }

        public String toString() {
            return String.format("%s,%s,%s,%s,%s,%s;", this.contig != null ? this.contig : "*", this.pos != null ? this.pos : "0", this.strand.equals("-") ? "-" : "+", this.cigar != null ? this.cigar : "*", this.mapQ != null ? this.mapQ : "255", this.NM != null ? this.NM : "*");
        }
    }
}

