/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Locatable;
import java.io.Serializable;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class SimpleInterval
implements Locatable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final char CONTIG_SEPARATOR = ':';
    public static final char START_END_SEPARATOR = '-';
    public static final String END_OF_CONTIG = "+";
    private final int start;
    private final int end;
    private final String contig;

    public SimpleInterval(String contig, int start, int end) {
        SimpleInterval.validatePositions(contig, start, end);
        this.contig = contig;
        this.start = start;
        this.end = end;
    }

    public SimpleInterval(Locatable locatable) {
        this(Utils.nonNull(locatable).getContig(), locatable.getStart(), locatable.getEnd());
    }

    static void validatePositions(String contig, int start, int end) {
        Utils.validateArg(SimpleInterval.isValid(contig, start, end), () -> "Invalid interval. Contig:" + contig + " start:" + start + " end:" + end);
    }

    public static boolean isValid(String contig, int start, int end) {
        return contig != null && start > 0 && end >= start;
    }

    public SimpleInterval(String str) {
        int end;
        int start;
        String contig;
        Utils.nonNull(str);
        Utils.validateArg(!str.isEmpty(), "str should not be empty");
        int colonIndex = str.lastIndexOf(58);
        if (colonIndex == -1) {
            contig = str;
            start = 1;
            end = Integer.MAX_VALUE;
        } else {
            contig = str.substring(0, colonIndex);
            int dashIndex = str.indexOf(45, colonIndex);
            if (dashIndex == -1) {
                if (str.endsWith(END_OF_CONTIG)) {
                    start = SimpleInterval.parsePosition(str.substring(colonIndex + 1, str.length() - 1));
                    end = Integer.MAX_VALUE;
                } else {
                    end = start = SimpleInterval.parsePosition(str.substring(colonIndex + 1));
                }
            } else {
                start = SimpleInterval.parsePosition(str.substring(colonIndex + 1, dashIndex));
                end = SimpleInterval.parsePosition(str.substring(dashIndex + 1));
            }
        }
        SimpleInterval.validatePositions(contig, start, end);
        this.contig = contig;
        this.start = start;
        this.end = end;
    }

    static int parsePositionThrowOnFailure(String pos) throws NumberFormatException {
        return Integer.parseInt(pos.replaceAll(",", ""));
    }

    static int parsePosition(String pos) {
        try {
            return SimpleInterval.parsePositionThrowOnFailure(pos);
        }
        catch (NumberFormatException e) {
            throw new UserException("Problem parsing start/end value in interval string. Value was: " + pos, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInterval that = (SimpleInterval)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        return this.contig.equals(that.contig);
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.contig.hashCode();
        return result;
    }

    public String toString() {
        return IntervalUtils.locatableToString(this);
    }

    public String getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.start;
    }

    public long getGA4GHStart() {
        return this.start - 1;
    }

    public int getEnd() {
        return this.end;
    }

    public long getGA4GHEnd() {
        return this.end;
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public boolean overlaps(Locatable other) {
        return this.overlapsWithMargin(other, 0);
    }

    public boolean overlapsWithMargin(Locatable other, int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("given margin is negative: " + margin + "\tfor this: " + this.toString() + "\tand that: " + (other == null ? "other is null" : other.toString()));
        }
        if (other == null || other.getContig() == null) {
            return false;
        }
        return this.contig.equals(other.getContig()) && this.start <= other.getEnd() + margin && other.getStart() - margin <= this.end;
    }

    public boolean contains(Locatable other) {
        if (other == null || other.getContig() == null) {
            return false;
        }
        return this.contig.equals(other.getContig()) && this.start <= other.getStart() && this.end >= other.getEnd();
    }

    public SimpleInterval intersect(Locatable that) {
        Utils.validateArg(this.overlaps(that), () -> "SimpleInterval::intersect(): The two intervals need to overlap " + this + " " + that);
        return new SimpleInterval(this.getContig(), Math.max(this.getStart(), that.getStart()), Math.min(this.getEnd(), that.getEnd()));
    }

    public SimpleInterval mergeWithContiguous(Locatable that) {
        Utils.nonNull(that);
        if (!this.contiguous(that)) {
            throw new GATKException("The two intervals need to be contiguous: " + this + " " + that);
        }
        return new SimpleInterval(this.getContig(), Math.min(this.getStart(), that.getStart()), Math.max(this.getEnd(), that.getEnd()));
    }

    public SimpleInterval spanWith(Locatable other) {
        Utils.nonNull(other);
        Utils.validateArg(this.getContig().equals(other.getContig()), "Cannot get span for intervals on different contigs");
        return new SimpleInterval(this.contig, Math.min(this.start, other.getStart()), Math.max(this.end, other.getEnd()));
    }

    private boolean contiguous(Locatable that) {
        Utils.nonNull(that);
        return this.getContig().equals(that.getContig()) && this.getStart() <= that.getEnd() + 1 && that.getStart() <= this.getEnd() + 1;
    }

    public SimpleInterval expandWithinContig(int padding, int contigLength) {
        Utils.validateArg(padding >= 0, "padding must be >= 0");
        return IntervalUtils.trimIntervalToContig(this.contig, this.start - padding, this.end + padding, contigLength);
    }

    public SimpleInterval expandWithinContig(int padding, SAMSequenceDictionary sequenceDictionary) {
        Utils.nonNull(sequenceDictionary);
        SAMSequenceRecord contigRecord = sequenceDictionary.getSequence(this.contig);
        Utils.nonNull(contigRecord, () -> "Contig " + this.contig + " not found in provided dictionary");
        return this.expandWithinContig(padding, contigRecord.getSequenceLength());
    }
}

