/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.tribble.util.ParsingUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.NGSPlatform;

public final class Utils {
    public static final Comparator<? super String> COMPARE_STRINGS_NULLS_FIRST = Comparator.nullsFirst(Comparator.naturalOrder());
    private static final DateTimeFormatter longDateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
    private static final long GATK_RANDOM_SEED = 47382911L;
    private static final Random randomGenerator = new Random(47382911L);
    private static final RandomDataGenerator randomDataGenerator = new RandomDataGenerator((RandomGenerator)new Well19937c(47382911L));
    private static final int TEXT_WARNING_WIDTH = 68;
    private static final String TEXT_WARNING_PREFIX = "* ";
    private static final String TEXT_WARNING_BORDER = StringUtils.repeat((char)'*', (int)("* ".length() + 68));
    private static final char ESCAPE_CHAR = '\u001b';
    public static final float JAVA_DEFAULT_HASH_LOAD_FACTOR = 0.75f;
    private static final Logger logger = LogManager.getLogger(Utils.class);

    private Utils() {
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public static RandomDataGenerator getRandomDataGenerator() {
        return randomDataGenerator;
    }

    public static void resetRandomGenerator() {
        randomGenerator.setSeed(47382911L);
        randomDataGenerator.reSeed(47382911L);
    }

    public static <T> List<T> cons(T elt, List<T> l) {
        ArrayList<T> l2 = new ArrayList<T>();
        l2.add(elt);
        if (l != null) {
            l2.addAll(l);
        }
        return l2;
    }

    public static void warnUser(String msg) {
        Utils.warnUser(logger, msg);
    }

    public static void warnUser(Logger logger, String msg) {
        for (String line : Utils.warnUserLines(msg)) {
            logger.warn(line);
        }
    }

    public static List<String> warnUserLines(String msg) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(TEXT_WARNING_BORDER);
        results.add("* WARNING:");
        results.add(TEXT_WARNING_PREFIX);
        Utils.prettyPrintWarningMessage(results, msg);
        results.add(TEXT_WARNING_BORDER);
        return results;
    }

    private static void prettyPrintWarningMessage(List<String> results, String message) {
        for (String line : message.split("\\r?\\n")) {
            StringBuilder builder = new StringBuilder(line);
            while (builder.length() > 68) {
                int space = Utils.getLastSpace(builder, 68);
                if (space <= 0) {
                    space = 68;
                }
                results.add(String.format("%s%s", TEXT_WARNING_PREFIX, builder.substring(0, space)));
                builder.delete(0, space + 1);
            }
            results.add(String.format("%s%s", TEXT_WARNING_PREFIX, builder));
        }
    }

    private static int getLastSpace(CharSequence message, int width) {
        int length = message.length();
        int stopPos = width;
        int lastSpace = -1;
        boolean inEscape = false;
        for (int currPos = 0; currPos < stopPos && currPos < length; ++currPos) {
            char c = message.charAt(currPos);
            if (c == '\u001b') {
                ++stopPos;
                inEscape = true;
                continue;
            }
            if (inEscape) {
                ++stopPos;
                if (!Character.isLetter(c)) continue;
                inEscape = false;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            lastSpace = currPos;
        }
        return lastSpace;
    }

    public static String join(CharSequence separator, Object ... objects) {
        Utils.nonNull(separator, "the separator cannot be null");
        Utils.nonNull(objects, "the value array cannot be null");
        if (objects.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(objects[0]);
        for (int i = 1; i < objects.length; ++i) {
            ret.append(separator).append(objects[i]);
        }
        return ret.toString();
    }

    public static String join(String separator, int[] ints) {
        Utils.nonNull(separator, "the separator cannot be null");
        Utils.nonNull(ints, "the ints cannot be null");
        if (ints.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(ints[0]);
        for (int i = 1; i < ints.length; ++i) {
            ret.append(separator);
            ret.append(ints[i]);
        }
        return ret.toString();
    }

    public static String join(String separator, double[] doubles) {
        Utils.nonNull(separator, "the separator cannot be null");
        Utils.nonNull(doubles, "the doubles cannot be null");
        if (doubles.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(doubles[0]);
        for (int i = 1; i < doubles.length; ++i) {
            ret.append(separator);
            ret.append(doubles[i]);
        }
        return ret.toString();
    }

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static byte[] concat(byte[] ... allBytes) {
        if (allBytes.length == 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (allBytes.length == 1) {
            return allBytes[0].length == 0 ? allBytes[0] : (byte[])allBytes[0].clone();
        }
        int size = 0;
        for (byte[] bytes : allBytes) {
            size += bytes.length;
        }
        if (size == 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] c = new byte[size];
        int offset = 0;
        for (byte[] bytes : allBytes) {
            System.arraycopy(bytes, 0, c, offset, bytes.length);
            offset += bytes.length;
        }
        return c;
    }

    public static <T> T[] concat(T[] a, T[] b, IntFunction<T[]> constructor) {
        Utils.nonNull(a);
        Utils.nonNull(b);
        if (a.length != 0) {
            if (b.length != 0) {
                T[] c = constructor.apply(a.length + b.length);
                System.arraycopy(a, 0, c, 0, a.length);
                System.arraycopy(b, 0, c, a.length, b.length);
                return c;
            }
            return (Object[])a.clone();
        }
        if (b.length != 0) {
            return (Object[])b.clone();
        }
        return (Object[])a.clone();
    }

    public static byte[] concat(byte[] a, byte[] b) {
        int length = a.length + b.length;
        if (length == 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (length == a.length) {
            return (byte[])a.clone();
        }
        if (length == b.length) {
            return (byte[])b.clone();
        }
        byte[] c = new byte[length];
        int i = 0;
        for (byte aa : a) {
            c[i++] = aa;
        }
        for (byte bb : b) {
            c[i++] = bb;
        }
        return c;
    }

    public static List<Integer> asList(final int ... values) {
        Utils.nonNull(values, "the input array cannot be null");
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return values[index];
            }

            @Override
            public int size() {
                return values.length;
            }
        };
    }

    public static List<Double> asList(final double ... values) {
        Utils.nonNull(values, "the input array cannot be null");
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return values[index];
            }

            @Override
            public int size() {
                return values.length;
            }
        };
    }

    @SafeVarargs
    public static <T> List<T> append(List<T> left, T ... elts) {
        Utils.nonNull(left, "left is null");
        Utils.nonNull(elts, "the input array cannot be null");
        LinkedList<T> l = new LinkedList<T>(left);
        for (T t : elts) {
            Utils.nonNull(t, "t is null");
            l.add(t);
        }
        return l;
    }

    public static String dupChar(char c, int nCopies) {
        char[] chars = new char[nCopies];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static String dupString(String s, int nCopies) {
        if (s == null || s.equals("")) {
            throw new IllegalArgumentException("Bad s " + s);
        }
        if (nCopies < 0) {
            throw new IllegalArgumentException("nCopies must be >= 0 but got " + nCopies);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < nCopies; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    public static byte[] dupBytes(byte b, int nCopies) {
        byte[] bytes = new byte[nCopies];
        Arrays.fill(bytes, b);
        return bytes;
    }

    public static int countBooleanOccurrences(boolean element, boolean[] array) {
        Utils.nonNull(array);
        int count = 0;
        for (boolean b : array) {
            if (element != b) continue;
            ++count;
        }
        return count;
    }

    public static String[] escapeExpressions(String args) {
        Utils.nonNull(args);
        if (args.indexOf(39) != -1) {
            return Utils.escapeExpressions(args, "'");
        }
        if (args.indexOf(34) != -1) {
            return Utils.escapeExpressions(args, "\"");
        }
        return args.trim().split(" +");
    }

    private static String[] escapeExpressions(String args, String delimiter) {
        Object[] command = new String[]{};
        String[] split = args.split(delimiter);
        for (int i = 0; i < split.length - 1; i += 2) {
            String arg = split[i].trim();
            if (!arg.isEmpty()) {
                command = (String[])ArrayUtils.addAll((Object[])command, (Object[])arg.split(" +"));
            }
            command = (String[])ArrayUtils.addAll((Object[])command, (Object[])new String[]{split[i + 1]});
        }
        String arg = split[split.length - 1].trim();
        if (split.length % 2 == 1 && !arg.isEmpty()) {
            command = (String[])ArrayUtils.addAll((Object[])command, (Object[])arg.split(" +"));
        }
        return command;
    }

    public static byte[] repeatChars(char c, int n) {
        return Utils.repeatBytes((byte)c, n);
    }

    public static byte[] repeatBytes(byte b, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative length");
        }
        byte[] bytes = new byte[n];
        Arrays.fill(bytes, b);
        return bytes;
    }

    public static <T> List<List<T>> makePermutations(List<T> objects, int n, boolean withReplacement) {
        ArrayList<List<T>> combinations;
        block4: {
            block3: {
                combinations = new ArrayList<List<T>>();
                if (n != 1) break block3;
                for (T o : objects) {
                    combinations.add(Collections.singletonList(o));
                }
                break block4;
            }
            if (n <= 1) break block4;
            List<List<T>> sub = Utils.makePermutations(objects, n - 1, withReplacement);
            for (List<T> subI : sub) {
                for (T a : objects) {
                    if (!withReplacement && subI.contains(a)) continue;
                    combinations.add(Utils.cons(a, subI));
                }
            }
        }
        return combinations;
    }

    public static String calcMD5(String s) {
        Utils.nonNull(s, "s is null");
        return Utils.calcMD5(s.getBytes());
    }

    public static String calcMD5(byte[] bytes) {
        Utils.nonNull(bytes, "the input array cannot be null");
        try {
            return Utils.MD5ToString(MessageDigest.getInstance("MD5").digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 digest algorithm not present", e);
        }
    }

    public static String calculateFileMD5(File file) throws IOException {
        return Utils.calculatePathMD5(file.toPath());
    }

    public static String calculatePathMD5(Path path) throws IOException {
        String fname = path.toUri().toString();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("File '" + fname + "' does not exist");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("File '" + fname + "' exists but is a directory");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("File '" + fname + "' exists but is not a regular file");
        }
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = new byte[8192];
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            while ((bytesRead = is.read(buff)) > 0) {
                md.update(buff, 0, bytesRead);
            }
            return Utils.MD5ToString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 digest algorithm not present", e);
        }
    }

    private static String MD5ToString(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String md5String = bigInt.toString(16);
        return StringUtils.repeat((String)"0", (int)(32 - md5String.length())) + md5String;
    }

    public static <T> T nonNull(T object) {
        return Utils.nonNull(object, "Null object is not allowed here.");
    }

    public static <T> T nonNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static <T> T nonNull(T object, Supplier<String> message) {
        if (object == null) {
            throw new IllegalArgumentException(message.get());
        }
        return object;
    }

    public static <I, T extends Collection<I>> T nonEmpty(T collection, String message) {
        Utils.nonNull(collection, "The collection is null: " + message);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("The collection is empty: " + message);
        }
        return collection;
    }

    public static boolean isNonEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static String nonEmpty(String string, String message) {
        Utils.nonNull(string, "The string is null: " + message);
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The string is empty: " + message);
        }
        return string;
    }

    public static String nonEmpty(String string) {
        return Utils.nonEmpty(string, "string must not be null or empty");
    }

    public static <I, T extends Collection<I>> T nonEmpty(T collection) {
        return Utils.nonEmpty(collection, "collection must not be null or empty.");
    }

    public static void containsNoNull(Collection<?> collection, String message) {
        Utils.nonNull(collection, message);
        if (collection.stream().anyMatch(v -> v == null)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <E> Set<E> checkForDuplicatesAndReturnSet(Collection<E> c, String message) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        for (E element : c) {
            if (set.add(element)) continue;
            throw new IllegalArgumentException(String.format(message + "  Value %s appears more than once.", element.toString()));
        }
        return set;
    }

    public static int validIndex(int index, int length) {
        if (index < 0) {
            throw new IllegalArgumentException("the index cannot be negative: " + index);
        }
        if (index >= length) {
            throw new IllegalArgumentException("the index points past the last element of the collection or array: " + index + " > " + (length - 1));
        }
        return index;
    }

    public static int validIndex(int index, int length, String errorMessage) {
        if (index < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (index >= length) {
            throw new IllegalArgumentException(errorMessage);
        }
        return index;
    }

    public static void validateArg(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validateArg(boolean condition, Supplier<String> msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg.get());
        }
    }

    public static void validate(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalStateException(msg);
        }
    }

    public static void validate(boolean condition, Supplier<String> msg) {
        if (!condition) {
            throw new IllegalStateException(msg.get());
        }
    }

    public static int optimumHashSize(int maxElements) {
        return (int)((float)maxElements / 0.75f) + 2;
    }

    public static boolean equalRange(byte[] left, int leftOffset, byte[] right, int rightOffset, int length) {
        Utils.nonNull(left, "left cannot be null");
        Utils.nonNull(right, "right cannot be null");
        Utils.validRange(length, leftOffset, left.length, "left");
        Utils.validRange(length, rightOffset, right.length, "right");
        for (int i = 0; i < length; ++i) {
            if (left[leftOffset + i] == right[rightOffset + i]) continue;
            return false;
        }
        return true;
    }

    private static void validRange(int length, int offset, int size, String msg) {
        if (length < 0) {
            throw new IllegalArgumentException(msg + " length cannot be negative");
        }
        if (offset < 0) {
            throw new IllegalArgumentException(msg + " offset cannot be negative");
        }
        if (offset + length > size) {
            throw new IllegalArgumentException(msg + " length goes beyond end of left array");
        }
    }

    public static <T> T skimArray(T original, boolean[] remove) {
        return Utils.skimArray(original, 0, null, 0, remove, 0);
    }

    public static <T> T skimArray(T source, int sourceOffset, T dest, int destOffset, boolean[] remove, int removeOffset) {
        Utils.nonNull(source, "the source array cannot be null");
        Class<?> sourceClazz = source.getClass();
        if (!sourceClazz.isArray()) {
            throw new IllegalArgumentException("the source array is not in fact an array instance");
        }
        int length = Array.getLength(source) - sourceOffset;
        if (length < 0) {
            throw new IllegalArgumentException("the source offset goes beyond the source array length");
        }
        return Utils.skimArray(source, sourceOffset, dest, destOffset, remove, removeOffset, length);
    }

    public static <T> T skimArray(T source, int sourceOffset, T dest, int destOffset, boolean[] remove, int removeOffset, int length) {
        Utils.nonNull(source, "the source array cannot be null");
        Utils.nonNull(remove, "the remove array cannot be null");
        if (sourceOffset < 0) {
            throw new IllegalArgumentException("the source array offset cannot be negative");
        }
        if (destOffset < 0) {
            throw new IllegalArgumentException("the destination array offset cannot be negative");
        }
        if (removeOffset < 0) {
            throw new IllegalArgumentException("the remove array offset cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("the length provided cannot be negative");
        }
        int removeLength = Math.min(remove.length - removeOffset, length);
        if (removeLength < 0) {
            throw new IllegalArgumentException("the remove offset provided falls beyond the remove array end");
        }
        Class<?> sourceClazz = source.getClass();
        if (!sourceClazz.isArray()) {
            throw new IllegalArgumentException("the source array is not in fact an array instance");
        }
        Class<T> destClazz = Utils.skimArrayDetermineDestArrayClass(dest, sourceClazz);
        int sourceLength = Array.getLength(source);
        if (sourceLength < length + sourceOffset) {
            throw new IllegalArgumentException("the source array is too small considering length and offset");
        }
        int removeCount = 0;
        int removeEnd = removeLength + removeOffset;
        for (int i = removeOffset; i < removeEnd; ++i) {
            if (!remove[i]) continue;
            ++removeCount;
        }
        int newLength = length - removeCount;
        T result = Utils.skimArrayBuildResultArray(dest, destOffset, destClazz, newLength);
        if (removeCount == 0) {
            System.arraycopy(source, sourceOffset, result, destOffset, length);
        } else if (length > 0) {
            int copyLength;
            int nextOriginalIndex = 0;
            int nextRemoveIndex = removeOffset;
            for (int nextNewIndex = 0; nextOriginalIndex < length && nextNewIndex < newLength; nextNewIndex += copyLength) {
                while (nextRemoveIndex < removeEnd && remove[nextRemoveIndex++]) {
                    ++nextOriginalIndex;
                }
                int copyStart = nextOriginalIndex;
                while (!(++nextOriginalIndex >= length || nextRemoveIndex < removeEnd && remove[nextRemoveIndex])) {
                    ++nextRemoveIndex;
                }
                int copyEnd = nextOriginalIndex;
                copyLength = copyEnd - copyStart;
                System.arraycopy(source, sourceOffset + copyStart, result, destOffset + nextNewIndex, copyLength);
            }
        }
        return result;
    }

    private static <T> T skimArrayBuildResultArray(T dest, int destOffset, Class<T> destClazz, int newLength) {
        Object result;
        if (dest == null) {
            result = Array.newInstance(destClazz.getComponentType(), newLength + destOffset);
        } else if (Array.getLength(dest) < newLength + destOffset) {
            result = Array.newInstance(destClazz.getComponentType(), newLength + destOffset);
            if (destOffset > 0) {
                System.arraycopy(dest, 0, result, 0, destOffset);
            }
        } else {
            result = dest;
        }
        return (T)result;
    }

    private static <T> Class<T> skimArrayDetermineDestArrayClass(T dest, Class<T> sourceClazz) {
        Class<Object> destClazz;
        if (dest == null) {
            destClazz = sourceClazz;
        } else {
            destClazz = dest.getClass();
            if (destClazz != sourceClazz) {
                if (!destClazz.isArray()) {
                    throw new IllegalArgumentException("the destination array class must be an array");
                }
                if (sourceClazz.getComponentType().isAssignableFrom(destClazz.getComponentType())) {
                    throw new IllegalArgumentException("the provided destination array class cannot contain values from the source due to type incompatibility");
                }
            }
        }
        return destClazz;
    }

    public static void warnOnNonIlluminaReadGroups(SAMFileHeader readsHeader, Logger logger) {
        Utils.nonNull(readsHeader, "header");
        Utils.nonNull(logger, "logger");
        if (readsHeader.getReadGroups().stream().anyMatch(rg -> NGSPlatform.fromReadGroupPL(rg.getPlatform()) != NGSPlatform.ILLUMINA)) {
            logger.warn("This tool has only been well tested on ILLUMINA-based sequencing data. For other data use at your own risk.");
        }
    }

    public static boolean xor(boolean x, boolean y) {
        return x != y;
    }

    public static int lastIndexOf(byte[] reference, byte[] query) {
        int queryLength = query.length;
        for (int r = reference.length - queryLength; r >= 0; --r) {
            int q;
            for (q = 0; q < queryLength && reference[r + q] == query[q]; ++q) {
            }
            if (q != queryLength) continue;
            return r;
        }
        return -1;
    }

    public static List<Integer> listFromPrimitives(int[] ar) {
        Utils.nonNull(ar);
        return Ints.asList((int[])ar);
    }

    public static <T> Iterator<T> concatIterators(final Iterator<? extends Iterable<T>> iterator) {
        Utils.nonNull(iterator, "iterator");
        return new AbstractIterator<T>(){
            Iterator<T> subIterator;

            protected T computeNext() {
                if (this.subIterator != null && this.subIterator.hasNext()) {
                    return this.subIterator.next();
                }
                while (iterator.hasNext()) {
                    this.subIterator = ((Iterable)iterator.next()).iterator();
                    if (!this.subIterator.hasNext()) continue;
                    return this.subIterator.next();
                }
                return this.endOfData();
            }
        };
    }

    public static <T> Stream<T> stream(Enumeration<T> enumeration) {
        return Utils.stream(Iterators.forEnumeration(enumeration));
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return Utils.stream(() -> iterator);
    }

    public static <T> java.util.function.Function<T, T> identityFunction() {
        return (java.util.function.Function<Object, Object> & Serializable)t -> t;
    }

    public static <F, T> Iterator<T> transformParallel(final Iterator<F> fromIterator, final java.util.function.Function<F, T> function, final int numThreads) {
        Utils.nonNull(fromIterator, "fromIterator");
        Utils.nonNull(function, "function");
        Utils.validateArg(numThreads >= 1, "numThreads must be at least 1");
        if (numThreads == 1) {
            return Iterators.transform(fromIterator, (Function)new Function<F, T>(){

                @Nullable
                public T apply(@Nullable F input) {
                    return function.apply(input);
                }
            });
        }
        final ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        final LinkedList futures = new LinkedList();
        return new AbstractIterator<T>(){

            protected T computeNext() {
                try {
                    while (fromIterator.hasNext()) {
                        if (futures.size() == numThreads) {
                            return ((Future)futures.remove()).get();
                        }
                        Object next = fromIterator.next();
                        Future<Object> future = executorService.submit(() -> function.apply(next));
                        futures.add(future);
                    }
                    if (!futures.isEmpty()) {
                        return ((Future)futures.remove()).get();
                    }
                    executorService.shutdown();
                    return this.endOfData();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new GATKException("Problem running task", e);
                }
            }
        };
    }

    public static <T> Set<T> getDuplicatedItems(Collection<T> objects) {
        HashSet unique = new HashSet();
        return objects.stream().filter(name -> !unique.add(name)).collect(Collectors.toSet());
    }

    public static String getDateTimeForDisplay(ZonedDateTime dateTime) {
        return dateTime.format(longDateTimeFormatter);
    }

    public static void forceJVMLocaleToUSEnglish() {
        Locale.setDefault(Locale.US);
    }

    public static <T extends Comparable<?>> T getMedianValue(List<T> values) {
        List sorted = values.stream().sorted().collect(Collectors.toList());
        return (T)((Comparable)sorted.get(sorted.size() / 2));
    }

    public static List<String> split(String str, char delimiter) {
        ArrayList<String> tokens;
        if (str.isEmpty()) {
            tokens = new ArrayList<String>(1);
            tokens.add("");
        } else {
            tokens = ParsingUtils.split((String)str, (char)delimiter);
            Utils.removeTrailingEmptyStringsFromEnd(tokens);
        }
        return tokens;
    }

    public static List<String> split(String str, String delimiter) {
        return Utils.split(str, delimiter, 10);
    }

    private static List<String> split(String str, String delimiter, int expectedNumTokens) {
        List<String> result;
        if (str.isEmpty()) {
            result = new ArrayList<String>(1);
            result.add("");
        } else if (delimiter.isEmpty()) {
            result = new ArrayList(str.length());
            for (int i = 0; i < str.length(); ++i) {
                result.add(str.substring(i, i + 1));
            }
        } else if (delimiter.length() == 1) {
            result = Utils.split(str, delimiter.charAt(0));
        } else {
            result = new ArrayList(expectedNumTokens);
            int delimiterIdx = -1;
            int tokenStartIdx = delimiterIdx + 1;
            do {
                String token = (delimiterIdx = str.indexOf(delimiter, tokenStartIdx)) != -1 ? str.substring(tokenStartIdx, delimiterIdx) : str.substring(tokenStartIdx);
                result.add(token);
                tokenStartIdx = delimiterIdx + delimiter.length();
            } while (delimiterIdx != -1);
            Utils.removeTrailingEmptyStringsFromEnd(result);
        }
        return result;
    }

    private static void removeTrailingEmptyStringsFromEnd(List<String> result) {
        while (!result.isEmpty() && result.get(result.size() - 1).isEmpty()) {
            result.remove(result.size() - 1);
        }
    }

    public static <T, U> Map<U, Set<T>> getReverseValueToListMap(Map<T, List<U>> somethingToListMap) {
        HashMap result = new HashMap();
        for (Map.Entry entry : somethingToListMap.entrySet()) {
            entry.getValue().forEach(v -> result.computeIfAbsent(v, k -> new HashSet()).add(entry.getKey()));
        }
        return result;
    }

    public static String formattedPercent(long x, long total) {
        return total == 0L ? "NA" : String.format("%.2f", 100.0 * (double)x / (double)total);
    }

    public static String formattedRatio(long num, long denom) {
        return denom == 0L ? "NA" : String.format("%.2f", (double)num / (1.0 * (double)denom));
    }

    public static Set<String> filterCollectionByExpressions(Collection<String> sourceValues, Collection<String> filterExpressions, boolean exactMatch) {
        Utils.nonNull(filterExpressions);
        Utils.nonNull(sourceValues);
        LinkedHashSet<String> filteredValues = new LinkedHashSet<String>();
        Collection<Pattern> patterns = null;
        if (!exactMatch) {
            patterns = Utils.compilePatterns(filterExpressions);
        }
        block0: for (String value : sourceValues) {
            if (filterExpressions.contains(value)) {
                filteredValues.add(value);
                continue;
            }
            if (exactMatch) continue;
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(value).find()) continue;
                filteredValues.add(value);
                continue block0;
            }
        }
        return filteredValues;
    }

    private static Collection<Pattern> compilePatterns(Collection<String> filters) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String filter : filters) {
            patterns.add(Pattern.compile(filter));
        }
        return patterns;
    }

    public static <T> T runInParallel(int threads, Supplier<T> supplier) {
        ForkJoinPool threadPool = threads == 0 ? new ForkJoinPool() : new ForkJoinPool(threads);
        try {
            return (T)((ForkJoinTask)threadPool.submit(supplier::get)).get();
        }
        catch (InterruptedException e) {
            throw new GATKException("task interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new GATKException("exception when executing parallel task ", cause);
        }
    }
}

