/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;

public class ZipUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(GATKPath path, File dest, String ... files) {
        Utils.nonNull(path, "the path provided cannot be null");
        Utils.nonNull(dest, "the destination directory provided cannot be null");
        Utils.validateArg((dest.isDirectory() || dest.mkdirs()) && dest.canWrite(), "could not create destination directory");
        Predicate<File> selected = ZipUtils.composeSelectPredicate(files);
        try {
            ZipInputStream in = new ZipInputStream(path.getInputStream());
            Throwable throwable = null;
            block22: while (true) {
                try {
                    ZipEntry entry;
                    while ((entry = in.getNextEntry()) != null) {
                        if (!selected.test(new File(entry.getName()))) continue;
                        File entryDest = new File(dest, entry.getName());
                        if (entry.isDirectory()) {
                            entryDest.mkdirs();
                            continue;
                        }
                        File parent = entryDest.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        try {
                            FileOutputStream fos = new FileOutputStream(entryDest);
                            Throwable throwable2 = null;
                            try {
                                IOUtils.copy((InputStream)in, (OutputStream)fos);
                                continue block22;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fos == null) continue block22;
                                if (throwable2 != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue block22;
                                }
                                fos.close();
                                continue block22;
                            }
                        }
                        catch (IOException e) {
                            throw new GATKException("problems unzipping entry", e);
                            return;
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new UserException.CouldNotReadInputFile(path.toString(), (Exception)ex);
        }
    }

    public static void zip(File source, GATKPath dest, String ... files) {
        Utils.nonNull(source, "the destination directory provided cannot be null");
        Utils.nonNull(dest, "the destination cannot be null");
        if (source.isFile()) {
            if (files != null && files.length != 0) {
                throw new IllegalArgumentException("if the source is a regular file, you cannot specify a files to zip array");
            }
            ZipUtils.uncheckedZip(source.getParentFile(), dest, ZipUtils.composeSelectPredicate(source.toString()));
        } else {
            Predicate<File> selection = ZipUtils.composeSelectPredicate(files);
            ZipUtils.uncheckedZip(source, dest, selection);
        }
    }

    private static void uncheckedZip(File sourceRoot, GATKPath dest, Predicate<File> selection) {
        try (ZipOutputStream out = new ZipOutputStream(dest.getOutputStream());){
            ArrayDeque<File> pending = new ArrayDeque<File>();
            String prefix = sourceRoot.toString() + File.separator;
            pending.addAll(Arrays.asList(sourceRoot.listFiles()));
            while (!pending.isEmpty()) {
                File next = (File)pending.removeFirst();
                if (next.isFile()) {
                    if (!selection.test(next)) continue;
                    String relative = next.toString().replace(prefix, "");
                    out.putNextEntry(new ZipEntry(relative));
                    try (FileInputStream nextIs = new FileInputStream(next);){
                        IOUtils.copy((InputStream)nextIs, (OutputStream)out);
                    }
                    out.closeEntry();
                    continue;
                }
                if (!next.isDirectory()) continue;
                File[] children = next.listFiles();
                for (int i = children.length - 1; i >= 0; --i) {
                    pending.addFirst(children[i]);
                }
            }
        }
        catch (IOException ex) {
            throw new GATKException("errors trying to create zip file from " + sourceRoot + " to " + dest, ex);
        }
    }

    private static Predicate<File> composeSelectPredicate(String ... files) {
        if (files == null || files.length == 0) {
            return _x -> true;
        }
        Set selected = Arrays.stream(files).map(name -> new File((String)name).toPath().normalize().toFile()).collect(Collectors.toSet());
        return f -> selected.contains(f) || selected.contains(f.toPath().normalize().toFile());
    }
}

