/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.activityprofile;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;

public class ActivityProfile {
    protected final List<ActivityProfileState> stateList = new ArrayList<ActivityProfileState>();
    protected final int maxProbPropagationDistance;
    protected final double activeProbThreshold;
    protected SimpleInterval regionStartLoc = null;
    protected SimpleInterval regionStopLoc = null;
    protected SAMFileHeader samHeader;
    protected int contigLength = -1;

    public ActivityProfile(int maxProbPropagationDistance, double activeProbThreshold, SAMFileHeader header) {
        this.maxProbPropagationDistance = maxProbPropagationDistance;
        this.activeProbThreshold = activeProbThreshold;
        this.samHeader = header;
    }

    public String toString() {
        return "ActivityProfile{start=" + this.regionStartLoc + ", stop=" + this.regionStopLoc + '}';
    }

    public int getMaxProbPropagationDistance() {
        return this.maxProbPropagationDistance;
    }

    public int size() {
        return this.stateList.size();
    }

    public boolean isEmpty() {
        return this.stateList.isEmpty();
    }

    public SimpleInterval getSpan() {
        return this.isEmpty() ? null : this.regionStartLoc.spanWith(this.regionStopLoc);
    }

    public String getContig() {
        return this.regionStartLoc.getContig();
    }

    public int getEnd() {
        return this.regionStopLoc.getEnd();
    }

    protected List<ActivityProfileState> getStateList() {
        return this.stateList;
    }

    protected double[] getProbabilitiesAsArray() {
        double[] probs = new double[this.getStateList().size()];
        int i = 0;
        for (ActivityProfileState state : this.getStateList()) {
            probs[i++] = state.isActiveProb();
        }
        return probs;
    }

    protected SimpleInterval getLocForOffset(SimpleInterval relativeLoc, int offset) {
        Utils.nonNull(relativeLoc);
        int start = relativeLoc.getStart() + offset;
        if (start < 1 || start > this.getCurrentContigLength()) {
            return null;
        }
        return new SimpleInterval(this.regionStartLoc.getContig(), start, start);
    }

    private int getCurrentContigLength() {
        return this.contigLength;
    }

    public void add(ActivityProfileState state) {
        Utils.nonNull(state);
        SimpleInterval loc = state.getLoc();
        if (this.regionStartLoc == null) {
            this.regionStartLoc = loc;
            this.regionStopLoc = loc;
            this.contigLength = this.samHeader.getSequence(this.regionStartLoc.getContig()).getSequenceLength();
        } else {
            Utils.validateArg(this.regionStopLoc.getStart() == loc.getStart() - 1, () -> "Bad add call to ActivityProfile: loc " + loc + " not immediately after last loc " + this.regionStopLoc);
            this.regionStopLoc = loc;
        }
        Collection<ActivityProfileState> processedStates = this.processState(state);
        for (ActivityProfileState processedState : processedStates) {
            this.incorporateSingleState(processedState);
        }
    }

    private void incorporateSingleState(ActivityProfileState stateToAdd) {
        Utils.nonNull(stateToAdd);
        int position = stateToAdd.getOffset(this.regionStartLoc);
        Utils.validateArg(position <= this.size(), () -> "Must add state contiguous to existing states: adding " + stateToAdd);
        if (position >= 0) {
            if (position < this.size()) {
                this.stateList.get(position).setIsActiveProb(this.stateList.get(position).isActiveProb() + stateToAdd.isActiveProb());
            } else {
                Utils.validateArg(position == this.size(), "position == size but it wasn't");
                this.stateList.add(stateToAdd);
            }
        }
    }

    protected Collection<ActivityProfileState> processState(ActivityProfileState justAddedState) {
        if (justAddedState.getResultState().equals((Object)ActivityProfileState.Type.HIGH_QUALITY_SOFT_CLIPS)) {
            ArrayList<ActivityProfileState> states = new ArrayList<ActivityProfileState>();
            int numHQClips = Math.min(justAddedState.getResultValue().intValue(), this.getMaxProbPropagationDistance());
            for (int i = -numHQClips; i <= numHQClips; ++i) {
                SimpleInterval loc = this.getLocForOffset(justAddedState.getLoc(), i);
                if (loc == null) continue;
                states.add(new ActivityProfileState(loc, justAddedState.isActiveProb()));
            }
            return states;
        }
        return Collections.singletonList(justAddedState);
    }

    public List<AssemblyRegion> popReadyAssemblyRegions(int assemblyRegionExtension, int minRegionSize, int maxRegionSize, boolean forceConversion) {
        Utils.validateArg(assemblyRegionExtension >= 0, () -> "assemblyRegionExtension must be >= 0 but got " + assemblyRegionExtension);
        Utils.validateArg(minRegionSize > 0, () -> "minRegionSize must be >= 1 but got " + minRegionSize);
        Utils.validateArg(maxRegionSize > 0, () -> "maxRegionSize must be >= 1 but got " + maxRegionSize);
        ArrayList<AssemblyRegion> regions = new ArrayList<AssemblyRegion>();
        AssemblyRegion nextRegion;
        while ((nextRegion = this.popNextReadyAssemblyRegion(assemblyRegionExtension, minRegionSize, maxRegionSize, forceConversion)) != null) {
            regions.add(nextRegion);
        }
        return regions;
    }

    private AssemblyRegion popNextReadyAssemblyRegion(int assemblyRegionExtension, int minRegionSize, int maxRegionSize, boolean forceConversion) {
        ActivityProfileState first;
        boolean isActiveRegion;
        int offsetOfNextRegionEnd;
        if (this.stateList.isEmpty()) {
            return null;
        }
        if (forceConversion) {
            ArrayList<ActivityProfileState> statesToTrimAway = new ArrayList<ActivityProfileState>(this.stateList.subList(this.getSpan().size(), this.stateList.size()));
            this.stateList.removeAll(statesToTrimAway);
        }
        if ((offsetOfNextRegionEnd = this.findEndOfRegion(isActiveRegion = (first = this.stateList.get(0)).isActiveProb() > this.activeProbThreshold, minRegionSize, maxRegionSize, forceConversion)) == -1) {
            return null;
        }
        List<ActivityProfileState> sub = this.stateList.subList(0, offsetOfNextRegionEnd + 1);
        sub.clear();
        if (this.stateList.isEmpty()) {
            this.regionStopLoc = null;
            this.regionStartLoc = null;
        } else {
            this.regionStartLoc = this.stateList.get(0).getLoc();
        }
        SimpleInterval regionLoc = new SimpleInterval(first.getLoc().getContig(), first.getLoc().getStart(), first.getLoc().getStart() + offsetOfNextRegionEnd);
        return new AssemblyRegion(regionLoc, isActiveRegion, assemblyRegionExtension, this.samHeader);
    }

    private int findEndOfRegion(boolean isActiveRegion, int minRegionSize, int maxRegionSize, boolean forceConversion) {
        if (!forceConversion && this.stateList.size() < maxRegionSize + this.getMaxProbPropagationDistance()) {
            return -1;
        }
        int endOfActiveRegion = this.findFirstActivityBoundary(isActiveRegion, maxRegionSize);
        if (isActiveRegion && endOfActiveRegion == maxRegionSize) {
            endOfActiveRegion = this.findBestCutSite(endOfActiveRegion, minRegionSize);
        }
        return endOfActiveRegion - 1;
    }

    private int findBestCutSite(int endOfActiveRegion, int minRegionSize) {
        Utils.validateArg(endOfActiveRegion >= minRegionSize, "endOfActiveRegion must be >= minRegionSize");
        Utils.validateArg(minRegionSize >= 0, "minRegionSize must be >= 0");
        int minI = endOfActiveRegion - 1;
        double minP = Double.MAX_VALUE;
        for (int i = minI; i >= minRegionSize - 1; --i) {
            double cur = this.getProb(i);
            if (!(cur < minP) || !this.isMinimum(i)) continue;
            minP = cur;
            minI = i;
        }
        return minI + 1;
    }

    private int findFirstActivityBoundary(boolean isActiveRegion, int maxRegionSize) {
        int endOfActiveRegion;
        Utils.validateArg(maxRegionSize > 0, "maxRegionSize must be > 0");
        int nStates = this.stateList.size();
        for (endOfActiveRegion = 0; endOfActiveRegion < nStates && endOfActiveRegion < maxRegionSize && this.getProb(endOfActiveRegion) > this.activeProbThreshold == isActiveRegion; ++endOfActiveRegion) {
        }
        return endOfActiveRegion;
    }

    private double getProb(int index) {
        Utils.validIndex(index, this.stateList.size());
        return this.stateList.get(index).isActiveProb();
    }

    private boolean isMinimum(int index) {
        Utils.validIndex(index, this.stateList.size());
        if (index == this.stateList.size() - 1) {
            return false;
        }
        if (index < 1) {
            return false;
        }
        double indexP = this.getProb(index);
        return indexP <= this.getProb(index + 1) && indexP < this.getProb(index - 1);
    }
}

