/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.activityprofile;

import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class ActivityProfileState {
    private final SimpleInterval loc;
    private double activeProb;
    private final Type resultState;
    private final Number resultValue;
    private static final double PROBABILITY_TOLERANCE = 0.01;

    public double isActiveProb() {
        return this.activeProb;
    }

    public void setIsActiveProb(double activeProb) {
        this.activeProb = activeProb;
    }

    public Type getResultState() {
        return this.resultState;
    }

    public Number getResultValue() {
        return this.resultValue;
    }

    public ActivityProfileState(SimpleInterval loc, double activeProb) {
        this(loc, activeProb, Type.NONE, null);
    }

    public ActivityProfileState(SimpleInterval loc, double activeProb, Type resultState, Number resultValue) {
        if (loc.size() != 1) {
            throw new IllegalArgumentException("Location for an ActivityProfileState must have to size 1 bp but saw " + loc);
        }
        if (resultValue != null && resultValue.doubleValue() < 0.0) {
            throw new IllegalArgumentException("Result value isn't null and its < 0, which is illegal: " + resultValue);
        }
        this.loc = loc;
        this.setIsActiveProb(activeProb);
        this.resultState = resultState;
        this.resultValue = resultValue;
    }

    public int getOffset(Locatable regionStartLoc) {
        Utils.nonNull(regionStartLoc);
        return this.getLoc().getStart() - regionStartLoc.getStart();
    }

    public SimpleInterval getLoc() {
        return this.loc;
    }

    public String toString() {
        return "ActivityProfileState{loc=" + this.loc + ", activeProb=" + this.activeProb + ", resultState=" + (Object)((Object)this.resultState) + ", resultValue=" + this.resultValue + '}';
    }

    public static enum Type {
        NONE,
        HIGH_QUALITY_SOFT_CLIPS;

    }
}

