/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.activityprofile;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.broadinstitute.hellbender.engine.MultiIntervalShard;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;

public class ActivityProfileStateRange {
    private final SimpleInterval interval;
    private final double[] activeProb;
    private final ActivityProfileState.Type[] resultState;
    private final double[] resultValue;

    public ActivityProfileStateRange(MultiIntervalShard<?> shard, Iterator<ActivityProfileState> activityProfileStateIterator) {
        List<SimpleInterval> intervals = shard.getIntervals();
        this.interval = (SimpleInterval)Iterables.getOnlyElement(intervals);
        int size = this.interval.size();
        this.activeProb = new double[size];
        this.resultState = new ActivityProfileState.Type[size];
        this.resultValue = new double[size];
        int i = 0;
        ActivityProfileState prev = null;
        while (activityProfileStateIterator.hasNext()) {
            ActivityProfileState next = activityProfileStateIterator.next();
            if (prev != null) {
                Utils.validate(next.getLoc().getContig().equals(prev.getLoc().getContig()), "Contigs differ");
                Utils.validate(next.getLoc().getStart() == prev.getLoc().getStart() + 1, "Out of order");
            }
            this.activeProb[i] = next.isActiveProb();
            this.resultState[i] = next.getResultState();
            this.resultValue[i] = next.getResultValue() == null ? Double.NEGATIVE_INFINITY : next.getResultValue().doubleValue();
            ++i;
            prev = next;
        }
        Utils.validate(i == size, "Size is wrong");
    }

    public String getContig() {
        return this.interval.getContig();
    }

    private Iterator<ActivityProfileState> toIteratorActivityProfileState() {
        return new AbstractIterator<ActivityProfileState>(){
            int i = 0;

            protected ActivityProfileState computeNext() {
                if (this.i == ActivityProfileStateRange.this.interval.size()) {
                    return (ActivityProfileState)this.endOfData();
                }
                int pos = ActivityProfileStateRange.this.interval.getStart() + this.i;
                double v = ActivityProfileStateRange.this.resultValue[this.i];
                ActivityProfileState state = new ActivityProfileState(new SimpleInterval(ActivityProfileStateRange.this.interval.getContig(), pos, pos), ActivityProfileStateRange.this.activeProb[this.i], ActivityProfileStateRange.this.resultState[this.i], v == Double.NEGATIVE_INFINITY ? null : Double.valueOf(v));
                ++this.i;
                return state;
            }
        };
    }

    public static Iterator<ActivityProfileState> toIteratorActivityProfileState(Iterator<ActivityProfileStateRange> it) {
        Iterator iteratorOfIterators = Iterators.transform(it, (Function)new Function<ActivityProfileStateRange, Iterator<ActivityProfileState>>(){

            @Nullable
            public Iterator<ActivityProfileState> apply(@Nullable ActivityProfileStateRange input) {
                return input.toIteratorActivityProfileState();
            }
        });
        return Iterators.concat((Iterator)iteratorOfIterators);
    }
}

