/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.activityprofile;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayList;
import java.util.Collection;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfile;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;

public class BandPassActivityProfile
extends ActivityProfile {
    public static final int MAX_FILTER_SIZE = 50;
    private static final double MIN_PROB_TO_KEEP_IN_FILTER = 1.0E-5;
    public static final double DEFAULT_SIGMA = 17.0;
    private final int filterSize;
    private final double sigma;
    private final double[] gaussianKernel;

    public BandPassActivityProfile(int maxProbPropagationDistance, double activeProbThreshold, int maxFilterSize, double sigma, SAMFileHeader samHeader) {
        this(maxProbPropagationDistance, activeProbThreshold, maxFilterSize, sigma, true, samHeader);
    }

    public BandPassActivityProfile(int maxProbPropagationDistance, double activeProbThreshold, int maxFilterSize, double sigma, boolean adaptiveFilterSize, SAMFileHeader samHeader) {
        super(maxProbPropagationDistance, activeProbThreshold, samHeader);
        Utils.validateArg(sigma >= 0.0, "Sigma must be greater than or equal to 0");
        this.sigma = sigma;
        double[] fullKernel = BandPassActivityProfile.makeKernel(maxFilterSize, sigma);
        this.filterSize = adaptiveFilterSize ? BandPassActivityProfile.determineFilterSize(fullKernel, 1.0E-5) : maxFilterSize;
        this.gaussianKernel = BandPassActivityProfile.makeKernel(this.filterSize, sigma);
    }

    protected static int determineFilterSize(double[] kernel, double minProbToKeepInFilter) {
        int middle;
        int filterEnd;
        for (filterEnd = middle = (kernel.length - 1) / 2; filterEnd > 0 && !(kernel[filterEnd - 1] < minProbToKeepInFilter); --filterEnd) {
        }
        return middle - filterEnd;
    }

    protected static double[] makeKernel(int filterSize, double sigma) {
        int bandSize = 2 * filterSize + 1;
        double[] kernel = new double[bandSize];
        for (int iii = 0; iii < bandSize; ++iii) {
            kernel[iii] = MathUtils.normalDistribution(filterSize, sigma, iii);
        }
        return MathUtils.normalizeSumToOne(kernel);
    }

    @Override
    public int getMaxProbPropagationDistance() {
        return super.getMaxProbPropagationDistance() + this.filterSize;
    }

    public int getBandSize() {
        return 2 * this.filterSize + 1;
    }

    public int getFilteredSize() {
        return this.filterSize;
    }

    public double getSigma() {
        return this.sigma;
    }

    protected double[] getKernel() {
        return this.gaussianKernel;
    }

    @Override
    protected Collection<ActivityProfileState> processState(ActivityProfileState justAddedState) {
        ArrayList<ActivityProfileState> states = new ArrayList<ActivityProfileState>();
        for (ActivityProfileState superState : super.processState(justAddedState)) {
            if (superState.isActiveProb() > 0.0) {
                for (int i = -this.filterSize; i <= this.filterSize; ++i) {
                    SimpleInterval loc = this.getLocForOffset(justAddedState.getLoc(), i);
                    if (loc == null) continue;
                    double newProb = superState.isActiveProb() * this.gaussianKernel[i + this.filterSize];
                    states.add(new ActivityProfileState(loc, newProb));
                }
                continue;
            }
            states.add(justAddedState);
        }
        return states;
    }
}

