/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.bigquery;

import com.google.cloud.bigquery.storage.v1beta1.AvroProto;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.bigquery.GATKAvroReader;
import org.broadinstitute.hellbender.utils.bigquery.TableReference;

public class StorageAPIAvroReader
implements GATKAvroReader {
    private static final Logger logger = LogManager.getLogger(StorageAPIAvroReader.class);
    private static int rowCount = 0;
    private BigQueryStorageClient client;
    private Iterator<Storage.ReadRowsResponse> serverStream;
    private Schema schema;
    private DatumReader<GenericRecord> datumReader;
    private BinaryDecoder decoder = null;
    private AvroProto.AvroRows currentAvroRows;
    private GenericRecord nextRow = null;

    public StorageAPIAvroReader(TableReference tableRef) {
        this(tableRef, null);
    }

    public StorageAPIAvroReader(TableReference tableRef, String rowRestriction) {
        try {
            this.client = BigQueryStorageClient.create();
            String parent = String.format("projects/%s", tableRef.tableProject);
            TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().setProjectId(tableRef.tableProject).setDatasetId(tableRef.tableDataset).setTableId(tableRef.tableName).build();
            ReadOptions.TableReadOptions.Builder readOptions = ReadOptions.TableReadOptions.newBuilder().addAllSelectedFields(tableRef.fields);
            if (rowRestriction != null) {
                readOptions.setRowRestriction(rowRestriction);
            }
            ReadOptions.TableReadOptions tableReadOptions = readOptions.build();
            Storage.CreateReadSessionRequest.Builder builder = Storage.CreateReadSessionRequest.newBuilder().setParent(parent).setTableReference(tableReference).setReadOptions(tableReadOptions).setRequestedStreams(1).setFormat(Storage.DataFormat.AVRO);
            Storage.ReadSession session = this.client.createReadSession(builder.build());
            Preconditions.checkState((session.getStreamsCount() > 0 ? 1 : 0) != 0);
            this.schema = new Schema.Parser().parse(session.getAvroSchema().getSchema());
            this.datumReader = new GenericDatumReader(new Schema.Parser().parse(session.getAvroSchema().getSchema()));
            Storage.StreamPosition readPosition = Storage.StreamPosition.newBuilder().setStream(session.getStreams(0)).build();
            Storage.ReadRowsRequest readRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(readPosition).build();
            this.serverStream = this.client.readRowsCallable().call((Object)readRowsRequest).iterator();
            this.loadNextRow();
        }
        catch (IOException e) {
            throw new GATKException("I/O Error", e);
        }
    }

    private void loadNextRow() {
        try {
            if (this.decoder != null && !this.decoder.isEnd()) {
                this.nextRow = (GenericRecord)this.datumReader.read(null, (Decoder)this.decoder);
            } else {
                this.fetchNextAvroRows();
                this.nextRow = this.decoder != null && !this.decoder.isEnd() ? (GenericRecord)this.datumReader.read(null, (Decoder)this.decoder) : null;
            }
        }
        catch (IOException e) {
            throw new GATKException("I/O error", e);
        }
    }

    private void fetchNextAvroRows() {
        if (this.serverStream.hasNext()) {
            this.currentAvroRows = this.serverStream.next().getAvroRows();
            this.decoder = DecoderFactory.get().binaryDecoder(this.currentAvroRows.getSerializedBinaryRows().toByteArray(), this.decoder);
        } else {
            this.currentAvroRows = null;
            this.decoder = null;
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Iterator<GenericRecord> iterator() {
        return this;
    }

    public boolean hasNext() {
        return this.nextRow != null;
    }

    public GenericRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when ! hasNext()");
        }
        GenericRecord recordToReturn = this.nextRow;
        this.loadNextRow();
        return recordToReturn;
    }

    public void close() {
        this.client.shutdownNow();
        this.client.close();
    }
}

