/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.bwa;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.SequenceUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;

public class BwaMemAlignmentUtils {
    public static SAMRecord applyAlignment(String readName, byte[] basesArg, byte[] qualsArg, String readGroup, BwaMemAlignment alignment, List<String> refNames, SAMFileHeader header, boolean softClipAlts, boolean alwaysGenerateASandXS) {
        byte[] quals;
        SAMRecord samRecord = new SAMRecord(header);
        samRecord.setReadName(readName);
        int samFlag = alignment.getSamFlag();
        samRecord.setFlags(samFlag);
        if (alignment.getRefId() >= 0) {
            samRecord.setReferenceName(refNames.get(alignment.getRefId()));
        } else if (alignment.getMateRefId() >= 0) {
            samRecord.setReferenceName(refNames.get(alignment.getMateRefId()));
        }
        if (alignment.getRefStart() >= 0) {
            samRecord.setAlignmentStart(alignment.getRefStart() + 1);
        } else if (alignment.getMateRefStart() >= 0) {
            samRecord.setAlignmentStart(alignment.getMateRefStart() + 1);
        }
        if (alignment.getMapQual() >= 0) {
            samRecord.setMappingQuality(alignment.getMapQual());
        }
        byte[] bases = basesArg;
        byte[] byArray = quals = qualsArg == null ? new byte[]{} : qualsArg;
        if (SAMFlag.READ_REVERSE_STRAND.isSet(samFlag) && SAMFlag.SECONDARY_ALIGNMENT.isUnset(samFlag)) {
            bases = BaseUtils.simpleReverseComplement(bases);
            quals = Arrays.copyOf(quals, quals.length);
            SequenceUtil.reverseQualities((byte[])quals);
        }
        if (alignment.getCigar() != null && !alignment.getCigar().isEmpty()) {
            Cigar cigar;
            Cigar tmpCigar = cigar = TextCigarCodec.decode((String)alignment.getCigar());
            if (!softClipAlts && SAMFlag.SUPPLEMENTARY_ALIGNMENT.isSet(samFlag)) {
                if (tmpCigar.getFirstCigarElement().getOperator() == CigarOperator.S || tmpCigar.getLastCigarElement().getOperator() == CigarOperator.S) {
                    tmpCigar = new Cigar();
                    for (CigarElement ele : cigar) {
                        if (ele.getOperator() == CigarOperator.S) {
                            tmpCigar.add(new CigarElement(ele.getLength(), CigarOperator.H));
                            continue;
                        }
                        tmpCigar.add(ele);
                    }
                }
                bases = Arrays.copyOfRange(bases, alignment.getSeqStart(), alignment.getSeqEnd());
                if (quals.length != 0) {
                    quals = Arrays.copyOfRange(quals, alignment.getSeqStart(), alignment.getSeqEnd());
                }
            }
            samRecord.setCigar(tmpCigar);
            samRecord.setAttribute("NM", (Object)alignment.getNMismatches());
            samRecord.setAttribute("AS", (Object)alignment.getAlignerScore());
            samRecord.setAttribute("XS", (Object)alignment.getSuboptimalScore());
            samRecord.setAttribute("MD", (Object)alignment.getMDTag());
            samRecord.setAttribute("XA", (Object)alignment.getXATag());
        } else if (alwaysGenerateASandXS) {
            samRecord.setAttribute("AS", (Object)0);
            samRecord.setAttribute("XS", (Object)0);
        }
        if (SAMFlag.READ_PAIRED.isSet(samFlag)) {
            if (alignment.getMateRefId() >= 0) {
                samRecord.setMateReferenceName(refNames.get(alignment.getMateRefId()));
            } else if (alignment.getRefId() >= 0) {
                samRecord.setMateReferenceName(refNames.get(alignment.getRefId()));
            }
            if (alignment.getMateRefStart() >= 0) {
                samRecord.setMateAlignmentStart(alignment.getMateRefStart() + 1);
            } else if (alignment.getRefStart() >= 0) {
                samRecord.setMateAlignmentStart(alignment.getRefStart() + 1);
            }
            if (alignment.getTemplateLen() != 0) {
                samRecord.setInferredInsertSize(alignment.getTemplateLen());
            }
        }
        if (SAMFlag.SECONDARY_ALIGNMENT.isUnset(samFlag)) {
            samRecord.setReadBases(bases);
            samRecord.setBaseQualities(quals);
        } else {
            samRecord.setReadBases(SAMRecord.NULL_SEQUENCE);
            samRecord.setBaseQualities(SAMRecord.NULL_QUALS);
        }
        if (readGroup != null) {
            samRecord.setAttribute(SAMTag.RG.name(), (Object)readGroup);
        }
        return samRecord;
    }

    public static Map<BwaMemAlignment, String> createSATags(List<BwaMemAlignment> alignments, List<String> refNames) {
        int nAlignments = alignments.size();
        if (nAlignments < 2) {
            return Collections.emptyMap();
        }
        String[] selfTags = new String[nAlignments];
        for (int idx = 0; idx != nAlignments; ++idx) {
            BwaMemAlignment alignment = alignments.get(idx);
            if (!SAMFlag.SECONDARY_ALIGNMENT.isUnset(alignment.getSamFlag())) continue;
            selfTags[idx] = BwaMemAlignmentUtils.asTag(alignment, refNames);
        }
        HashMap<BwaMemAlignment, String> saTags = new HashMap<BwaMemAlignment, String>(SVUtils.hashMapCapacity(nAlignments));
        for (int idx = 0; idx != nAlignments; ++idx) {
            BwaMemAlignment alignment = alignments.get(idx);
            if (SAMFlag.SECONDARY_ALIGNMENT.isSet(alignment.getSamFlag())) continue;
            StringBuilder saTag = new StringBuilder();
            for (int idx2 = 0; idx2 != nAlignments; ++idx2) {
                String tag;
                if (idx2 == idx || (tag = selfTags[idx2]) == null) continue;
                saTag.append(tag);
            }
            saTags.put(alignment, saTag.toString());
        }
        return saTags;
    }

    public static String asTag(BwaMemAlignment alignment, List<String> refNames) {
        return refNames.get(alignment.getRefId()) + "," + (alignment.getRefStart() + 1) + "," + (SAMFlag.READ_REVERSE_STRAND.isSet(alignment.getSamFlag()) ? "-" : "+") + "," + alignment.getCigar().replace('H', 'S') + "," + alignment.getMapQual() + "," + alignment.getNMismatches() + ";";
    }

    public static Stream<SAMRecord> toSAMStreamForRead(String readName, byte[] contigSequence, List<BwaMemAlignment> alignments, SAMFileHeader header, List<String> refNames, SAMReadGroupRecord contigAlignmentsReadGroup) {
        Utils.nonNull(readName, "provided read name is null for the alignments");
        Utils.nonNull(contigSequence, "provided read sequence is null");
        Utils.nonNull(alignments, "alignments to be converted is null");
        Utils.nonNull(header, "provided header is null");
        Utils.nonNull(refNames, "provided list of reference contig names is null");
        if (alignments.isEmpty()) {
            return Stream.empty();
        }
        Map<BwaMemAlignment, String> saTagMap = BwaMemAlignmentUtils.createSATags(alignments, refNames);
        return alignments.stream().map(alignment -> {
            SAMRecord samRecord = BwaMemAlignmentUtils.applyAlignment(readName, contigSequence, null, null, alignment, refNames, header, false, false);
            String saTag = (String)saTagMap.get(alignment);
            if (saTag != null) {
                samRecord.setAttribute("SA", (Object)saTag);
            }
            if (contigAlignmentsReadGroup != null) {
                samRecord.setAttribute(SAMTag.RG.name(), (Object)contigAlignmentsReadGroup.getId());
            }
            return samRecord;
        });
    }
}

