/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.bwa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;

public class BwaMemIndexCache {
    private static final Map<String, BwaMemIndex> instances = new HashMap<String, BwaMemIndex>();

    public static synchronized BwaMemIndex getInstance(String indexImageFile) {
        Utils.nonNull(indexImageFile, "the index image file name provided cannot be null");
        if (!instances.containsKey(indexImageFile)) {
            instances.put(indexImageFile, new BwaMemIndex(indexImageFile));
        }
        return instances.get(indexImageFile);
    }

    public static synchronized void closeInstance(String indexImageFile) {
        Utils.nonNull(indexImageFile, "the input image file cannot be null");
        if (instances.containsKey(indexImageFile)) {
            instances.get(indexImageFile).close();
            instances.remove(indexImageFile);
        }
    }

    public static synchronized void closeInstance(BwaMemIndex instance) {
        Utils.nonNull(instance, "the input index cannot be null");
        if (instances.values().contains(instance)) {
            instance.close();
            instances.values().remove(instance);
        }
    }

    public static synchronized void closeInstances() {
        Iterator<BwaMemIndex> it = instances.values().iterator();
        while (it.hasNext()) {
            it.next().close();
            it.remove();
        }
    }

    public static void closeAllDistributedInstances(JavaSparkContext ctx) {
        Utils.nonNull(ctx, "the context provided cannot be null");
        int nJobs = ctx.defaultParallelism();
        ArrayList<Integer> jobList = new ArrayList<Integer>(nJobs);
        for (int idx2 = 0; idx2 != nJobs; ++idx2) {
            jobList.add(idx2);
        }
        ctx.parallelize(jobList, nJobs).foreach((VoidFunction & Serializable)idx -> BwaMemIndexCache.closeInstances());
    }
}

