/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.clipping;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.clipping.ClippingOp;
import org.broadinstitute.hellbender.utils.clipping.ClippingRepresentation;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class ReadClipper {
    static final Logger logger = LogManager.getLogger(ReadClipper.class);
    final GATKRead read;
    boolean wasClipped;
    List<ClippingOp> ops = null;

    public ReadClipper(GATKRead read) {
        Utils.nonNull(read);
        this.read = read;
        this.wasClipped = false;
    }

    public void addOp(ClippingOp op) {
        Utils.nonNull(op);
        if (this.ops == null) {
            this.ops = new ArrayList<ClippingOp>();
        }
        this.ops.add(op);
    }

    public List<ClippingOp> getOps() {
        return this.ops;
    }

    public boolean wasClipped() {
        return this.wasClipped;
    }

    public GATKRead getRead() {
        return this.read;
    }

    public GATKRead clipRead(ClippingRepresentation algorithm) {
        Utils.nonNull(algorithm);
        if (this.ops == null) {
            return this.getRead();
        }
        GATKRead clippedRead = this.read;
        for (ClippingOp op : this.getOps()) {
            int readLength = clippedRead.getLength();
            if (op.start >= readLength) continue;
            ClippingOp fixedOperation = op;
            if (op.stop >= readLength) {
                fixedOperation = new ClippingOp(op.start, readLength - 1);
            }
            clippedRead = fixedOperation.apply(algorithm, clippedRead);
        }
        this.wasClipped = true;
        this.ops.clear();
        if (clippedRead.isEmpty()) {
            return ReadUtils.emptyRead(clippedRead);
        }
        return clippedRead;
    }

    private GATKRead hardClipByReferenceCoordinatesLeftTail(int refStop) {
        return this.clipByReferenceCoordinates(-1, refStop, ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKRead hardClipByReferenceCoordinatesLeftTail(GATKRead read, int refStop) {
        return new ReadClipper(read).clipByReferenceCoordinates(-1, refStop, ClippingRepresentation.HARDCLIP_BASES);
    }

    private GATKRead hardClipByReferenceCoordinatesRightTail(int refStart) {
        return this.clipByReferenceCoordinates(refStart, -1, ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKRead hardClipByReferenceCoordinatesRightTail(GATKRead read, int refStart) {
        return new ReadClipper(read).clipByReferenceCoordinates(refStart, -1, ClippingRepresentation.HARDCLIP_BASES);
    }

    private GATKRead hardClipBothEndsByReferenceCoordinates(int left, int right) {
        if (this.read.isEmpty() || left == right) {
            return ReadUtils.emptyRead(this.read);
        }
        GATKRead leftTailRead = this.clipByReferenceCoordinates(right, -1, ClippingRepresentation.HARDCLIP_BASES);
        if (left > leftTailRead.getEnd()) {
            return ReadUtils.emptyRead(this.read);
        }
        ReadClipper clipper = new ReadClipper(leftTailRead);
        return clipper.hardClipByReferenceCoordinatesLeftTail(left);
    }

    public static GATKRead hardClipBothEndsByReferenceCoordinates(GATKRead read, int left, int right) {
        return new ReadClipper(read).hardClipBothEndsByReferenceCoordinates(left, right);
    }

    private GATKRead clipLowQualEnds(ClippingRepresentation algorithm, byte lowQual) {
        int rightClipIndex;
        if (this.read.isEmpty()) {
            return this.read;
        }
        int readLength = this.read.getLength();
        int leftClipIndex = 0;
        for (rightClipIndex = readLength - 1; rightClipIndex >= 0 && this.read.getBaseQuality(rightClipIndex) <= lowQual; --rightClipIndex) {
        }
        while (leftClipIndex < readLength && this.read.getBaseQuality(leftClipIndex) <= lowQual) {
            ++leftClipIndex;
        }
        if (leftClipIndex > rightClipIndex) {
            return ReadUtils.emptyRead(this.read);
        }
        if (rightClipIndex < readLength - 1) {
            this.addOp(new ClippingOp(rightClipIndex + 1, readLength - 1));
        }
        if (leftClipIndex > 0) {
            this.addOp(new ClippingOp(0, leftClipIndex - 1));
        }
        return this.clipRead(algorithm);
    }

    private GATKRead hardClipLowQualEnds(byte lowQual) {
        return this.clipLowQualEnds(ClippingRepresentation.HARDCLIP_BASES, lowQual);
    }

    public static GATKRead clipLowQualEnds(GATKRead read, byte lowQual, ClippingRepresentation algorithm) {
        return new ReadClipper(read).clipLowQualEnds(algorithm, lowQual);
    }

    public static GATKRead hardClipLowQualEnds(GATKRead read, byte lowQual) {
        return new ReadClipper(read).hardClipLowQualEnds(lowQual);
    }

    public static GATKRead softClipLowQualEnds(GATKRead read, byte lowQual) {
        return new ReadClipper(read).clipLowQualEnds(ClippingRepresentation.SOFTCLIP_BASES, lowQual);
    }

    private GATKRead hardClipSoftClippedBases() {
        if (this.read.isEmpty()) {
            return this.read;
        }
        int readIndex = 0;
        int cutLeft = -1;
        int cutRight = -1;
        boolean rightTail = false;
        for (CigarElement cigarElement : this.read.getCigarElements()) {
            if (cigarElement.getOperator() == CigarOperator.SOFT_CLIP) {
                if (rightTail) {
                    cutRight = readIndex;
                } else {
                    cutLeft = readIndex + cigarElement.getLength() - 1;
                }
            } else if (cigarElement.getOperator() != CigarOperator.HARD_CLIP) {
                rightTail = true;
            }
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            readIndex += cigarElement.getLength();
        }
        if (cutRight >= 0) {
            this.addOp(new ClippingOp(cutRight, this.read.getLength() - 1));
        }
        if (cutLeft >= 0) {
            this.addOp(new ClippingOp(0, cutLeft));
        }
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKRead hardClipSoftClippedBases(GATKRead read) {
        return new ReadClipper(read).hardClipSoftClippedBases();
    }

    public static GATKRead hardClipToRegion(GATKRead read, int refStart, int refStop) {
        int start = read.getStart();
        int stop = read.getEnd();
        return ReadClipper.hardClipToRegion(read, refStart, refStop, start, stop);
    }

    private static GATKRead hardClipToRegion(GATKRead read, int refStart, int refStop, int alignmentStart, int alignmentStop) {
        if (alignmentStart <= refStop && alignmentStop >= refStart) {
            if (alignmentStart < refStart && alignmentStop > refStop) {
                return ReadClipper.hardClipBothEndsByReferenceCoordinates(read, refStart - 1, refStop + 1);
            }
            if (alignmentStart < refStart) {
                return ReadClipper.hardClipByReferenceCoordinatesLeftTail(read, refStart - 1);
            }
            if (alignmentStop > refStop) {
                return ReadClipper.hardClipByReferenceCoordinatesRightTail(read, refStop + 1);
            }
            return read;
        }
        return ReadUtils.emptyRead(read);
    }

    private GATKRead hardClipAdaptorSequence() {
        int adaptorBoundary = this.read.getAdaptorBoundary();
        if (adaptorBoundary == ReadUtils.CANNOT_COMPUTE_ADAPTOR_BOUNDARY || !ReadUtils.isInsideRead(this.read, adaptorBoundary)) {
            return this.read;
        }
        return this.read.isReverseStrand() ? this.hardClipByReferenceCoordinatesLeftTail(adaptorBoundary) : this.hardClipByReferenceCoordinatesRightTail(adaptorBoundary);
    }

    public static GATKRead hardClipAdaptorSequence(GATKRead read) {
        return new ReadClipper(read).hardClipAdaptorSequence();
    }

    private GATKRead revertSoftClippedBases() {
        if (this.read.isEmpty()) {
            return this.read;
        }
        this.addOp(new ClippingOp(0, 0));
        return this.clipRead(ClippingRepresentation.REVERT_SOFTCLIPPED_BASES);
    }

    public static GATKRead revertSoftClippedBases(GATKRead read) {
        return new ReadClipper(read).revertSoftClippedBases();
    }

    protected GATKRead hardClipByReferenceCoordinates(int refStart, int refStop) {
        return this.clipByReferenceCoordinates(refStart, refStop, ClippingRepresentation.HARDCLIP_BASES);
    }

    protected GATKRead clipByReferenceCoordinates(int refStart, int refStop, ClippingRepresentation clippingOp) {
        int stop;
        int start;
        if (this.read.isEmpty()) {
            return this.read;
        }
        if (clippingOp == ClippingRepresentation.SOFTCLIP_BASES && this.read.isUnmapped()) {
            throw new GATKException("Cannot soft-clip read " + this.read.commonToString() + " by reference coordinates because it is unmapped");
        }
        if (refStart < 0) {
            if (refStop < 0) {
                throw new GATKException("Only one of refStart or refStop must be < 0, not both (" + refStart + ", " + refStop + ")");
            }
            start = 0;
            Pair<Integer, CigarOperator> stopPosAndOperator = ReadUtils.getReadIndexForReferenceCoordinate(this.read, refStop);
            stop = (Integer)stopPosAndOperator.getLeft() - (((CigarOperator)stopPosAndOperator.getRight()).consumesReadBases() ? 0 : 1);
        } else {
            if (refStop >= 0) {
                throw new GATKException("Either refStart or refStop must be < 0 (" + refStart + ", " + refStop + ")");
            }
            start = (Integer)ReadUtils.getReadIndexForReferenceCoordinate(this.read, refStart).getLeft();
            stop = this.read.getLength() - 1;
        }
        if (start == -1 || stop == -1) {
            return this.read;
        }
        if (start < 0 || stop > this.read.getLength() - 1) {
            throw new GATKException("Trying to clip before the start or after the end of a read");
        }
        if (start > stop) {
            throw new GATKException(String.format("START (%d) > (%d) STOP -- this should never happen, please check read: %s (CIGAR: %s)", start, stop, this.read, this.read.getCigar().toString()));
        }
        if (start > 0 && stop < this.read.getLength() - 1) {
            throw new GATKException(String.format("Trying to clip the middle of the read: start %d, stop %d, cigar: %s", start, stop, this.read.getCigar().toString()));
        }
        this.addOp(new ClippingOp(start, stop));
        GATKRead clippedRead = this.clipRead(clippingOp);
        this.ops = null;
        return clippedRead;
    }

    public static GATKRead softClipToRegionIncludingClippedBases(GATKRead read, int refStart, int refStop) {
        int start = read.getUnclippedStart();
        int stop = start + CigarUtils.countRefBasesAndClips(read.getCigarElements(), 0, read.numCigarElements()) - 1;
        if (start <= refStop && stop >= refStart) {
            if (start < refStart && stop > refStop) {
                return new ReadClipper(read).softClipBothEndsByReferenceCoordinates(refStart - 1, refStop + 1);
            }
            if (start < refStart) {
                return new ReadClipper(read).softClipByReferenceCoordinates(-1, refStart - 1);
            }
            if (stop > refStop) {
                return new ReadClipper(read).softClipByReferenceCoordinates(refStop + 1, -1);
            }
            return read;
        }
        logger.warn("Attempting to clip the entirety of a read by region: %s", new Object[]{read.toString()});
        return ReadUtils.emptyRead(read);
    }

    private GATKRead softClipBothEndsByReferenceCoordinates(int left, int right) {
        if (this.read.isEmpty()) {
            return ReadUtils.emptyRead(this.read);
        }
        if (left == right) {
            logger.warn("Attempting to clip the entirety of a read by by reference coordinates: %s", new Object[]{this.read.toString()});
            return ReadUtils.emptyRead(this.read);
        }
        GATKRead leftTailRead = this.softClipByReferenceCoordinates(right, -1);
        if (left > leftTailRead.getEnd()) {
            return ReadUtils.emptyRead(this.read);
        }
        ReadClipper clipper = new ReadClipper(leftTailRead);
        return clipper.softClipByReferenceCoordinates(-1, left);
    }

    public static GATKRead softClipBothEndsByReferenceCoordinates(GATKRead read, int left, int right) {
        return new ReadClipper(read).softClipBothEndsByReferenceCoordinates(left, right);
    }

    protected GATKRead softClipByReferenceCoordinates(int refStart, int refStop) {
        return this.clipByReferenceCoordinates(refStart, refStop, ClippingRepresentation.SOFTCLIP_BASES);
    }

    private GATKRead softClipByReadCoordinates(int start, int stop) {
        if (this.read.isEmpty()) {
            return ReadUtils.emptyRead(this.read);
        }
        if (start == 0 && stop == this.read.getLength() - 1) {
            logger.warn("Attempting to clip the entirety of a read by by read coordinates: %s", new Object[]{this.read.toString()});
            return ReadUtils.emptyRead(this.read);
        }
        this.addOp(new ClippingOp(start, stop));
        return this.clipRead(ClippingRepresentation.SOFTCLIP_BASES);
    }

    public static GATKRead softClipByReadCoordinates(GATKRead read, int start, int stop) {
        return new ReadClipper(read).softClipByReadCoordinates(start, stop);
    }
}

