/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalHeader;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable.XsvLocatableTableCodec;
import org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable.XsvTableFeature;
import org.broadinstitute.hellbender.utils.io.Resource;

public class AnnotatedIntervalCodec
extends AsciiFeatureCodec<AnnotatedInterval> {
    public static final String ANNOTATED_INTERVAL_DEFAULT_CONFIG_RESOURCE = "org/broadinstitute/hellbender/tools/copynumber/utils/annotatedinterval/annotated_region_default.config";
    public static final String CONTIG_COL_COMMENT = "_ContigHeader=";
    public static final String START_COL_COMMENT = "_StartHeader=";
    public static final String END_COL_COMMENT = "_EndHeader=";
    private Path configFilePath;
    private XsvLocatableTableCodec xsvLocatableTableCodec;
    private AnnotatedIntervalHeader header;

    public AnnotatedIntervalCodec() {
        super(AnnotatedInterval.class);
        String resourcePath = ANNOTATED_INTERVAL_DEFAULT_CONFIG_RESOURCE;
        try {
            this.configFilePath = Resource.getResourceContentsAsFile(ANNOTATED_INTERVAL_DEFAULT_CONFIG_RESOURCE).toPath();
            this.xsvLocatableTableCodec = new XsvLocatableTableCodec(this.configFilePath);
        }
        catch (IOException ioe) {
            throw new GATKException.ShouldNeverReachHereException("Could not read config file: org/broadinstitute/hellbender/tools/copynumber/utils/annotatedinterval/annotated_region_default.config", ioe);
        }
    }

    public AnnotatedIntervalCodec(Path configFilePath) {
        super(AnnotatedInterval.class);
        this.configFilePath = configFilePath;
        this.xsvLocatableTableCodec = new XsvLocatableTableCodec(configFilePath);
    }

    public AnnotatedInterval decode(String s) {
        XsvTableFeature feature = this.xsvLocatableTableCodec.decode(s);
        if (feature == null) {
            return null;
        }
        List<String> annotationFields = this.header.getAnnotations();
        TreeMap<String, String> annotations = new TreeMap<String, String>();
        IntStream.range(0, annotationFields.size()).boxed().forEach(i -> annotations.put((String)annotationFields.get((int)i), feature.getValuesWithoutLocationColumns().get((int)i)));
        return new AnnotatedInterval(new SimpleInterval(feature.getContig(), feature.getStart(), feature.getEnd()), annotations);
    }

    public AnnotatedIntervalHeader readActualHeader(LineIterator reader) {
        this.xsvLocatableTableCodec.readActualHeader(reader);
        this.header = new AnnotatedIntervalHeader(this.xsvLocatableTableCodec.getContigColumn(), this.xsvLocatableTableCodec.getStartColumn(), this.xsvLocatableTableCodec.getEndColumn(), this.xsvLocatableTableCodec.getHeaderWithoutLocationColumns(), this.xsvLocatableTableCodec.renderSamFileHeader());
        return this.header;
    }

    public boolean canDecode(String pathString) {
        return (pathString.endsWith(".seg") || pathString.endsWith(".maf") || pathString.endsWith(".maf.annotated")) && this.xsvLocatableTableCodec.canDecodeFileChecks(this.configFilePath.toUri().toString(), pathString);
    }

    public static AnnotatedIntervalHeader createHeaderForWriter(Path outputConfigFile, List<String> annotations, SAMFileHeader samFileHeader) {
        Utils.nonNull(annotations);
        Utils.nonNull(outputConfigFile);
        Pair<Boolean, Properties> validityAndPropertiesPair = XsvLocatableTableCodec.getAndValidateConfigFileContentsOnPath(outputConfigFile, true);
        boolean isValid = (Boolean)validityAndPropertiesPair.getLeft();
        Properties headerNameProperties = (Properties)validityAndPropertiesPair.getRight();
        if (!isValid) {
            throw new UserException.BadInput("Error: invalid configuration file given: " + outputConfigFile.toUri().toString());
        }
        String contigColumnName = AnnotatedIntervalCodec.determineOutputColumnFromList(headerNameProperties.getProperty("contig_column"));
        String startColumnName = AnnotatedIntervalCodec.determineOutputColumnFromList(headerNameProperties.getProperty("start_column"));
        String endColumnName = AnnotatedIntervalCodec.determineOutputColumnFromList(headerNameProperties.getProperty("end_column"));
        XsvLocatableTableCodec.validateLocatableColumnName(contigColumnName);
        XsvLocatableTableCodec.validateLocatableColumnName(startColumnName);
        XsvLocatableTableCodec.validateLocatableColumnName(endColumnName);
        List<String> finalAnnotations = annotations.stream().filter(a -> !a.equals(contigColumnName) && !a.equals(startColumnName) && !a.equals(endColumnName)).collect(Collectors.toList());
        List<String> commentsToWrite = AnnotatedIntervalCodec.updateStructuredComments(contigColumnName, startColumnName, endColumnName, samFileHeader.getComments());
        SAMFileHeader finalSamHeader = samFileHeader.clone();
        finalSamHeader.setComments(commentsToWrite);
        return new AnnotatedIntervalHeader(contigColumnName, startColumnName, endColumnName, finalAnnotations, finalSamHeader);
    }

    private static String determineOutputColumnFromList(String rawColumnNamesAsString) {
        String result = StringUtils.split((String)rawColumnNamesAsString, (String)",")[0];
        if (StringUtils.isNumeric((CharSequence)result)) {
            throw new UserException.BadInput("Index numbers were used in output configuration.  This is not allowed: " + rawColumnNamesAsString);
        }
        return result;
    }

    public static AnnotatedIntervalHeader createHeaderForWriter(List<String> annotations, SAMFileHeader samFileHeader) {
        Utils.nonNull(annotations);
        try {
            Path resourceFile = Resource.getResourceContentsAsFile(ANNOTATED_INTERVAL_DEFAULT_CONFIG_RESOURCE).toPath();
            return AnnotatedIntervalCodec.createHeaderForWriter(resourceFile, annotations, samFileHeader);
        }
        catch (IOException ioe) {
            throw new GATKException.ShouldNeverReachHereException("Could not load the default config file for annotated intervals.", ioe);
        }
    }

    private static List<String> updateStructuredComments(String finalContigColumnName, String finalStartColumnName, String finalEndColumnName, List<String> currentComments) {
        Utils.nonNull(currentComments);
        Utils.validateArg(!StringUtils.isEmpty((CharSequence)finalContigColumnName), "Contig column name was null or blank, which is invalid.");
        Utils.validateArg(!StringUtils.isEmpty((CharSequence)finalStartColumnName), "Start column name was null or blank, which is invalid.");
        Utils.validateArg(!StringUtils.isEmpty((CharSequence)finalEndColumnName), "End column name was null or blank, which is invalid.");
        List<String> commentsToWrite = currentComments.stream().filter(c -> !c.startsWith(SAMTextHeaderCodec.COMMENT_PREFIX + CONTIG_COL_COMMENT)).filter(c -> !c.startsWith(SAMTextHeaderCodec.COMMENT_PREFIX + START_COL_COMMENT)).filter(c -> !c.startsWith(SAMTextHeaderCodec.COMMENT_PREFIX + END_COL_COMMENT)).collect(Collectors.toList());
        commentsToWrite.add(CONTIG_COL_COMMENT + finalContigColumnName);
        commentsToWrite.add(START_COL_COMMENT + finalStartColumnName);
        commentsToWrite.add(END_COL_COMMENT + finalEndColumnName);
        return commentsToWrite;
    }
}

