/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import com.google.common.base.Splitter;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.tools.sv.BafEvidence;

public class BafEvidenceCodec
extends AsciiFeatureCodec<BafEvidence> {
    public static final String FORMAT_SUFFIX = ".baf.txt";
    public static final String COL_DELIMITER = "\t";
    private static final Splitter splitter = Splitter.on((String)"\t");

    public BafEvidenceCodec() {
        super(BafEvidence.class);
    }

    public TabixFormat getTabixFormat() {
        return new TabixFormat(65536, 1, 2, 0, '#', 0);
    }

    public BafEvidence decode(String line) {
        List tokens = splitter.splitToList((CharSequence)line);
        if (tokens.size() != 4) {
            throw new IllegalArgumentException("Invalid number of columns: " + tokens.size());
        }
        String contig = (String)tokens.get(0);
        int position = Integer.parseUnsignedInt((String)tokens.get(1)) + 1;
        double value = Double.parseDouble((String)tokens.get(2));
        String sample = (String)tokens.get(3);
        return new BafEvidence(sample, contig, position, value);
    }

    public boolean canDecode(String path) {
        String toDecode = IOUtil.hasBlockCompressedExtension((String)path) ? path.substring(0, path.lastIndexOf(".")) : path;
        return toDecode.toLowerCase().endsWith(FORMAT_SUFFIX);
    }

    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    public static String encode(BafEvidence ev) {
        List<String> columns = Arrays.asList(ev.getContig(), Integer.toString(ev.getStart() - 1), Double.toString(ev.getValue()), ev.getSample());
        return String.join((CharSequence)COL_DELIMITER, columns);
    }
}

