/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import com.google.common.base.Splitter;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.sv.DepthEvidence;

public class DepthEvidenceCodec
extends AsciiFeatureCodec<DepthEvidence> {
    public static final String FORMAT_SUFFIX = ".rd.txt";
    public static final String COL_DELIMITER = "\t";
    private static final Splitter splitter = Splitter.on((String)"\t");

    public DepthEvidenceCodec() {
        super(DepthEvidence.class);
    }

    public TabixFormat getTabixFormat() {
        return new TabixFormat(65536, 1, 2, 3, '#', 1);
    }

    public DepthEvidence decode(String line) {
        List tokens = splitter.splitToList((CharSequence)line);
        if (tokens.size() < 3) {
            throw new IllegalArgumentException("Expected at least 3 columns but found " + tokens.size());
        }
        String contig = (String)tokens.get(0);
        int start = Integer.parseUnsignedInt((String)tokens.get(1)) + 1;
        int end = Integer.parseUnsignedInt((String)tokens.get(2));
        int numCounts = tokens.size() - 3;
        int[] counts = new int[numCounts];
        for (int i = 3; i < tokens.size(); ++i) {
            counts[i - 3] = Integer.parseUnsignedInt((String)tokens.get(i));
        }
        return new DepthEvidence(contig, start, end, counts);
    }

    public boolean canDecode(String path) {
        String toDecode = IOUtil.hasBlockCompressedExtension((String)path) ? path.substring(0, path.lastIndexOf(".")) : path;
        return toDecode.toLowerCase().endsWith(FORMAT_SUFFIX);
    }

    public Object readActualHeader(LineIterator reader) {
        if (!reader.hasNext()) {
            throw new UserException.BadInput("Depth evidence file did not have a header line");
        }
        return reader.next();
    }

    public static String encode(DepthEvidence ev) {
        int[] counts = ev.getCounts();
        int numCounts = counts.length;
        ArrayList<String> columns = new ArrayList<String>(3 + numCounts);
        columns.add(ev.getContig());
        columns.add(Integer.toString(ev.getStart() - 1));
        columns.add(Integer.toString(ev.getEnd()));
        for (int i = 0; i < numCounts; ++i) {
            columns.add(Integer.toString(counts[i]));
        }
        return String.join((CharSequence)COL_DELIMITER, columns);
    }
}

