/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import com.google.common.base.Splitter;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.tools.sv.DiscordantPairEvidence;
import org.broadinstitute.hellbender.utils.codecs.SVCallRecordCodec;

public class DiscordantPairEvidenceCodec
extends AsciiFeatureCodec<DiscordantPairEvidence> {
    public static final String FORMAT_SUFFIX = ".pe.txt";
    public static final String COL_DELIMITER = "\t";
    private static final Splitter splitter = Splitter.on((String)"\t");

    public DiscordantPairEvidenceCodec() {
        super(DiscordantPairEvidence.class);
    }

    public TabixFormat getTabixFormat() {
        return new TabixFormat(65536, 1, 2, 0, '#', 0);
    }

    public DiscordantPairEvidence decode(String line) {
        List tokens = splitter.splitToList((CharSequence)line);
        if (tokens.size() != 7) {
            throw new IllegalArgumentException("Invalid number of columns: " + tokens.size());
        }
        String startContig = (String)tokens.get(0);
        int start = Integer.parseUnsignedInt((String)tokens.get(1)) + 1;
        boolean startStrand = ((String)tokens.get(2)).equals(SVCallRecordCodec.STRAND_PLUS);
        String endContig = (String)tokens.get(3);
        int end = Integer.parseUnsignedInt((String)tokens.get(4)) + 1;
        boolean endStrand = ((String)tokens.get(5)).equals(SVCallRecordCodec.STRAND_PLUS);
        String sample = (String)tokens.get(6);
        return new DiscordantPairEvidence(sample, startContig, start, startStrand, endContig, end, endStrand);
    }

    public boolean canDecode(String path) {
        String toDecode = IOUtil.hasBlockCompressedExtension((String)path) ? path.substring(0, path.lastIndexOf(".")) : path;
        return toDecode.toLowerCase().endsWith(FORMAT_SUFFIX);
    }

    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    public static String encode(DiscordantPairEvidence ev) {
        List<String> columns = Arrays.asList(ev.getContig(), Integer.toString(ev.getStart() - 1), ev.getStartStrand() ? SVCallRecordCodec.STRAND_PLUS : SVCallRecordCodec.STRAND_MINUS, ev.getEndContig(), Integer.toString(ev.getEndPosition() - 1), ev.getEndStrand() ? SVCallRecordCodec.STRAND_PLUS : SVCallRecordCodec.STRAND_MINUS, ev.getSample());
        return String.join((CharSequence)COL_DELIMITER, columns);
    }
}

