/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import htsjdk.tribble.readers.LineIterator;
import java.io.IOException;
import java.io.Reader;
import org.broadinstitute.hellbender.utils.Utils;

public class LineIteratorReader
extends Reader {
    private final LineIterator lineIterator;
    private final StringBuffer buffer;
    private int nextChar = 0;

    public LineIteratorReader(LineIterator lineIterator) {
        this.lineIterator = Utils.nonNull(lineIterator);
        this.buffer = new StringBuffer();
        this.nextChar = 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (len == 0) {
            return 0;
        }
        int readSoFar = 0;
        while (readSoFar < len) {
            int inBufferCharCount = this.buffer.length() - this.nextChar;
            if (inBufferCharCount == 0) {
                if (!this.lineIterator.hasNext()) break;
                this.buffer.setLength(0);
                this.nextChar = 0;
                this.buffer.append((String)this.lineIterator.next()).append('\n');
            }
            int inBuffer = Math.min(len - readSoFar, this.buffer.length() - this.nextChar);
            for (int i = 0; i < inBuffer; ++i) {
                cbuf[off + readSoFar++] = this.buffer.charAt(this.nextChar++);
            }
        }
        return readSoFar == 0 ? -1 : readSoFar;
    }

    @Override
    public void close() throws IOException {
    }
}

