/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.index.tabix.TabixFormat;
import java.io.IOException;
import java.io.InputStream;
import org.broadinstitute.hellbender.engine.ProgressMeter;

public final class ProgressReportingDelegatingCodec<A extends Feature, B>
implements FeatureCodec<A, B> {
    private final FeatureCodec<A, B> delegatee;
    private final ProgressMeter pm;

    public ProgressReportingDelegatingCodec() {
        this.delegatee = null;
        this.pm = null;
    }

    public ProgressReportingDelegatingCodec(FeatureCodec<A, B> delegatee, double secondsBetweenUpdates) {
        if (secondsBetweenUpdates <= 0.0) {
            throw new IllegalArgumentException("secondsBetweenUpdates must be > 0.0");
        }
        this.delegatee = delegatee;
        this.pm = new ProgressMeter(secondsBetweenUpdates);
    }

    public Feature decodeLoc(B b) throws IOException {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        if (!this.pm.started()) {
            this.pm.start();
        }
        Feature f = this.delegatee.decodeLoc(b);
        this.pm.update((Locatable)f);
        return f;
    }

    public A decode(B b) throws IOException {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        if (!this.pm.started()) {
            this.pm.start();
        }
        Feature result = this.delegatee.decode(b);
        this.pm.update((Locatable)result);
        return (A)result;
    }

    public FeatureCodecHeader readHeader(B b) throws IOException {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        return this.delegatee.readHeader(b);
    }

    public Class<A> getFeatureType() {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        return this.delegatee.getFeatureType();
    }

    public B makeSourceFromStream(InputStream bufferedInputStream) {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        return (B)this.delegatee.makeSourceFromStream(bufferedInputStream);
    }

    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        return this.delegatee.makeIndexableSourceFromStream(bufferedInputStream);
    }

    public boolean isDone(B b) {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        boolean done = this.delegatee.isDone(b);
        if (done && this.pm.started()) {
            this.pm.stop();
        }
        return done;
    }

    public void close(B b) {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        this.delegatee.close(b);
    }

    public boolean canDecode(String path) {
        return this.delegatee != null && this.delegatee.canDecode(path);
    }

    public FeatureCodec<A, B> getDelegatee() {
        return this.delegatee;
    }

    public TabixFormat getTabixFormat() {
        if (this.delegatee == null) {
            throw new IllegalStateException("this codec cannot be used without a delegatee.");
        }
        return this.delegatee.getTabixFormat();
    }
}

