/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import com.google.common.base.Splitter;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.StructuralVariantType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.sv.SVCallRecord;

public class SVCallRecordCodec
extends AsciiFeatureCodec<SVCallRecord> {
    public static final String FORMAT_SUFFIX = ".sv_calls.tsv.gz";
    public static final String COL_DELIMITER = "\t";
    public static String STRAND_PLUS = "+";
    public static String STRAND_MINUS = "-";
    private static final Splitter splitter = Splitter.on((String)"\t");

    public SVCallRecordCodec() {
        super(SVCallRecord.class);
    }

    public SVCallRecord decode(String line) {
        List tokens = splitter.splitToList((CharSequence)line);
        if (tokens.size() != 10) {
            throw new IllegalArgumentException("Invalid number of columns: " + tokens.size());
        }
        return new SVCallRecord((String)tokens.get(0), Integer.parseUnsignedInt((String)tokens.get(1)) + 1, ((String)tokens.get(2)).equals(STRAND_PLUS), (String)tokens.get(3), Integer.parseUnsignedInt((String)tokens.get(4)) + 1, ((String)tokens.get(5)).equals(STRAND_PLUS), StructuralVariantType.valueOf((String)((String)tokens.get(6))), Integer.parseInt((String)tokens.get(7)), Arrays.asList((String)tokens.get(8)), Collections.singletonList(new GenotypeBuilder().name((String)tokens.get(9)).make()));
    }

    public TabixFormat getTabixFormat() {
        return TabixFormat.BED;
    }

    public boolean canDecode(String path) {
        return path.endsWith(FORMAT_SUFFIX);
    }

    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    public String encode(SVCallRecord record) {
        List<String> data = Arrays.asList(record.getContig(), Integer.toString(record.getStart() - 1), record.getStartStrand() ? STRAND_PLUS : STRAND_MINUS, record.getEndContig(), Integer.toString(record.getEnd() - 1), record.getEndStrand() ? STRAND_PLUS : STRAND_MINUS, record.getType().name(), Integer.toString(record.getLength()), String.join((CharSequence)",", record.getAlgorithms()), String.join((CharSequence)",", record.getSamples()));
        return String.join((CharSequence)COL_DELIMITER, data);
    }
}

