/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs;

import com.google.common.base.Splitter;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.tools.sv.SplitReadEvidence;

public class SplitReadEvidenceCodec
extends AsciiFeatureCodec<SplitReadEvidence> {
    public static final String FORMAT_SUFFIX = ".sr.txt";
    public static final String COL_DELIMITER = "\t";
    public static final String DIRECTION_RIGHT = "right";
    public static final String DIRECTION_LEFT = "left";
    private static final Splitter splitter = Splitter.on((String)"\t");

    public SplitReadEvidenceCodec() {
        super(SplitReadEvidence.class);
    }

    public TabixFormat getTabixFormat() {
        return new TabixFormat(65536, 1, 2, 0, '#', 0);
    }

    public SplitReadEvidence decode(String line) {
        List tokens = splitter.splitToList((CharSequence)line);
        if (tokens.size() != 5) {
            throw new IllegalArgumentException("Invalid number of columns: " + tokens.size());
        }
        String contig = (String)tokens.get(0);
        int position = Integer.parseUnsignedInt((String)tokens.get(1)) + 1;
        if (!((String)tokens.get(2)).equals(DIRECTION_LEFT) && !((String)tokens.get(2)).equals(DIRECTION_RIGHT)) {
            throw new IllegalArgumentException("Invalid direction: " + (String)tokens.get(2));
        }
        boolean strand = ((String)tokens.get(2)).equals(DIRECTION_RIGHT);
        int count = Integer.parseUnsignedInt((String)tokens.get(3));
        String sample = (String)tokens.get(4);
        return new SplitReadEvidence(sample, contig, position, count, strand);
    }

    public boolean canDecode(String path) {
        String toDecode = IOUtil.hasBlockCompressedExtension((String)path) ? path.substring(0, path.lastIndexOf(".")) : path;
        return toDecode.toLowerCase().endsWith(FORMAT_SUFFIX);
    }

    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    public static String encode(SplitReadEvidence ev) {
        List<String> columns = Arrays.asList(ev.getContig(), Integer.toString(ev.getStart() - 1), ev.getStrand() ? DIRECTION_RIGHT : DIRECTION_LEFT, Integer.toString(ev.getCount()), ev.getSample());
        return String.join((CharSequence)COL_DELIMITER, columns);
    }
}

