/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.copynumber;

import com.google.common.collect.ImmutableList;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.LineReader;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.MetadataUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.SimpleCount;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.TableUtils;

public final class SimpleCountCodec
extends AsciiFeatureCodec<SimpleCount> {
    private static final int SAM_HEADER_LINES_INITIAL_CAPACITY = 10000;
    private static final String COLUMN_HEADER_STRING = String.join((CharSequence)TableUtils.COLUMN_SEPARATOR_STRING, SimpleCountCollection.SimpleCountTableColumn.COLUMNS.names());
    private static final int TABIX_FORMAT_SEQUENCE_COLUMN = 1;
    private static final int TABIX_FORMAT_START_POSITION_COLUMN = 2;
    private static final int TABIX_FORMAT_END_POSITION_COLUMN = 3;
    private static final char TABIX_FORMAT_META_CHARACTER = "@".charAt(0);
    public static final List<String> SIMPLE_COUNT_CODEC_EXTENSIONS = ImmutableList.of((Object)".counts.tsv", (Object)".counts.tsv.gz");

    public SimpleCountCodec() {
        super(SimpleCount.class);
    }

    public SimpleCount decode(String line) {
        if (line.startsWith("@") || line.startsWith(COLUMN_HEADER_STRING)) {
            return null;
        }
        String[] split = line.split(TableUtils.COLUMN_SEPARATOR_STRING);
        try {
            return new SimpleCount(new SimpleInterval(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2])), Integer.parseInt(split[3]));
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile("Line = " + line + " is not formatted correctly.");
        }
    }

    public SampleLocatableMetadata readActualHeader(LineIterator reader) {
        ArrayList<String> samHeaderLines = new ArrayList<String>(10000);
        boolean isSAMHeaderPresent = false;
        while (reader.hasNext()) {
            String line = reader.peek();
            if (line.startsWith("@")) {
                isSAMHeaderPresent = true;
                samHeaderLines.add(line);
                reader.next();
                continue;
            }
            if (!isSAMHeaderPresent) {
                throw new UserException.MalformedFile("SAM header lines must be at the beginning of the file.");
            }
            if (!line.startsWith(COLUMN_HEADER_STRING)) {
                throw new UserException.MalformedFile("File does not have a column header.");
            }
            reader.next();
            break;
        }
        SAMFileHeader samFileHeader = new SAMTextHeaderCodec().decode((LineReader)BufferedLineReader.fromString((String)StringUtils.join(samHeaderLines, (String)System.lineSeparator())), null);
        return (SampleLocatableMetadata)MetadataUtils.fromHeader(samFileHeader, Metadata.Type.SAMPLE_LOCATABLE);
    }

    public boolean canDecode(String path) {
        return SIMPLE_COUNT_CODEC_EXTENSIONS.stream().anyMatch(path::endsWith);
    }

    public TabixFormat getTabixFormat() {
        return new TabixFormat(0, 1, 2, 3, TABIX_FORMAT_META_CHARACTER, 0);
    }
}

