/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.AbstractFeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.SynchronousLineReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfCDSFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfExonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfGeneFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfSelenocysteineFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfStartCodonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfStopCodonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfTranscriptFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfUTRFeature;

public abstract class AbstractGtfCodec
extends AbstractFeatureCodec<GencodeGtfFeature, LineIterator> {
    static final Logger logger = LogManager.getLogger(AbstractGtfCodec.class);
    public static final String GTF_FILE_EXTENSION = "gtf";
    static final String FIELD_DELIMITER = "\t";
    static final int NUM_COLUMNS = 9;
    static final int FEATURE_TYPE_FIELD_INDEX = 2;
    static final int MAX_NUM_HEADER_LINES_TO_CHECK = 100;

    protected AbstractGtfCodec() {
        super(GencodeGtfFeature.class);
    }

    public boolean canDecode(String inputFilePath) {
        boolean canDecode;
        block16: {
            try {
                Path p = IOUtil.getPath((String)inputFilePath);
                canDecode = this.passesFileNameCheck(inputFilePath);
                if (!canDecode) break block16;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(p, new OpenOption[0])));){
                    String line;
                    ArrayList<String> headerLines = new ArrayList<String>(100);
                    for (int i = 0; i < 100 && (line = br.readLine()) != null && this.isLineCommented(line); ++i) {
                        headerLines.add(line);
                    }
                    canDecode = this.validateHeader(headerLines);
                }
            }
            catch (FileNotFoundException ex) {
                logger.warn("File does not exist! - " + inputFilePath + " - returning can decode as failure.");
                canDecode = false;
            }
            catch (IOException ex) {
                logger.warn("Caught IOException on file: " + inputFilePath + " - returning can decode as failure.");
                canDecode = false;
            }
        }
        return canDecode;
    }

    public GencodeGtfFeature decode(LineIterator lineIterator) {
        GencodeGtfGeneFeature decodedFeature = null;
        GencodeGtfGeneFeature gene = null;
        GencodeGtfTranscriptFeature transcript = null;
        ArrayList<GencodeGtfExonFeature> exonStore = new ArrayList<GencodeGtfExonFeature>();
        ArrayList<GencodeGtfFeature> leafFeatureStore = new ArrayList<GencodeGtfFeature>();
        boolean needToFlushRecords = false;
        while (lineIterator.hasNext()) {
            String line = lineIterator.peek();
            if (this.isLineCommented(line)) {
                lineIterator.next();
                return null;
            }
            String[] splitLine = this.splitGtfLine(line);
            GencodeGtfFeature.FeatureType featureType = GencodeGtfFeature.FeatureType.getEnum(splitLine[2]);
            GencodeGtfFeature feature = GencodeGtfFeature.create(splitLine, this.getGtfFileType());
            feature.setFeatureOrderNumber(this.getCurrentLineNumber());
            feature.setUcscGenomeVersion(this.getUcscVersionNumber());
            if (gene != null && featureType == GencodeGtfFeature.FeatureType.GENE) {
                AbstractGtfCodec.aggregateRecordsIntoGeneFeature(gene, transcript, exonStore, leafFeatureStore);
                decodedFeature = gene;
                needToFlushRecords = false;
                break;
            }
            if (transcript != null && featureType == GencodeGtfFeature.FeatureType.TRANSCRIPT) {
                AbstractGtfCodec.aggregateRecordsIntoGeneFeature(gene, transcript, exonStore, leafFeatureStore);
                transcript = (GencodeGtfTranscriptFeature)feature;
                this.incrementLineNumber();
                needToFlushRecords = true;
            } else {
                switch (featureType) {
                    case GENE: {
                        gene = (GencodeGtfGeneFeature)feature;
                        break;
                    }
                    case TRANSCRIPT: {
                        transcript = (GencodeGtfTranscriptFeature)feature;
                        break;
                    }
                    case EXON: {
                        exonStore.add((GencodeGtfExonFeature)feature);
                        break;
                    }
                    default: {
                        leafFeatureStore.add(feature);
                    }
                }
                needToFlushRecords = false;
                this.incrementLineNumber();
            }
            lineIterator.next();
        }
        if (!(gene == null || !needToFlushRecords && exonStore.isEmpty() && leafFeatureStore.isEmpty())) {
            AbstractGtfCodec.aggregateRecordsIntoGeneFeature(gene, transcript, exonStore, leafFeatureStore);
            decodedFeature = gene;
        }
        if (!exonStore.isEmpty() || !leafFeatureStore.isEmpty()) {
            if (!exonStore.isEmpty()) {
                logger.error("Gene Feature Aggregation: Exon store not empty: " + ((Object)exonStore).toString());
            }
            if (!leafFeatureStore.isEmpty()) {
                logger.error("Gene Feature Aggregation: leaf feature store not empty: " + ((Object)leafFeatureStore).toString());
            }
            String msg = "Aggregated data left over after parsing complete: Exons: " + exonStore.size() + " ; LeafFeatures: " + leafFeatureStore.size();
            throw new GATKException.ShouldNeverReachHereException(msg);
        }
        if (!this.validateFeature(decodedFeature)) {
            throw new UserException.MalformedFile("Decoded feature is not valid: " + decodedFeature);
        }
        return decodedFeature;
    }

    public void close(LineIterator lineIterator) {
        CloserUtil.close((Object)lineIterator);
    }

    public boolean isDone(LineIterator lineIterator) {
        return !lineIterator.hasNext();
    }

    public LineIterator makeSourceFromStream(InputStream bufferedInputStream) {
        return new LineIteratorImpl((LineReader)new SynchronousLineReader(bufferedInputStream));
    }

    public FeatureCodecHeader readHeader(LineIterator lineIterator) {
        return new FeatureCodecHeader(this.readActualHeader(lineIterator), 0L);
    }

    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        return new AsciiLineReaderIterator(AsciiLineReader.from((InputStream)bufferedInputStream));
    }

    private static void aggregateRecordsIntoGeneFeature(GencodeGtfGeneFeature gene, GencodeGtfTranscriptFeature transcript, List<GencodeGtfExonFeature> exonStore, List<GencodeGtfFeature> leafFeatureStore) {
        for (GencodeGtfExonFeature exon : exonStore) {
            Iterator<GencodeGtfFeature> iterator = leafFeatureStore.iterator();
            while (iterator.hasNext()) {
                GencodeGtfFeature feature = iterator.next();
                if (!exon.contains((Locatable)feature)) continue;
                GencodeGtfFeature.FeatureType featureType = feature.getFeatureType();
                switch (featureType) {
                    case CDS: {
                        exon.setCds((GencodeGtfCDSFeature)feature);
                        break;
                    }
                    case START_CODON: {
                        exon.setStartCodon((GencodeGtfStartCodonFeature)feature);
                        break;
                    }
                    case STOP_CODON: {
                        exon.setStopCodon((GencodeGtfStopCodonFeature)feature);
                        break;
                    }
                    case UTR: {
                        transcript.addUtr((GencodeGtfUTRFeature)feature);
                        break;
                    }
                    case SELENOCYSTEINE: {
                        transcript.addSelenocysteine((GencodeGtfSelenocysteineFeature)feature);
                        break;
                    }
                    default: {
                        throw new UserException.MalformedFile("Found unexpected Feature Type in GENCODE GTF File (line " + feature.getFeatureOrderNumber() + "): " + featureType.toString());
                    }
                }
                iterator.remove();
            }
            transcript.addExon(exon);
        }
        gene.addTranscript(transcript);
        exonStore.clear();
        leafFeatureStore.clear();
    }

    @VisibleForTesting
    boolean validateHeader(List<String> header) {
        return this.validateHeader(header, false);
    }

    private boolean validateFeature(GencodeGtfFeature feature) {
        return AbstractGtfCodec.validateBaseGtfFeatureFields(feature) && this.validateFeatureSubtype(feature);
    }

    private static boolean validateBaseGtfFeatureFields(GencodeGtfFeature feature) {
        if (feature == null) {
            return false;
        }
        GencodeGtfFeature.FeatureType featureType = feature.getFeatureType();
        if (feature.getChromosomeName() == null) {
            return false;
        }
        if (feature.getAnnotationSource() == null) {
            return false;
        }
        if (feature.getFeatureType() == null) {
            return false;
        }
        if (feature.getGenomicStrand() == null) {
            return false;
        }
        if (feature.getGenomicPhase() == null) {
            return false;
        }
        if (feature.getGeneId() == null) {
            return false;
        }
        if (feature.getGeneType() == null) {
            return false;
        }
        if (feature.getGeneName() == null) {
            return false;
        }
        if (featureType != GencodeGtfFeature.FeatureType.GENE && featureType != GencodeGtfFeature.FeatureType.TRANSCRIPT && featureType != GencodeGtfFeature.FeatureType.SELENOCYSTEINE) {
            if (feature.getExonNumber() == -1) {
                return false;
            }
            return feature.getExonId() != null;
        }
        return true;
    }

    private String[] splitGtfLine(String line) {
        String[] splitLine = line.split(FIELD_DELIMITER, -1);
        if (splitLine.length != 9) {
            throw new UserException.MalformedFile("Found an invalid number of columns in the given GTF file on line " + this.getCurrentLineNumber() + " - Given: " + splitLine.length + " Expected: " + 9 + " : " + line);
        }
        return splitLine;
    }

    void ingestHeaderLines(LineIterator reader) {
        String line;
        while (reader.hasNext() && this.isLineCommented(line = reader.peek())) {
            this.getHeader().add(line);
            reader.next();
        }
    }

    boolean checkHeaderLineStartsWith(List<String> header, int lineNum, String startingText) {
        return this.checkHeaderLineStartsWith(header, lineNum, startingText, false);
    }

    boolean checkHeaderLineStartsWith(List<String> header, int lineNum, String startingText, boolean throwIfInvalid) {
        boolean foundGoodLine = this.isLineCommented(header.get(lineNum), startingText);
        if (!foundGoodLine) {
            if (throwIfInvalid) {
                throw new UserException.MalformedFile(this.getGtfFileType() + " GTF Header line " + (lineNum + 1) + " does not contain expected information (" + this.getDefaultLineComment() + startingText + "): " + header.get(lineNum));
            }
            return false;
        }
        return true;
    }

    boolean isLineCommented(String line) {
        return this.isLineCommented(line, "");
    }

    boolean isLineCommented(String line, String linePrefix) {
        boolean isCommented = false;
        for (String commentPrefix : this.getAllLineComments()) {
            if (!line.startsWith(commentPrefix + linePrefix)) continue;
            isCommented = true;
            break;
        }
        return isCommented;
    }

    abstract int getCurrentLineNumber();

    abstract void incrementLineNumber();

    abstract List<String> getHeader();

    abstract String getDefaultLineComment();

    abstract Set<String> getAllLineComments();

    abstract String getGtfFileType();

    abstract boolean passesFileNameCheck(String var1);

    @VisibleForTesting
    abstract boolean validateHeader(List<String> var1, boolean var2);

    abstract boolean validateFeatureSubtype(GencodeGtfFeature var1);

    abstract String getUcscVersionNumber();

    abstract List<String> readActualHeader(LineIterator var1);
}

