/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.readers.LineIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.codecs.gtf.AbstractGtfCodec;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfCodec;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;

public final class EnsemblGtfCodec
extends AbstractGtfCodec {
    private static final Logger logger = LogManager.getLogger(EnsemblGtfCodec.class);
    public static String GTF_FILE_TYPE_STRING = "ENSEMBL";
    private static String VERSION_FIELD = "genome-version";
    private static String DEFAULT_VERSION = "ENSEMBL_DEFAULT_VERSION";
    private static final Set<String> COMMENT_PREFIXES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("#!", "##")));
    private final List<String> header = new ArrayList<String>();
    private int currentLineNum = 1;
    private String version = null;

    @Override
    String getGtfFileType() {
        return GTF_FILE_TYPE_STRING;
    }

    @Override
    String getDefaultLineComment() {
        return COMMENT_PREFIXES.iterator().next();
    }

    @Override
    Set<String> getAllLineComments() {
        return COMMENT_PREFIXES;
    }

    @Override
    int getCurrentLineNumber() {
        return this.currentLineNum;
    }

    @Override
    List<String> getHeader() {
        return this.header;
    }

    @Override
    boolean passesFileNameCheck(String inputFilePath) {
        try {
            Path p = IOUtil.getPath((String)inputFilePath);
            return p.getFileName().toString().toLowerCase().endsWith(".gtf");
        }
        catch (FileNotFoundException ex) {
            logger.warn("File does not exist! - " + inputFilePath + " - returning name check as failure.");
        }
        catch (IOException ex) {
            logger.warn("Caught IOException on file: " + inputFilePath + " - returning name check as failure.");
        }
        return false;
    }

    @Override
    List<String> readActualHeader(LineIterator reader) {
        this.ingestHeaderLines(reader);
        this.validateHeader(this.header, true);
        this.currentLineNum = this.header.size() + 1;
        this.populateVersionNumber();
        return this.header;
    }

    @Override
    boolean validateFeatureSubtype(GencodeGtfFeature feature) {
        return EnsemblGtfCodec.validateEnsemblGtfFeature(feature);
    }

    @Override
    void incrementLineNumber() {
        ++this.currentLineNum;
    }

    @Override
    String getUcscVersionNumber() {
        return this.version;
    }

    @Override
    public boolean canDecode(String inputFilePath) {
        GencodeGtfCodec gencodeGtfCodec = new GencodeGtfCodec();
        if (gencodeGtfCodec.canDecode(inputFilePath)) {
            return false;
        }
        return super.canDecode(inputFilePath);
    }

    private static boolean validateEnsemblGtfFeature(GencodeGtfFeature feature) {
        GencodeGtfFeature.FeatureType featureType = feature.getFeatureType();
        if (featureType != GencodeGtfFeature.FeatureType.GENE) {
            if (feature.getTranscriptId() == null) {
                return false;
            }
            if (feature.getTranscriptType() == null) {
                return false;
            }
            if (feature.getTranscriptName() == null) {
                return false;
            }
        }
        return true;
    }

    private void populateVersionNumber() {
        String ver = DEFAULT_VERSION;
        for (String line : this.header) {
            for (String comment : this.getAllLineComments()) {
                if (!line.startsWith(comment + VERSION_FIELD)) continue;
                ver = line.replaceFirst(comment + VERSION_FIELD + "\\s*", "").trim();
            }
        }
        this.version = ver;
    }

    @Override
    @VisibleForTesting
    boolean validateHeader(List<String> header, boolean throwIfInvalid) {
        int lineNum = 1;
        for (String line : header) {
            if (!this.isLineCommented(line)) {
                if (throwIfInvalid) {
                    throw new UserException.MalformedFile("ENSEMBL GTF Header line " + lineNum + " is not commented: " + line);
                }
                return false;
            }
            ++lineNum;
        }
        return true;
    }
}

