/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.readers.LineIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.codecs.gtf.AbstractGtfCodec;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;

public final class GencodeGtfCodec
extends AbstractGtfCodec {
    private static final Logger logger = LogManager.getLogger(GencodeGtfCodec.class);
    public static final String GENCODE_GTF_FILE_PREFIX = "gencode";
    public static final String GTF_FILE_TYPE_STRING = "GENCODE";
    private static final int GENCODE_GTF_MIN_VERSION_NUM_INCLUSIVE = 19;
    private static final int GENCODE_GTF_MAX_VERSION_NUM_INCLUSIVE = 34;
    private int currentLineNum = 1;
    private final List<String> header = new ArrayList<String>();
    private static final int HEADER_NUM_LINES = 5;
    private static final Pattern VERSION_PATTERN = Pattern.compile("version (\\d+)");
    private int versionNumber;
    private static final String commentPrefix = "##";

    private static String getUcscVersionFromGencodeVersion(int gencodeVersion) {
        if (gencodeVersion < 19) {
            throw new GATKException("Gencode version is too far out of date.  Cannot decode: " + gencodeVersion);
        }
        if (gencodeVersion < 25) {
            return "hg19";
        }
        return "hg38";
    }

    @Override
    int getCurrentLineNumber() {
        return this.currentLineNum;
    }

    @Override
    List<String> getHeader() {
        return this.header;
    }

    @Override
    List<String> readActualHeader(LineIterator reader) {
        this.versionNumber = -1;
        this.ingestHeaderLines(reader);
        this.validateHeader(this.header, true);
        this.setVersionNumber();
        this.currentLineNum = this.header.size() + 1;
        return this.header;
    }

    private void setVersionNumber() {
        try {
            Matcher versionMatcher = VERSION_PATTERN.matcher(this.header.get(0));
            if (!versionMatcher.find()) {
                throw new UserException.MalformedFile("Cannot find version number from Gencode GTF header.");
            }
            this.versionNumber = Integer.valueOf(versionMatcher.group(1));
        }
        catch (NumberFormatException ex) {
            throw new UserException("Could not read version number from header", ex);
        }
    }

    private static boolean validateGencodeGtfFeature(GencodeGtfFeature feature, int gtfVersion) {
        if (gtfVersion < 19) {
            throw new GATKException("Invalid version number for validation: " + gtfVersion + " must be above: " + 19);
        }
        GencodeGtfFeature.FeatureType featureType = feature.getFeatureType();
        if (gtfVersion < 26) {
            if (feature.getGeneStatus() == null) {
                return false;
            }
            if (feature.getTranscriptStatus() == null) {
                return false;
            }
        }
        if (featureType != GencodeGtfFeature.FeatureType.GENE || gtfVersion < 21) {
            if (feature.getTranscriptId() == null) {
                return false;
            }
            if (feature.getTranscriptType() == null) {
                return false;
            }
            if (feature.getTranscriptName() == null) {
                return false;
            }
        }
        return feature.getAnnotationSource().equals("ENSEMBL") || feature.getAnnotationSource().equals("HAVANA");
    }

    @Override
    boolean passesFileNameCheck(String inputFilePath) {
        try {
            Path p = IOUtil.getPath((String)inputFilePath);
            return p.getFileName().toString().toLowerCase().startsWith(GENCODE_GTF_FILE_PREFIX) && p.getFileName().toString().toLowerCase().endsWith(".gtf");
        }
        catch (FileNotFoundException ex) {
            logger.warn("File does not exist! - " + inputFilePath + " - returning name check as failure.");
        }
        catch (IOException ex) {
            logger.warn("Caught IOException on file: " + inputFilePath + " - returning name check as failure.");
        }
        return false;
    }

    @Override
    String getDefaultLineComment() {
        return commentPrefix;
    }

    @Override
    Set<String> getAllLineComments() {
        return Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList(commentPrefix)));
    }

    @Override
    String getGtfFileType() {
        return GTF_FILE_TYPE_STRING;
    }

    @Override
    boolean validateFeatureSubtype(GencodeGtfFeature feature) {
        return GencodeGtfCodec.validateGencodeGtfFeature(feature, this.versionNumber);
    }

    @Override
    void incrementLineNumber() {
        ++this.currentLineNum;
    }

    @Override
    String getUcscVersionNumber() {
        return GencodeGtfCodec.getUcscVersionFromGencodeVersion(this.versionNumber);
    }

    @Override
    @VisibleForTesting
    boolean validateHeader(List<String> header, boolean throwIfInvalid) {
        if (header.size() != 5) {
            if (throwIfInvalid) {
                throw new UserException.MalformedFile("GENCODE GTF Header is of unexpected length: " + header.size() + " != " + 5);
            }
            return false;
        }
        if (!this.checkHeaderLineStartsWith(header, 0, "description:")) {
            return false;
        }
        if (!header.get(0).contains("version")) {
            if (throwIfInvalid) {
                throw new UserException.MalformedFile("GENCODE GTF Header line 1 does not contain version specification: " + header.get(0));
            }
            return false;
        }
        Matcher versionMatcher = VERSION_PATTERN.matcher(header.get(0));
        if (!versionMatcher.find()) {
            if (throwIfInvalid) {
                throw new UserException.MalformedFile("GENCODE GTF Header line 1 does not contain a recognizable version number: " + header.get(0));
            }
            return false;
        }
        try {
            int versionNumber = Integer.valueOf(versionMatcher.group(1));
            if (versionNumber < 19) {
                String message = "GENCODE GTF Header line 1 has an out-of-date (< v19 version number (" + versionNumber + "): " + header.get(0);
                if (throwIfInvalid) {
                    throw new UserException.MalformedFile(message);
                }
                logger.warn(message + "   Continuing, but errors may occur.");
            }
            if (versionNumber > 34) {
                logger.warn("GENCODE GTF Header line 1 has a version number that is above maximum tested version (v 34) (given: " + versionNumber + "): " + header.get(0) + "   Continuing, but errors may occur.");
            }
        }
        catch (NumberFormatException ex) {
            if (throwIfInvalid) {
                throw new UserException("Could not create number value for version: " + versionMatcher.group(1), ex);
            }
            return false;
        }
        return this.checkHeaderLineStartsWith(header, 1, "provider: GENCODE") && this.checkHeaderLineStartsWith(header, 2, "contact: gencode") && this.checkHeaderLineStartsWith(header, 3, "format: gtf") && this.checkHeaderLineStartsWith(header, 4, "date:");
    }
}

