/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import htsjdk.tribble.annotation.Strand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfCDSFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfExonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeatureBaseData;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfGeneFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfSelenocysteineFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfStartCodonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfStopCodonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfTranscriptFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfUTRFeature;

public abstract class GencodeGtfFeature
implements Feature,
Comparable<GencodeGtfFeature> {
    private static final Logger logger = LogManager.getLogger(GencodeGtfFeature.class);
    public static final String ANNOTATION_SOURCE_ENSEMBL = "ENSEMBL";
    public static final String ANNOTATION_SOURCE_HAVANA = "HAVANA";
    public static final String ANNOTATION_SOURCE_ENA = "ena";
    private static final String FIELD_DELIMITER = "\t";
    public static final int NO_FEATURE_ORDER = -1;
    public static final int NO_EXON_NUMBER = -1;
    private static final int NUM_FIELDS = 9;
    private static final int CHROMOSOME_NAME_INDEX = 0;
    private static final int ANNOTATION_SOURCE_INDEX = 1;
    private static final int FEATURE_TYPE_INDEX = 2;
    private static final int START_LOCATION_INDEX = 3;
    private static final int END_LOCATION_INDEX = 4;
    private static final int GENOMIC_STRAND_INDEX = 6;
    private static final int GENOMIC_PHASE_INDEX = 7;
    private static final int EXTRA_FIELDS_INDEX = 8;
    private static final String EXTRA_FIELD_DELIMITER = ";";
    private static final int EXTRA_FIELD_KEY_INDEX = 0;
    private static final int EXTRA_FIELD_VALUE_INDEX = 1;
    public static final String EXTRA_FIELD_KEY_VALUE_SPLITTER = " ";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d\\d*");
    private String ucscGenomeVersion = null;
    @VisibleForTesting
    final GencodeGtfFeatureBaseData baseData;

    protected GencodeGtfFeature(String[] gtfFields, String gtfFileType) {
        Utils.validateArg(gtfFields.length == 9, "Unexpected number of fields: " + gtfFields.length + " != " + 9);
        this.baseData = new GencodeGtfFeatureBaseData();
        try {
            this.baseData.genomicPosition = new SimpleInterval(gtfFields[0], Integer.valueOf(gtfFields[3]), Integer.valueOf(gtfFields[4]));
        }
        catch (NumberFormatException ex) {
            throw new UserException.MalformedFile("Cannot read integer value for start/end position!");
        }
        this.baseData.gtfSourceFileType = gtfFileType;
        this.baseData.annotationSource = gtfFields[1];
        this.baseData.featureType = FeatureType.getEnum(gtfFields[2].toLowerCase());
        this.baseData.genomicStrand = GencodeGtfFeature.convertStringToStrand(gtfFields[6]);
        this.baseData.genomicPhase = GenomicPhase.getEnum(gtfFields[7]);
        String[] extraFields = gtfFields[8].split(EXTRA_FIELD_DELIMITER, -1);
        StringBuilder anonymousOptionalFieldBuilder = new StringBuilder();
        for (String extraField : extraFields) {
            String trimmedExtraField = extraField.trim();
            if (trimmedExtraField.isEmpty()) continue;
            int splitPoint = trimmedExtraField.indexOf(EXTRA_FIELD_KEY_VALUE_SPLITTER);
            if (splitPoint == -1) {
                throw new UserException.MalformedFile("Extraneous optional field data - not in a key/value pair: " + extraField);
            }
            String fieldName = trimmedExtraField.substring(0, splitPoint).trim();
            String rawFieldValue = trimmedExtraField.substring(splitPoint + 1, trimmedExtraField.length());
            String fieldValue = StringUtils.remove((String)rawFieldValue.trim(), (char)'\"');
            if (fieldValue.contains(EXTRA_FIELD_KEY_VALUE_SPLITTER)) {
                throw new UserException("Expected a key/value pair but found several values " + fieldName + "/" + fieldValue);
            }
            OptionalField<Object> optionalField = null;
            switch (fieldName) {
                case "gene_id": {
                    this.baseData.geneId = fieldValue;
                    break;
                }
                case "transcript_id": {
                    this.baseData.transcriptId = fieldValue;
                    break;
                }
                case "gene_type": {
                    this.baseData.geneType = GeneTranscriptType.getEnum(fieldValue);
                    break;
                }
                case "gene_biotype": {
                    this.baseData.geneType = GeneTranscriptType.getEnum(fieldValue);
                    break;
                }
                case "gene_status": {
                    this.baseData.geneStatus = GeneTranscriptStatus.valueOf(fieldValue);
                    break;
                }
                case "gene_name": {
                    this.baseData.geneName = fieldValue;
                    break;
                }
                case "transcript_type": {
                    this.baseData.transcriptType = GeneTranscriptType.getEnum(fieldValue);
                    break;
                }
                case "transcript_biotype": {
                    this.baseData.transcriptType = GeneTranscriptType.getEnum(fieldValue);
                    break;
                }
                case "transcript_status": {
                    this.baseData.transcriptStatus = GeneTranscriptStatus.valueOf(fieldValue);
                    break;
                }
                case "transcript_name": {
                    this.baseData.transcriptName = fieldValue;
                    break;
                }
                case "exon_number": {
                    try {
                        this.baseData.exonNumber = Integer.valueOf(fieldValue);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new UserException.MalformedFile("Could not convert field value into integer: " + fieldValue);
                    }
                }
                case "exon_id": {
                    this.baseData.exonId = fieldValue;
                    break;
                }
                case "level": {
                    this.baseData.locusLevel = LocusLevel.getEnum(fieldValue);
                    break;
                }
                case "tag": {
                    optionalField = new OptionalField<FeatureTag>(fieldName, FeatureTag.getEnum(fieldValue));
                    break;
                }
                case "ccdsid": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                case "havana_gene": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                case "havana_transcript": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                case "protein_id": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                case "ont": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                case "transcript_support_level": {
                    optionalField = new OptionalField<TranscriptSupportLevel>(fieldName, TranscriptSupportLevel.getEnum(fieldValue));
                    break;
                }
                case "remap_status": {
                    optionalField = new OptionalField<RemapStatus>(fieldName, RemapStatus.getEnum(fieldValue));
                    break;
                }
                case "remap_original_id": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                case "remap_original_location": {
                    try {
                        optionalField = new OptionalField<Long>(fieldName, Long.valueOf(fieldValue));
                    }
                    catch (NumberFormatException nfe) {
                        optionalField = new OptionalField<String>(fieldName, fieldValue);
                    }
                    break;
                }
                case "remap_num_mappings": {
                    optionalField = new OptionalField<Long>(fieldName, Long.valueOf(fieldValue));
                    break;
                }
                case "remap_target_status": {
                    optionalField = new OptionalField<RemapTargetStatus>(fieldName, RemapTargetStatus.getEnum(fieldValue));
                    break;
                }
                case "remap_substituted_missing_target": {
                    optionalField = new OptionalField<String>(fieldName, fieldValue);
                    break;
                }
                default: {
                    anonymousOptionalFieldBuilder.append(extraField);
                    anonymousOptionalFieldBuilder.append(EXTRA_FIELD_DELIMITER);
                }
            }
            if (optionalField == null) continue;
            this.baseData.optionalFields.add(optionalField);
        }
        if (anonymousOptionalFieldBuilder.length() != 0) {
            this.baseData.anonymousOptionalFields = anonymousOptionalFieldBuilder.toString();
        }
    }

    private static Strand convertStringToStrand(String s) {
        if (s.equals("+")) {
            return Strand.POSITIVE;
        }
        if (s.equals("-")) {
            return Strand.NEGATIVE;
        }
        throw new IllegalArgumentException("Unexpected value: " + s);
    }

    protected GencodeGtfFeature(GencodeGtfFeatureBaseData baseData) {
        this.baseData = baseData;
    }

    public static GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
        Utils.nonNull(baseData);
        return baseData.featureType.create(baseData);
    }

    public static GencodeGtfFeature create(String gtfLine, String gtfFileType) {
        Utils.nonNull(gtfLine);
        return GencodeGtfFeature.create(gtfLine.split(FIELD_DELIMITER), gtfFileType);
    }

    public static GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
        Utils.nonNull(gtfFields);
        if (gtfFields.length != 9) {
            throw new UserException.MalformedFile("Invalid number of fields in the given GENCODE line  - Given: " + gtfFields.length + " Expected: " + 9);
        }
        FeatureType featureType = FeatureType.getEnum(gtfFields[2]);
        return featureType.create(gtfFields, gtfFileType);
    }

    public String getContig() {
        return this.baseData.genomicPosition.getContig();
    }

    public int getStart() {
        return this.baseData.genomicPosition.getStart();
    }

    public int getEnd() {
        return this.baseData.genomicPosition.getEnd();
    }

    @VisibleForTesting
    List<GencodeGtfFeature> getAllFeatures() {
        ArrayList<GencodeGtfFeature> list = new ArrayList<GencodeGtfFeature>();
        list.add(this);
        return list;
    }

    private String serializeToStringHelper() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.baseData.genomicPosition.getContig());
        stringBuilder.append('\t');
        stringBuilder.append(this.baseData.annotationSource);
        stringBuilder.append('\t');
        stringBuilder.append((Object)this.baseData.featureType);
        stringBuilder.append('\t');
        stringBuilder.append(this.baseData.genomicPosition.getStart());
        stringBuilder.append('\t');
        stringBuilder.append(this.baseData.genomicPosition.getEnd());
        stringBuilder.append("\t.\t");
        stringBuilder.append(this.baseData.genomicStrand);
        stringBuilder.append('\t');
        stringBuilder.append((Object)this.baseData.genomicPhase);
        stringBuilder.append('\t');
        if (this.baseData.geneId != null) {
            stringBuilder.append("gene_id \"");
            stringBuilder.append(this.baseData.geneId);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.transcriptId != null) {
            stringBuilder.append("transcript_id \"");
            stringBuilder.append(this.baseData.transcriptId);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.geneType != null) {
            stringBuilder.append("gene_type \"");
            stringBuilder.append((Object)this.baseData.geneType);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.geneStatus != null) {
            stringBuilder.append("gene_status \"");
            stringBuilder.append((Object)this.baseData.geneStatus);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.geneName != null) {
            stringBuilder.append("gene_name \"");
            stringBuilder.append(this.baseData.geneName);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.transcriptType != null) {
            stringBuilder.append("transcript_type \"");
            stringBuilder.append((Object)this.baseData.transcriptType);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.transcriptStatus != null) {
            stringBuilder.append("transcript_status \"");
            stringBuilder.append((Object)this.baseData.transcriptStatus);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.transcriptName != null) {
            stringBuilder.append("transcript_name \"");
            stringBuilder.append(this.baseData.transcriptName);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.exonNumber != -1) {
            stringBuilder.append("exon_number ");
            stringBuilder.append(this.baseData.exonNumber);
            stringBuilder.append("; ");
        }
        if (this.baseData.exonId != null) {
            stringBuilder.append("exon_id \"");
            stringBuilder.append(this.baseData.exonId);
            stringBuilder.append("\"; ");
        }
        if (this.baseData.locusLevel != null) {
            stringBuilder.append("level ");
            stringBuilder.append((Object)this.baseData.locusLevel);
            stringBuilder.append("; ");
        }
        stringBuilder.append(this.baseData.optionalFields.stream().map(Object::toString).collect(Collectors.joining(EXTRA_FIELD_KEY_VALUE_SPLITTER)));
        if (this.baseData.anonymousOptionalFields != null) {
            stringBuilder.append(this.baseData.anonymousOptionalFields);
        }
        return stringBuilder.toString().trim();
    }

    public String serializeToString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<GencodeGtfFeature> features = this.getAllFeatures();
        Collections.sort(features);
        for (GencodeGtfFeature feature : features) {
            stringBuilder.append(feature.serializeToStringHelper());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString().trim();
    }

    public String toString() {
        return this.serializeToString();
    }

    public String getGtfSourceFileType() {
        return this.baseData.gtfSourceFileType;
    }

    public String getUcscGenomeVersion() {
        return this.ucscGenomeVersion;
    }

    public void setUcscGenomeVersion(String ucscGenomeVersion) {
        this.ucscGenomeVersion = ucscGenomeVersion;
    }

    public SimpleInterval getGenomicPosition() {
        return this.baseData.genomicPosition;
    }

    public int getFeatureOrderNumber() {
        return this.baseData.featureOrderNumber;
    }

    public String getChromosomeName() {
        return this.baseData.genomicPosition.getContig();
    }

    public String getAnnotationSource() {
        return this.baseData.annotationSource;
    }

    public FeatureType getFeatureType() {
        return this.baseData.featureType;
    }

    public int getGenomicStartLocation() {
        return this.baseData.genomicPosition.getStart();
    }

    public int getGenomicEndLocation() {
        return this.baseData.genomicPosition.getEnd();
    }

    public Strand getGenomicStrand() {
        return this.baseData.genomicStrand;
    }

    public GenomicPhase getGenomicPhase() {
        return this.baseData.genomicPhase;
    }

    public String getGeneId() {
        return this.baseData.geneId;
    }

    public String getTranscriptId() {
        return this.baseData.transcriptId;
    }

    public GeneTranscriptType getGeneType() {
        return this.baseData.geneType;
    }

    public String getGeneName() {
        return this.baseData.geneName;
    }

    public GeneTranscriptType getTranscriptType() {
        return this.baseData.transcriptType;
    }

    public String getTranscriptName() {
        return this.baseData.transcriptName;
    }

    public GeneTranscriptStatus getGeneStatus() {
        return this.baseData.geneStatus;
    }

    public GeneTranscriptStatus getTranscriptStatus() {
        return this.baseData.transcriptStatus;
    }

    public int getExonNumber() {
        return this.baseData.exonNumber;
    }

    public String getExonId() {
        return this.baseData.exonId;
    }

    public LocusLevel getLocusLevel() {
        return this.baseData.locusLevel;
    }

    public List<OptionalField<?>> getOptionalFields() {
        return this.baseData.optionalFields;
    }

    public String getAnonymousOptionalFields() {
        return this.baseData.anonymousOptionalFields;
    }

    public OptionalField<?> getOptionalField(String key) {
        for (OptionalField<?> optionalField : this.baseData.optionalFields) {
            if (!optionalField.getName().equals(key)) continue;
            return optionalField;
        }
        return null;
    }

    @Override
    public int compareTo(GencodeGtfFeature other) {
        Utils.nonNull(other);
        return this.baseData.featureOrderNumber - other.baseData.featureOrderNumber;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean isEqual = that instanceof GencodeGtfFeature;
        if (isEqual) {
            GencodeGtfFeature thatFeature = (GencodeGtfFeature)that;
            isEqual = Objects.equals(this.baseData, thatFeature.baseData);
            if (isEqual) {
                isEqual = this.ucscGenomeVersion.equals(thatFeature.getUcscGenomeVersion());
            }
        }
        return isEqual;
    }

    public int hashCode() {
        return this.baseData != null ? this.baseData.hashCode() : 0;
    }

    public boolean contains(Locatable other) {
        return this.baseData.genomicPosition.contains(other);
    }

    public boolean overlaps(Locatable other) {
        return this.baseData.genomicPosition.overlaps(other);
    }

    public void setFeatureOrderNumber(int featureOrderNumber) {
        this.baseData.featureOrderNumber = featureOrderNumber;
    }

    public static enum RemapTargetStatus {
        NEW("new"),
        LOST("lost"),
        OVERLAP("overlap"),
        NONOVERLAP("nonOverlap");

        private static final Map<String, RemapTargetStatus> VALUE_MAP;
        private final String serialized;

        private RemapTargetStatus(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static RemapTargetStatus getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        static {
            VALUE_MAP = Arrays.stream(RemapTargetStatus.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum RemapStatus {
        FULL_CONTIG("full_contig"),
        FULL_FRAGMENT("full_fragment"),
        PARTIAL("partial"),
        DELETED("deleted"),
        NO_SEQ_MAP("no_seq_map"),
        GENE_CONFLICT("gene_conflict"),
        GENE_SIZE_CHANGE("gene_size_change"),
        AUTOMATIC_SMALL_NCRNA_GENE("automatic_small_ncrna_gene"),
        AUTOMATIC_GENE("automatic_gene"),
        PSEUDOGENE("pseudogene");

        private static final Map<String, RemapStatus> VALUE_MAP;
        private final String serialized;

        private RemapStatus(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static RemapStatus getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        static {
            VALUE_MAP = Arrays.stream(RemapStatus.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum TranscriptSupportLevel {
        ALL_MRNA_VERIFIED("1"),
        BEST_MRNA_SUSPECT("2"),
        SINGLE_EST_SUPPORT("3"),
        BEST_EST_SUSPECT("4"),
        NO_SINGLE_TRANSCRIPT_SUPPORT("5"),
        NA("NA");

        private static final Map<String, TranscriptSupportLevel> VALUE_MAP;
        private final String serialized;

        private TranscriptSupportLevel(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static TranscriptSupportLevel getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        static {
            VALUE_MAP = Arrays.stream(TranscriptSupportLevel.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum FeatureTag {
        THREE_PRIME_NESTED_SUPPORTED_EXTENSION("3_nested_supported_extension"),
        THREE_PRIME_STANDARD_SUPPORTED_EXTENSION("3_standard_supported_extension"),
        FOURFIVEFOUR_RNA_SEQ_SUPPORTED("454_RNA_Seq_supported"),
        FIVE_PRIME_NESTED_SUPPORTED_EXTENSION("5_nested_supported_extension"),
        FIVE_PRIME_STANDARD_SUPPORTED_EXTENSION("5_standard_supported_extension"),
        ALTERNATIVE_3_UTR("alternative_3_UTR"),
        ALTERNATIVE_5_UTR("alternative_5_UTR"),
        APPRIS_PRINCIPAL("appris_principal"),
        APPRIS_PRINCIPAL_1("appris_principal_1"),
        APPRIS_PRINCIPAL_2("appris_principal_2"),
        APPRIS_PRINCIPAL_3("appris_principal_3"),
        APPRIS_PRINCIPAL_4("appris_principal_4"),
        APPRIS_PRINCIPAL_5("appris_principal_5"),
        APPRIS_ALTERNATIVE_1("appris_alternative_1"),
        APPRIS_ALTERNATIVE_2("appris_alternative_2"),
        APPRIS_CANDIDATE_HIGHEST_SCORE("appris_candidate_highest_score"),
        APPRIS_CANDIDATE_LONGEST_CCDS("appris_candidate_longest_ccds"),
        APPRIS_CANDIDATE_CCDS("appris_candidate_ccds"),
        APPRIS_CANDIDATE_LONGEST_SEQ("appris_candidate_longest_seq"),
        APPRIS_CANDIDATE_LONGEST("appris_candidate_longest"),
        APPRIS_CANDIDATE("appris_candidate"),
        BASIC("basic"),
        BICISTRONIC("bicistronic"),
        CAGE_SUPPORTED_TSS("CAGE_supported_TSS"),
        CCDS("CCDS"),
        CDS_END_NF("cds_end_NF"),
        CDS_START_NF("cds_start_NF"),
        DOTTER_CONFIRMED("dotter_confirmed"),
        DOWNSTREAM_ATG("downstream_ATG"),
        EXP_CONF("exp_conf"),
        FRAGMENTED_LOCUS("fragmented_locus"),
        INFERRED_EXON_COMBINATION("inferred_exon_combination"),
        INFERRED_TRANSCRIPT_MODEL("inferred_transcript_model"),
        LOW_SEQUENCE_QUALITY("low_sequence_quality"),
        MRNA_END_NF("mRNA_end_NF"),
        MRNA_START_NF("mRNA_start_NF"),
        MANE_SELECT("MANE_Select"),
        NAGNAG_SPLICE_SITE("NAGNAG_splice_site"),
        NCRNA_HOST("ncRNA_host"),
        NESTED_454_RNA_SEQ_SUPPORTED("nested_454_RNA_Seq_supported"),
        NMD_EXCEPTION("NMD_exception"),
        NMD_LIKELY_IF_EXTENDED("NMD_likely_if_extended"),
        NON_ATG_START("non_ATG_start"),
        NON_CANONICAL_CONSERVED("non_canonical_conserved"),
        NON_CANONICAL_GENOME_SEQUENCE_ERROR("non_canonical_genome_sequence_error"),
        NON_CANONICAL_OTHER("non_canonical_other"),
        NON_CANONICAL_POLYMORPHISM("non_canonical_polymorphism"),
        NON_CANONICAL_TEC("non_canonical_TEC"),
        NON_CANONICAL_U12("non_canonical_U12"),
        NON_SUBMITTED_EVIDENCE("non_submitted_evidence"),
        NOT_BEST_IN_GENOME_EVIDENCE("not_best_in_genome_evidence"),
        NOT_ORGANISM_SUPPORTED("not_organism_supported"),
        ORPHAN("orphan"),
        OVERLAPPING_LOCUS("overlapping_locus"),
        OVERLAPPING_UORF("overlapping_uORF"),
        PAR("PAR"),
        PSEUDO_CONSENS("pseudo_consens"),
        READTHROUGH_TRANSCRIPT("readthrough_transcript"),
        REFERENCE_GENOME_ERROR("reference_genome_error"),
        RETAINED_INTRON_CDS("retained_intron_CDS"),
        RETAINED_INTRON_FINAL("retained_intron_final"),
        RETAINED_INTRON_FIRST("retained_intron_first"),
        RETROGENE("retrogene"),
        RNA_SEQ_SUPPORTED_ONLY("RNA_Seq_supported_only"),
        RNA_SEQ_SUPPORTED_PARTIAL("RNA_Seq_supported_partial"),
        RP_SUPPORTED_TIS("RP_supported_TIS"),
        SELENO("seleno"),
        SEMI_PROCESSED("semi_processed"),
        SEQUENCE_ERROR("sequence_error"),
        STOP_CODON_READTHROUGH("stop_codon_readthrough"),
        TAGENE("TAGENE"),
        UPSTREAM_ATG("upstream_ATG"),
        UPSTREAM_UORF("upstream_uORF");

        private static final Map<String, FeatureTag> VALUE_MAP;
        private final String serialized;

        private FeatureTag(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static FeatureTag getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        static {
            VALUE_MAP = Arrays.stream(FeatureTag.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum LocusLevel {
        VERIFIED("1"),
        MANUALLY_ANNOTATED("2"),
        AUTOMATICALLY_ANNOTATED("3");

        private static final Map<String, LocusLevel> VALUE_MAP;
        private final String serialized;

        private LocusLevel(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static LocusLevel getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        static {
            VALUE_MAP = Arrays.stream(LocusLevel.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum GeneTranscriptStatus {
        KNOWN,
        NOVEL,
        PUTATIVE;

    }

    public static enum GeneTranscriptType {
        IG_C_GENE("IG_C_gene"),
        IG_D_GENE("IG_D_gene"),
        IG_J_GENE("IG_J_gene"),
        IG_LV_GENE("IG_LV_gene"),
        IG_V_GENE("IG_V_gene"),
        TR_C_GENE("TR_C_gene"),
        TR_J_GENE("TR_J_gene"),
        TR_V_GENE("TR_V_gene"),
        TR_D_GENE("TR_D_gene"),
        IG_PSEUDOGENE("IG_pseudogene"),
        IG_C_PSEUDOGENE("IG_C_pseudogene"),
        IG_J_PSEUDOGENE("IG_J_pseudogene"),
        IG_V_PSEUDOGENE("IG_V_pseudogene"),
        TR_V_PSEUDOGENE("TR_V_pseudogene"),
        TR_J_PSEUDOGENE("TR_J_pseudogene"),
        MT_RRNA("Mt_rRNA"),
        MT_TRNA("Mt_tRNA"),
        MIRNA("miRNA"),
        MISC_RNA("misc_RNA"),
        RRNA("rRNA"),
        SCRNA("scRNA"),
        SNRNA("snRNA"),
        SNORNA("snoRNA"),
        RIBOZYME("ribozyme"),
        SRNA("sRNA"),
        SCARNA("scaRNA"),
        TRNA("tRNA"),
        TMRNA("tmRNA"),
        MT_TRNA_PSEUDOGENE("Mt_tRNA_pseudogene"),
        TRNA_PSEUDOGENE("tRNA_pseudogene"),
        SNORNA_PSEUDOGENE("snoRNA_pseudogene"),
        SNRNA_PSEUDOGENE("snRNA_pseudogene"),
        SCRNA_PSEUDOGENE("scRNA_pseudogene"),
        RRNA_PSEUDOGENE("rRNA_pseudogene"),
        MISC_RNA_PSEUDOGENE("misc_RNA_pseudogene"),
        MIRNA_PSEUDOGENE("miRNA_pseudogene"),
        TEC("TEC"),
        NONSENSE_MEDIATED_DECAY("nonsense_mediated_decay"),
        NON_STOP_DECAY("non_stop_decay"),
        RETAINED_INTRON("retained_intron"),
        PROTEIN_CODING("protein_coding"),
        PROCESSED_TRANSCRIPT("processed_transcript"),
        NON_CODING("non_coding"),
        AMBIGUOUS_ORF("ambiguous_orf"),
        SENSE_INTRONIC("sense_intronic"),
        SENSE_OVERLAPPING("sense_overlapping"),
        ANTISENSE("antisense"),
        ANTISENSE_RNA("antisense_RNA"),
        KNOWN_NCRNA("known_ncrna"),
        PSEUDOGENE("pseudogene"),
        PROCESSED_PSEUDOGENE("processed_pseudogene"),
        POLYMORPHIC_PSEUDOGENE("polymorphic_pseudogene"),
        RETROTRANSPOSED("retrotransposed"),
        TRANSCRIBED_PROCESSED_PSEUDOGENE("transcribed_processed_pseudogene"),
        TRANSCRIBED_UNPROCESSED_PSEUDOGENE("transcribed_unprocessed_pseudogene"),
        TRANSCRIBED_UNITARY_PSEUDOGENE("transcribed_unitary_pseudogene"),
        TRANSLATED_PROCESSED_PSEUDOGENE("translated_processed_pseudogene"),
        TRANSLATED_UNPROCESSED_PSEUDOGENE("translated_unprocessed_pseudogene"),
        UNITARY_PSEUDOGENE("unitary_pseudogene"),
        UNPROCESSED_PSEUDOGENE("unprocessed_pseudogene"),
        ARTIFACT("artifact"),
        LINCRNA("lincRNA"),
        LNCRNA("lncRNA"),
        MACRO_LNCRNA("macro_lncRNA"),
        THREE_PRIME_OVERLAPPING_NCRNA("3prime_overlapping_ncRNA"),
        DISRUPTED_DOMAIN("disrupted_domain"),
        VAULTRNA("vaultRNA"),
        BIDIRECTIONAL_PROMOTER_LNCRNA("bidirectional_promoter_lncRNA");

        private static final Map<String, GeneTranscriptType> VALUE_MAP;
        private final String serialized;
        private static final Map<String, String> SPECIAL_CASE_STRING_VALUE_MAP;

        private GeneTranscriptType(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static GeneTranscriptType getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS = SPECIAL_CASE_STRING_VALUE_MAP.getOrDefault(lowerS, lowerS))) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        private static Map<String, String> createSpecialCaseMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ncrna", "non_coding");
            return map;
        }

        static {
            VALUE_MAP = Arrays.stream(GeneTranscriptType.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
            SPECIAL_CASE_STRING_VALUE_MAP = GeneTranscriptType.createSpecialCaseMap();
        }
    }

    public static enum GenomicPhase {
        ZERO("0"),
        ONE("1"),
        TWO("2"),
        DOT(".");

        private static final Map<String, GenomicPhase> VALUE_MAP;
        private final String serialized;

        private GenomicPhase(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static GenomicPhase getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        static {
            VALUE_MAP = Arrays.stream(GenomicPhase.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum FeatureType {
        GENE("gene"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfGeneFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfGeneFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        TRANSCRIPT("transcript"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfTranscriptFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfTranscriptFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        SELENOCYSTEINE("Selenocysteine"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfSelenocysteineFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfSelenocysteineFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        EXON("exon"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfExonFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfExonFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        CDS("CDS"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfCDSFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfCDSFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        START_CODON("start_codon"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfStartCodonFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfStartCodonFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        STOP_CODON("stop_codon"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfStopCodonFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfStopCodonFeature.create(gtfFields, gtfFileType);
            }
        }
        ,
        UTR("UTR"){

            @Override
            public GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
                return GencodeGtfUTRFeature.create(baseData);
            }

            @Override
            public GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
                return GencodeGtfUTRFeature.create(gtfFields, gtfFileType);
            }
        };

        private static final Map<String, FeatureType> VALUE_MAP;
        private final String serialized;

        private FeatureType(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static FeatureType getEnum(String s) {
            String lowerS = s.toLowerCase();
            if (VALUE_MAP.containsKey(lowerS)) {
                return VALUE_MAP.get(lowerS);
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }

        public abstract GencodeGtfFeature create(GencodeGtfFeatureBaseData var1);

        public abstract GencodeGtfFeature create(String[] var1, String var2);

        static {
            VALUE_MAP = Arrays.stream(FeatureType.values()).collect(Collectors.toMap(v -> v.serialized.toLowerCase(), v -> v));
        }
    }

    public static enum AnnotationSource {
        ENSEMBL,
        HAVANA,
        ena;

    }

    public static class OptionalField<T> {
        private String name;
        private T value;

        public OptionalField(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(GencodeGtfFeature.EXTRA_FIELD_KEY_VALUE_SPLITTER);
            String valueString = this.value.toString();
            if (NUMBER_PATTERN.matcher(valueString).matches()) {
                sb.append(valueString);
                sb.append(GencodeGtfFeature.EXTRA_FIELD_DELIMITER);
            } else {
                sb.append("\"");
                sb.append(valueString);
                sb.append("\";");
            }
            return sb.toString();
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptionalField)) {
                return false;
            }
            OptionalField otherOptionalField = (OptionalField)other;
            return this.name.equals(otherOptionalField.name) && this.value.equals(otherOptionalField.value);
        }
    }
}

