/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import htsjdk.tribble.annotation.Strand;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;

public final class GencodeGtfFeatureBaseData {
    public int featureOrderNumber = -1;
    public String gtfSourceFileType;
    public SimpleInterval genomicPosition;
    public String annotationSource;
    public GencodeGtfFeature.FeatureType featureType;
    public Strand genomicStrand;
    public GencodeGtfFeature.GenomicPhase genomicPhase;
    public String geneId = null;
    public String transcriptId = null;
    public GencodeGtfFeature.GeneTranscriptStatus geneStatus = null;
    public GencodeGtfFeature.GeneTranscriptType geneType = null;
    public String geneName = null;
    public GencodeGtfFeature.GeneTranscriptType transcriptType = null;
    public GencodeGtfFeature.GeneTranscriptStatus transcriptStatus = null;
    public String transcriptName = null;
    public int exonNumber = -1;
    public String exonId = null;
    public GencodeGtfFeature.LocusLevel locusLevel = null;
    public List<GencodeGtfFeature.OptionalField<?>> optionalFields = new ArrayList();
    public String anonymousOptionalFields = null;

    public GencodeGtfFeatureBaseData() {
    }

    public GencodeGtfFeatureBaseData(String gtfSourceFileType, int featureOrderNumber, String chromosomeName, String annotationSource, GencodeGtfFeature.FeatureType featureType, int genomicStartLocation, int genomicEndLocation, Strand genomicStrand, GencodeGtfFeature.GenomicPhase genomicPhase, String geneId, String transcriptId, GencodeGtfFeature.GeneTranscriptType geneType, GencodeGtfFeature.GeneTranscriptStatus geneStatus, String geneName, GencodeGtfFeature.GeneTranscriptType transcriptType, GencodeGtfFeature.GeneTranscriptStatus transcriptStatus, String transcriptName, int exonNumber, String exonId, GencodeGtfFeature.LocusLevel locusLevel, List<GencodeGtfFeature.OptionalField<?>> optionalFields, String anonymousOptionalFields) {
        this.gtfSourceFileType = gtfSourceFileType;
        this.featureOrderNumber = featureOrderNumber;
        this.genomicPosition = new SimpleInterval(chromosomeName, genomicStartLocation, genomicEndLocation);
        this.annotationSource = annotationSource;
        this.featureType = featureType;
        this.genomicStrand = genomicStrand;
        this.genomicPhase = genomicPhase;
        this.geneId = geneId;
        this.transcriptId = transcriptId;
        this.geneType = geneType;
        this.geneStatus = geneStatus;
        this.geneName = geneName;
        this.transcriptType = transcriptType;
        this.transcriptStatus = transcriptStatus;
        this.transcriptName = transcriptName;
        this.exonNumber = exonNumber;
        this.exonId = exonId;
        this.locusLevel = locusLevel;
        if (optionalFields != null) {
            this.optionalFields = optionalFields;
        }
        this.anonymousOptionalFields = anonymousOptionalFields;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean isEqual = that instanceof GencodeGtfFeatureBaseData;
        if (isEqual) {
            GencodeGtfFeatureBaseData thatBaseData = (GencodeGtfFeatureBaseData)that;
            isEqual = Objects.equals(this.gtfSourceFileType, thatBaseData.gtfSourceFileType) && Objects.equals(this.featureOrderNumber, thatBaseData.featureOrderNumber) && Objects.equals(this.genomicPosition, thatBaseData.genomicPosition) && Objects.equals(this.annotationSource, thatBaseData.annotationSource) && Objects.equals((Object)this.featureType, (Object)thatBaseData.featureType) && Objects.equals(this.genomicStrand, thatBaseData.genomicStrand) && Objects.equals((Object)this.genomicPhase, (Object)thatBaseData.genomicPhase) && Objects.equals(this.geneId, thatBaseData.geneId) && Objects.equals(this.transcriptId, thatBaseData.transcriptId) && Objects.equals((Object)this.geneType, (Object)thatBaseData.geneType) && Objects.equals((Object)this.geneStatus, (Object)thatBaseData.geneStatus) && Objects.equals(this.geneName, thatBaseData.geneName) && Objects.equals((Object)this.transcriptType, (Object)thatBaseData.transcriptType) && Objects.equals((Object)this.transcriptStatus, (Object)thatBaseData.transcriptStatus) && Objects.equals(this.transcriptName, thatBaseData.transcriptName) && Objects.equals(this.exonNumber, thatBaseData.exonNumber) && Objects.equals(this.exonId, thatBaseData.exonId) && Objects.equals((Object)this.locusLevel, (Object)thatBaseData.locusLevel) && Objects.equals(this.anonymousOptionalFields, thatBaseData.anonymousOptionalFields) && Objects.equals(this.optionalFields, thatBaseData.optionalFields);
        }
        return isEqual;
    }

    public int hashCode() {
        int result = this.featureOrderNumber;
        result = 31 * result + (this.gtfSourceFileType != null ? this.gtfSourceFileType.hashCode() : 0);
        result = 31 * result + (this.genomicPosition != null ? this.genomicPosition.hashCode() : 0);
        result = 31 * result + (this.annotationSource != null ? this.annotationSource.hashCode() : 0);
        result = 31 * result + (this.featureType != null ? this.featureType.hashCode() : 0);
        result = 31 * result + (this.genomicStrand != null ? this.genomicStrand.hashCode() : 0);
        result = 31 * result + (this.genomicPhase != null ? this.genomicPhase.hashCode() : 0);
        result = 31 * result + (this.geneId != null ? this.geneId.hashCode() : 0);
        result = 31 * result + (this.transcriptId != null ? this.transcriptId.hashCode() : 0);
        result = 31 * result + (this.geneStatus != null ? this.geneStatus.hashCode() : 0);
        result = 31 * result + (this.geneType != null ? this.geneType.hashCode() : 0);
        result = 31 * result + (this.geneName != null ? this.geneName.hashCode() : 0);
        result = 31 * result + (this.transcriptType != null ? this.transcriptType.hashCode() : 0);
        result = 31 * result + (this.transcriptStatus != null ? this.transcriptStatus.hashCode() : 0);
        result = 31 * result + (this.transcriptName != null ? this.transcriptName.hashCode() : 0);
        result = 31 * result + this.exonNumber;
        result = 31 * result + (this.exonId != null ? this.exonId.hashCode() : 0);
        result = 31 * result + (this.locusLevel != null ? this.locusLevel.hashCode() : 0);
        result = 31 * result + (this.optionalFields != null ? this.optionalFields.hashCode() : 0);
        result = 31 * result + (this.anonymousOptionalFields != null ? this.anonymousOptionalFields.hashCode() : 0);
        return result;
    }
}

