/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeatureBaseData;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfTranscriptFeature;

public final class GencodeGtfGeneFeature
extends GencodeGtfFeature {
    private final List<GencodeGtfTranscriptFeature> transcripts = new ArrayList<GencodeGtfTranscriptFeature>();

    private GencodeGtfGeneFeature(String[] gtfFields, String gtfFileType) {
        super(gtfFields, gtfFileType);
    }

    public static GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
        return new GencodeGtfGeneFeature(gtfFields, gtfFileType);
    }

    private GencodeGtfGeneFeature(GencodeGtfFeatureBaseData baseData) {
        super(baseData);
    }

    public static GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
        return new GencodeGtfGeneFeature(baseData);
    }

    public void addTranscript(GencodeGtfTranscriptFeature transcript) {
        this.transcripts.add(transcript);
    }

    public List<GencodeGtfTranscriptFeature> getTranscripts() {
        return this.transcripts;
    }

    @Override
    protected List<GencodeGtfFeature> getAllFeatures() {
        ArrayList<GencodeGtfFeature> list = new ArrayList<GencodeGtfFeature>();
        list.add(this);
        for (GencodeGtfTranscriptFeature transcript : this.transcripts) {
            list.addAll(transcript.getAllFeatures());
        }
        return list;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof GencodeGtfGeneFeature)) {
            return false;
        }
        GencodeGtfGeneFeature otherGene = (GencodeGtfGeneFeature)other;
        if (!super.equals(otherGene)) {
            return false;
        }
        return Objects.equals(this.transcripts, otherGene.transcripts);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.transcripts != null ? this.transcripts.hashCode() : 0);
        return result;
    }
}

