/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.gtf;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfExonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeatureBaseData;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfSelenocysteineFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfUTRFeature;

public final class GencodeGtfTranscriptFeature
extends GencodeGtfFeature {
    private final List<GencodeGtfExonFeature> exons = new ArrayList<GencodeGtfExonFeature>();
    private final List<GencodeGtfSelenocysteineFeature> selenocysteines = new ArrayList<GencodeGtfSelenocysteineFeature>();
    private final List<GencodeGtfUTRFeature> utrs = new ArrayList<GencodeGtfUTRFeature>();

    private GencodeGtfTranscriptFeature(String[] gtfFields, String gtfFileType) {
        super(gtfFields, gtfFileType);
    }

    public static GencodeGtfFeature create(String[] gtfFields, String gtfFileType) {
        return new GencodeGtfTranscriptFeature(gtfFields, gtfFileType);
    }

    private GencodeGtfTranscriptFeature(GencodeGtfFeatureBaseData baseData) {
        super(baseData);
    }

    public static GencodeGtfFeature create(GencodeGtfFeatureBaseData baseData) {
        return new GencodeGtfTranscriptFeature(baseData);
    }

    public List<GencodeGtfExonFeature> getExons() {
        return this.exons;
    }

    public void addExon(GencodeGtfExonFeature exon) {
        this.exons.add(exon);
    }

    public List<GencodeGtfSelenocysteineFeature> getSelenocysteines() {
        return this.selenocysteines;
    }

    public void addSelenocysteine(GencodeGtfSelenocysteineFeature selenocysteine) {
        this.selenocysteines.add(selenocysteine);
    }

    public List<GencodeGtfUTRFeature> getUtrs() {
        return this.utrs;
    }

    public void addUtr(GencodeGtfUTRFeature utr) {
        this.utrs.add(utr);
    }

    @Override
    protected List<GencodeGtfFeature> getAllFeatures() {
        ArrayList<GencodeGtfFeature> list = new ArrayList<GencodeGtfFeature>();
        list.add(this);
        for (GencodeGtfExonFeature gencodeGtfExonFeature : this.exons) {
            list.addAll(gencodeGtfExonFeature.getAllFeatures());
        }
        for (GencodeGtfSelenocysteineFeature gencodeGtfSelenocysteineFeature : this.selenocysteines) {
            list.addAll(gencodeGtfSelenocysteineFeature.getAllFeatures());
        }
        for (GencodeGtfUTRFeature gencodeGtfUTRFeature : this.utrs) {
            list.addAll(gencodeGtfUTRFeature.getAllFeatures());
        }
        return list;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof GencodeGtfTranscriptFeature)) {
            return false;
        }
        GencodeGtfTranscriptFeature otherTranscript = (GencodeGtfTranscriptFeature)other;
        if (!super.equals(otherTranscript)) {
            return false;
        }
        return Objects.equals(this.exons, otherTranscript.exons) && Objects.equals(this.selenocysteines, otherTranscript.selenocysteines) && Objects.equals(this.utrs, otherTranscript.utrs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.exons != null ? this.exons.hashCode() : 0);
        result = 31 * result + (this.selenocysteines != null ? this.selenocysteines.hashCode() : 0);
        result = 31 * result + (this.utrs != null ? this.utrs.hashCode() : 0);
        return result;
    }
}

