/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.refseq;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineIterator;
import java.util.ArrayList;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.refseq.RefSeqFeature;

public class RefSeqCodec
extends AsciiFeatureCodec<RefSeqFeature> {
    protected static final String FILE_EXT = "refseq";
    public static final String COMMENT_LINE_CHARACTER = "#";
    public static final String LINE_DELIMITER = "\t";
    public static final int MINIMUM_LINE_FIELD_COUNT = 16;
    private boolean zero_coding_length_user_warned = false;
    public static final int TRANSCRIPT_ID_INDEX = 1;
    public static final int CONTIG_INDEX = 2;
    public static final int STRAND_INDEX = 3;
    public static final int INTERVAL_LEFT_BOUND_INDEX = 4;
    public static final int INTERVAL_RIGHT_BOUND_INDEX = 5;
    public static final int CODING_START_INDEX = 6;
    public static final int CODING_STOP_INDEX = 7;
    public static final int EXON_STARTS_INDEX = 9;
    public static final int EXON_STOPS_INDEX = 10;
    public static final int GENE_NAME_INDEX = 12;
    public static final int EXON_FRAMES_INDEX = 15;

    public RefSeqCodec() {
        super(RefSeqFeature.class);
    }

    public Feature decodeLoc(LineIterator lineIterator) {
        String line = (String)lineIterator.next();
        if (line.startsWith(COMMENT_LINE_CHARACTER)) {
            return null;
        }
        String[] fields = line.split(LINE_DELIMITER);
        if (fields.length < 16) {
            throw new TribbleException("RefSeq (decodeLoc) : Unable to parse line -> " + line + ", we expected at least 16 columns, we saw " + fields.length);
        }
        String contig_name = fields[2];
        try {
            return new RefSeqFeature(new SimpleInterval(contig_name, Integer.parseInt(fields[4]) + 1, Integer.parseInt(fields[5])));
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile("Could not parse location from line: " + line);
        }
    }

    public RefSeqFeature decode(String line) {
        if (line.startsWith(COMMENT_LINE_CHARACTER)) {
            return null;
        }
        String[] fields = line.split(LINE_DELIMITER);
        if (fields.length < 16) {
            throw new TribbleException("RefSeq (decode) : Unable to parse line -> " + line + ", we expected at least 16 columns, we saw " + fields.length);
        }
        String contig_name = fields[2];
        RefSeqFeature feature = new RefSeqFeature(new SimpleInterval(contig_name, Integer.parseInt(fields[4]) + 1, Integer.parseInt(fields[5])));
        feature.setTranscript_id(fields[1]);
        if (fields[3].length() == 1 && fields[3].charAt(0) == '+') {
            feature.setStrand(1);
        } else if (fields[3].length() == 1 && fields[3].charAt(0) == '-') {
            feature.setStrand(-1);
        } else {
            throw new UserException.MalformedFile("Expected strand symbol (+/-), found: " + fields[3] + " for line=" + line);
        }
        int coding_start = Integer.parseInt(fields[6]) + 1;
        int coding_stop = Integer.parseInt(fields[7]);
        if (coding_start > coding_stop) {
            if (!this.zero_coding_length_user_warned) {
                Utils.warnUser("RefSeq file contains transcripts with zero coding length. Such transcripts will be ignored (this warning is printed only once)");
                this.zero_coding_length_user_warned = true;
            }
            return null;
        }
        feature.setTranscript_interval(new SimpleInterval(contig_name, Integer.parseInt(fields[4]) + 1, Integer.parseInt(fields[5])));
        feature.setTranscript_coding_interval(new SimpleInterval(contig_name, coding_start, coding_stop));
        feature.setGene_name(fields[12]);
        String[] exon_starts = fields[9].split(",");
        String[] exon_stops = fields[10].split(",");
        String[] eframes = fields[15].split(",");
        if (exon_starts.length != exon_stops.length) {
            throw new UserException.MalformedFile("Data format error: numbers of exon start and stop positions differ for line=" + line);
        }
        if (exon_starts.length != eframes.length) {
            throw new UserException.MalformedFile("Data format error: numbers of exons and exon frameshifts differ for line=" + line);
        }
        ArrayList<SimpleInterval> exons = new ArrayList<SimpleInterval>(exon_starts.length);
        ArrayList<Integer> exon_frames = new ArrayList<Integer>(eframes.length);
        for (int i = 0; i < exon_starts.length; ++i) {
            exons.add(new SimpleInterval(contig_name, Integer.parseInt(exon_starts[i]) + 1, Integer.parseInt(exon_stops[i])));
            exon_frames.add(Integer.decode(eframes[i]));
        }
        feature.setExons(exons);
        feature.setExon_frames(exon_frames);
        return feature;
    }

    public boolean canDecode(String path) {
        return path.endsWith(".refseq");
    }

    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }
}

