/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.refseq;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.codecs.refseq.RefSeqTranscript;

public class RefSeqFeature
implements RefSeqTranscript,
Feature {
    private String transcript_id;
    private int strand;
    private SimpleInterval transcript_interval;
    private SimpleInterval transcript_coding_interval;
    private List<SimpleInterval> exons;
    private String gene_name;
    private List<Integer> exon_frames;
    private String name;

    public RefSeqFeature(SimpleInterval genomeLoc) {
        this.transcript_interval = genomeLoc;
    }

    @Override
    public String getTranscriptId() {
        return this.transcript_id;
    }

    @Override
    public int getStrand() {
        return this.strand;
    }

    @Override
    public SimpleInterval getLocation() {
        return this.transcript_interval;
    }

    @Override
    public SimpleInterval getCodingLocation() {
        return this.transcript_coding_interval;
    }

    @Override
    public String getGeneName() {
        return this.gene_name;
    }

    public int getNumExons() {
        return this.exons.size();
    }

    public SimpleInterval getExonLocation(int n) {
        if (n >= this.exons.size() || n < 0) {
            throw new GATKException("Index out-of-bounds. RefSeqTranscript has " + this.exons.size() + " exons; requested: " + n);
        }
        return this.exons.get(n);
    }

    @Override
    public List<SimpleInterval> getExons() {
        return Collections.unmodifiableList(this.exons);
    }

    public String getTranscriptUniqueGeneName() {
        return String.format("%s(%s)", this.getGeneName(), this.getTranscriptId());
    }

    public int getTotalExonLength() {
        if (this.exons.isEmpty()) {
            return this.getLengthOnReference();
        }
        return this.exons.stream().mapToInt(Locatable::getLengthOnReference).sum();
    }

    public boolean contains(Locatable that) {
        if (this.exons.isEmpty()) {
            return this.getLocation().contains(that);
        }
        for (SimpleInterval exon : this.exons) {
            if (!IntervalUtils.overlaps(exon, that)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("000\t");
        b.append(this.transcript_id);
        b.append('\t');
        b.append(this.getLocation().getContig());
        b.append('\t');
        b.append(this.strand == 1 ? (char)'+' : '-');
        b.append('\t');
        b.append(this.getLocation().getStart() - 1);
        b.append('\t');
        b.append(this.getLocation().getEnd());
        b.append('\t');
        b.append(this.transcript_coding_interval.getStart() - 1);
        b.append('\t');
        b.append(this.transcript_coding_interval.getEnd());
        b.append('\t');
        b.append(this.exons.size());
        b.append('\t');
        for (SimpleInterval loc : this.exons) {
            b.append(loc.getStart() - 1);
            b.append(',');
        }
        b.append('\t');
        for (SimpleInterval loc : this.exons) {
            b.append(loc.getEnd());
            b.append(',');
        }
        b.append("\t0\t");
        b.append(this.gene_name);
        b.append("\tcmpl\tcmpl\t");
        for (Integer f : this.exon_frames) {
            b.append(f);
            b.append(',');
        }
        return b.toString();
    }

    public void setTranscript_id(String transcript_id) {
        this.transcript_id = transcript_id;
    }

    public void setStrand(int strand) {
        this.strand = strand;
    }

    public void setTranscript_interval(SimpleInterval transcript_interval) {
        this.transcript_interval = transcript_interval;
    }

    public void setTranscript_coding_interval(SimpleInterval transcript_coding_interval) {
        this.transcript_coding_interval = transcript_coding_interval;
    }

    public void setExons(List<SimpleInterval> exons) {
        this.exons = exons;
    }

    public void setGene_name(String gene_name) {
        this.gene_name = gene_name;
    }

    public void setExon_frames(List<Integer> exon_frames) {
        this.exon_frames = exon_frames;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContig() {
        return this.transcript_interval.getContig();
    }

    public int getStart() {
        return this.transcript_interval.getStart();
    }

    public int getEnd() {
        return this.transcript_interval.getEnd();
    }
}

