/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.sampileup;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.SimpleFeature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.LineIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.codecs.sampileup.SAMPileupElement;
import org.broadinstitute.hellbender.utils.codecs.sampileup.SAMPileupFeature;

public class SAMPileupCodec
extends AsciiFeatureCodec<SAMPileupFeature> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\t|( +)");
    private static int MINIMUM_FIELDS = 4;
    private static final int MAXIMUM_FIELDS = 6;
    private static final Pattern INDEL_REGEXP = Pattern.compile("([0-9]+).*");
    public static final List<String> SAM_PILEUP_FILE_EXTENSIONS = Arrays.asList("pileup", "mpileup");

    public SAMPileupCodec() {
        super(SAMPileupFeature.class);
    }

    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    public boolean canDecode(String path) {
        String noBlockCompressedPath = IOUtil.hasBlockCompressedExtension((String)path) ? FilenameUtils.removeExtension((String)path).toLowerCase() : path.toLowerCase();
        return SAM_PILEUP_FILE_EXTENSIONS.stream().anyMatch(ext -> noBlockCompressedPath.endsWith("." + ext));
    }

    public SAMPileupFeature decode(String line) {
        String[] tokens = SPLIT_PATTERN.split(line.trim(), -1);
        if (tokens.length < MINIMUM_FIELDS || tokens.length > 6) {
            throw new CodecLineParsingException(String.format("The SAM pileup line didn't have the expected number of columns (%s-%s): %s. Note that this codes is only valid for single-sample pileups", MINIMUM_FIELDS, 6, line));
        }
        String chr = tokens[0];
        int pos = this.parseInteger(tokens[1], "position");
        byte ref = this.parseBase(tokens[2], "reference");
        int cov = this.parseInteger(tokens[3], "coverage");
        if (cov == 0) {
            return new SAMPileupFeature(chr, pos, ref, new ArrayList<SAMPileupElement>());
        }
        List<SAMPileupElement> pileupElements = this.parseBasesAndQuals(tokens[4], tokens[5], ref);
        if (cov != pileupElements.size()) {
            throw new CodecLineParsingException("THe SAM pileup line didn't have the same number of elements as the expected coverage: " + cov);
        }
        return new SAMPileupFeature(tokens[0], pos, ref, pileupElements);
    }

    @VisibleForTesting
    protected List<SAMPileupElement> parseBasesAndQuals(String bases, String qualities, byte ref) {
        try {
            int i;
            ArrayList<SAMPileupElement> pileupElements = new ArrayList<SAMPileupElement>(qualities.length());
            int j = 0;
            block9: for (i = 0; i < bases.length(); ++i) {
                char c = bases.charAt(i);
                switch (c) {
                    case '$': {
                        continue block9;
                    }
                    case '^': {
                        ++i;
                        continue block9;
                    }
                    case ',': 
                    case '.': {
                        pileupElements.add(new SAMPileupElement(ref, (byte)SAMUtils.fastqToPhred((char)qualities.charAt(j++))));
                        continue block9;
                    }
                    case '*': {
                        pileupElements.add(new SAMPileupElement(BaseUtils.Base.D.base, (byte)SAMUtils.fastqToPhred((char)qualities.charAt(j++))));
                        continue block9;
                    }
                    case '+': 
                    case '-': {
                        String rest = bases.substring(i + 1);
                        Matcher match = INDEL_REGEXP.matcher(rest);
                        if (!match.matches()) {
                            throw new CodecLineParsingException("The SAM pileup line has an indel marker (+/-) without length");
                        }
                        String lengthString = match.group(1);
                        int indelLength = this.parseInteger(lengthString, "indel-length");
                        i += indelLength + lengthString.length();
                        continue block9;
                    }
                    default: {
                        byte base = this.parseBase((byte)bases.charAt(i), "reads String");
                        pileupElements.add(new SAMPileupElement(base, (byte)SAMUtils.fastqToPhred((char)qualities.charAt(j++))));
                    }
                }
            }
            if (i != bases.length() || j != qualities.length()) {
                throw new CodecLineParsingException("Not all bases/qualities have been parsed because of a malformed line");
            }
            return pileupElements;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CodecLineParsingException("Malformed SAM pileup: Different number of bases and qualities found.");
        }
    }

    public Feature decodeLoc(LineIterator lineIterator) throws IOException {
        String[] tokens = SPLIT_PATTERN.split((CharSequence)lineIterator.next(), -1);
        int pos = this.parseInteger(tokens[1], "position");
        return new SimpleFeature(tokens[0], pos, pos);
    }

    private byte parseBase(byte base, String parsedValue) {
        if (BaseUtils.isNBase(base)) {
            return BaseUtils.Base.N.base;
        }
        int index = BaseUtils.simpleBaseToBaseIndex(base);
        if (index == -1) {
            throw new CodecLineParsingException("The SAM pileup line had wrong base at " + parsedValue + ": " + (char)base);
        }
        return BaseUtils.baseIndexToSimpleBase(index);
    }

    private int parseInteger(String token, String parsedValue) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new CodecLineParsingException("The SAM pileup line had unexpected " + parsedValue + ": " + token);
        }
    }

    private byte parseBase(String token, String parsedValue) {
        if (token.length() != 1) {
            throw new CodecLineParsingException("The SAM pileup line had unexpected base at " + parsedValue + ": " + token);
        }
        return this.parseBase((byte)token.charAt(0), parsedValue);
    }

    public TabixFormat getTabixFormat() {
        return new TabixFormat(0, 1, 2, 0, '#', 0);
    }
}

