/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.sampileup;

import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.StringUtil;
import htsjdk.tribble.Feature;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.sampileup.SAMPileupElement;

public class SAMPileupFeature
implements Feature {
    private final String contig;
    private final int position;
    private final byte refBase;
    private final List<SAMPileupElement> pileupElements;

    SAMPileupFeature(String contig, int position, byte refBase, List<SAMPileupElement> pileupElements) {
        Utils.nonNull(pileupElements);
        this.contig = contig;
        this.position = position;
        this.refBase = refBase;
        this.pileupElements = pileupElements;
    }

    @Deprecated
    public String getChr() {
        return this.getContig();
    }

    public String getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.position;
    }

    public int getEnd() {
        return this.position;
    }

    public String getQualsString() {
        return SAMUtils.phredToFastq((byte[])this.getBaseQuals());
    }

    public String getBasesString() {
        return StringUtil.bytesToString((byte[])this.getBases());
    }

    public byte getRef() {
        return this.refBase;
    }

    public int size() {
        return this.pileupElements.size();
    }

    public String getPileupString() {
        return String.format("%s %s %c %s %s", this.getContig(), this.getStart(), this.getRef(), this.getBasesString(), this.getQualsString());
    }

    public byte[] getBases() {
        List<Byte> bases = this.getBasesStream().collect(Collectors.toList());
        return ArrayUtils.toPrimitive((Byte[])bases.toArray(new Byte[bases.size()]));
    }

    public byte[] getBaseQuals() {
        List<Byte> quals = this.getQualsStream().collect(Collectors.toList());
        return ArrayUtils.toPrimitive((Byte[])quals.toArray(new Byte[quals.size()]));
    }

    public Stream<Byte> getBasesStream() {
        return this.pileupElements.stream().map(SAMPileupElement::getBase);
    }

    public Stream<Byte> getQualsStream() {
        return this.pileupElements.stream().map(SAMPileupElement::getBaseQuality);
    }
}

