/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.table;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.codecs.table.TableFeature;

public final class TableCodec
extends AsciiFeatureCodec<TableFeature> {
    protected static final String DEFAULT_HEADER_DELIMITER = "HEADER";
    protected static final String IGV_HEADER_DELIMITER = "track";
    protected static final String COMMENT_DELIMITER = "#";
    private final String headerDelimiter;
    protected String delimiter_regex = "\\s+";
    protected List<String> header = new ArrayList<String>();
    private boolean havePassedHeader = false;

    public TableCodec(String headerLineDelimiter) {
        super(TableFeature.class);
        if ("".equals(headerLineDelimiter)) {
            throw new GATKException("HeaderLineDelimiter must either be a valid delimiter or null");
        }
        this.headerDelimiter = headerLineDelimiter;
    }

    public TableCodec() {
        this(DEFAULT_HEADER_DELIMITER);
    }

    public TableFeature decode(String line) {
        if (this.headerDelimiter != null && line.startsWith(this.headerDelimiter) || this.headerDelimiter == null && !this.havePassedHeader || line.startsWith(COMMENT_DELIMITER) || line.startsWith(IGV_HEADER_DELIMITER)) {
            this.havePassedHeader = true;
            return null;
        }
        String[] split = line.split(this.delimiter_regex);
        if (split.length < 1) {
            throw new IllegalArgumentException("TableCodec line = " + line + " is not a valid table format");
        }
        return new TableFeature(new SimpleInterval(split[0]), Arrays.asList(split), this.header);
    }

    public List<String> readActualHeader(LineIterator reader) {
        boolean isFirst = true;
        while (reader.hasNext()) {
            String line = reader.peek();
            if (isFirst && !line.startsWith(COMMENT_DELIMITER) && this.headerDelimiter != null && !line.startsWith(this.headerDelimiter)) {
                throw new UserException.MalformedFile("TableCodec file does not have a header");
            }
            isFirst &= line.startsWith(COMMENT_DELIMITER);
            if (this.headerDelimiter == null || line.startsWith(this.headerDelimiter)) {
                reader.next();
                if (!this.header.isEmpty()) {
                    throw new UserException.MalformedFile("Input table file seems to have two header lines.  The second is = " + line);
                }
                String[] spl = line.split(this.delimiter_regex);
                Collections.addAll(this.header, spl);
                return this.header;
            }
            if (!line.startsWith(COMMENT_DELIMITER)) break;
            reader.next();
        }
        return this.header;
    }

    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".table");
    }
}

