/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.table;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;

public final class TableFeature
implements Feature {
    private final List<String> values;
    private final List<String> keys;
    private final Locatable position;

    public TableFeature(Locatable position, List<String> values, List<String> keys) {
        this.values = values;
        this.keys = keys;
        this.position = position;
    }

    public String getContig() {
        return this.position.getContig();
    }

    public int getStart() {
        return this.position.getStart();
    }

    public int getEnd() {
        return this.position.getEnd();
    }

    public int columnCount() {
        return this.values.size();
    }

    public String getValue(int columnPosition) {
        Utils.validateArg(columnPosition >= 0, () -> "Requested a negative column: " + columnPosition);
        Utils.validateArg(columnPosition < this.columnCount(), () -> "We only have " + this.columnCount() + " columns, the requested column = " + columnPosition);
        return this.values.get(columnPosition);
    }

    public String toString() {
        return String.format("%s\t%s", this.position.toString(), Utils.join("\t", this.values));
    }

    public String get(String columnName) {
        int position = this.keys.indexOf(columnName);
        Utils.validateArg(position >= 0, () -> "We don't have a column named " + columnName);
        return this.values.get(position);
    }

    public Locatable getLocation() {
        return this.position;
    }

    public List<String> getAllValues() {
        return this.getValuesTo(this.columnCount());
    }

    public List<String> getValuesTo(int columnPosition) {
        Utils.validateArg(columnPosition >= 0, () -> "Requested a negative column: " + columnPosition);
        Utils.validateArg(columnPosition <= this.columnCount(), () -> "We only have " + this.columnCount() + " columns, the requested column = " + columnPosition);
        return this.values.subList(0, columnPosition);
    }

    public List<String> getHeader() {
        return this.keys;
    }
}

