/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.StringUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable.XsvTableFeature;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class XsvLocatableTableCodec
extends AsciiFeatureCodec<XsvTableFeature> {
    private static final Logger logger = LogManager.getLogger(XsvLocatableTableCodec.class);
    private static final String COMMENT_DELIMITER = "#";
    public static final String SAM_FILE_HEADER_LINE_START = "@";
    public static final String SAM_FILE_HEADER_START = "@HD\tVN:";
    @VisibleForTesting
    public static final String CONFIG_FILE_EXTENSION = ".config";
    private String inputContigColumn;
    private String inputStartColumn;
    private String inputEndColumn;
    private String finalContigColumn;
    private String finalStartColumn;
    private String finalEndColumn;
    private String delimiter;
    private String dataSourceName;
    private Path backingDataFilePath;
    private List<String> header;
    private Map<String, Integer> headerToIndex;
    private List<String> locatableColumns;
    private long currentLine = 0L;
    private Path overrideConfigFile = null;
    private List<String> preamble = new ArrayList<String>();
    private String preambleLineStart;
    private boolean isHeaderInitialized = false;
    private boolean hasFirstRecordBeenRead = false;

    public XsvLocatableTableCodec() {
        super(XsvTableFeature.class);
    }

    public XsvLocatableTableCodec(Path overrideConfigFile) {
        super(XsvTableFeature.class);
        this.overrideConfigFile = overrideConfigFile;
    }

    public boolean canDecode(String path) {
        Utils.nonNull(path);
        return path.endsWith(CONFIG_FILE_EXTENSION) && this.canDecodeFileChecks(path);
    }

    public String getPathToDataFile(String path) {
        return this.backingDataFilePath.toUri().toString();
    }

    public boolean canDecodeFileChecks(String configFilePathString) {
        Path configFilePath;
        Utils.nonNull(configFilePathString);
        Path path = configFilePath = this.overrideConfigFile != null ? this.overrideConfigFile : IOUtils.getPath(configFilePathString);
        if (!this.validateInputFileCanBeRead(configFilePath)) {
            return false;
        }
        Pair<Boolean, Properties> validityAndPropertiesPair = XsvLocatableTableCodec.getAndValidateConfigFileContentsOnPath(configFilePath, true);
        boolean isValid = (Boolean)validityAndPropertiesPair.getLeft();
        Properties configProperties = (Properties)validityAndPropertiesPair.getRight();
        if (!isValid) {
            return false;
        }
        String inputFilePathString = configProperties.getProperty("src_file");
        Path dataFilePath = DataSourceUtils.resolveFilePathStringFromKnownPath(inputFilePathString, configFilePath);
        if (this.validateInputFileCanBeRead(dataFilePath)) {
            this.backingDataFilePath = dataFilePath;
            this.preambleLineStart = this.determinePreambleLineStart(this.backingDataFilePath);
            this.populateMetaDataFromConfigProperties(configProperties);
            return true;
        }
        return false;
    }

    public boolean canDecodeFileChecks(String configFilePathString, String dataFilePathString) {
        Utils.nonNull(configFilePathString);
        Utils.nonNull(dataFilePathString);
        Path configFilePath = this.overrideConfigFile != null ? this.overrideConfigFile : IOUtils.getPath(configFilePathString);
        Path dataFilePath = IOUtils.getPath(dataFilePathString);
        if (!this.validateInputFileCanBeRead(configFilePath)) {
            return false;
        }
        Pair<Boolean, Properties> validityAndPropertiesPair = XsvLocatableTableCodec.getAndValidateConfigFileContentsOnPath(configFilePath, false);
        boolean isValid = (Boolean)validityAndPropertiesPair.getLeft();
        Properties configProperties = (Properties)validityAndPropertiesPair.getRight();
        if (!isValid) {
            return false;
        }
        if (!this.validateInputFileCanBeRead(dataFilePath)) {
            return false;
        }
        this.backingDataFilePath = dataFilePath;
        this.preambleLineStart = this.determinePreambleLineStart(this.backingDataFilePath);
        this.populateMetaDataFromConfigProperties(configProperties);
        return true;
    }

    public XsvTableFeature decode(String s) {
        ++this.currentLine;
        if (s.startsWith(this.preambleLineStart)) {
            return null;
        }
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(s.split(this.delimiter)));
        if (split.size() < 1) {
            throw new UserException.BadInput("XSV file has a line with no delimiter at line number: " + this.currentLine);
        }
        if (split.size() < this.header.size()) {
            while (split.size() < this.header.size()) {
                split.add("");
            }
        } else if (split.size() > this.header.size()) {
            logger.warn("WARNING: Line " + this.currentLine + " does not have the same number of fields as header (" + split.size() + " > " + this.header.size() + ")!  Truncating fields from end...");
            while (split.size() > this.header.size()) {
                split.remove(split.size() - 1);
            }
        } else if (!this.hasFirstRecordBeenRead && IntStream.range(0, split.size()).allMatch(i -> this.header.get(i).equals(split.get(i)))) {
            return null;
        }
        this.hasFirstRecordBeenRead = true;
        return new XsvTableFeature(this.headerToIndex.get(this.finalContigColumn), this.headerToIndex.get(this.finalStartColumn), this.headerToIndex.get(this.finalEndColumn), this.header, split, this.dataSourceName);
    }

    public List<String> readActualHeader(LineIterator reader) {
        Utils.nonNull(reader);
        while (reader.hasNext()) {
            String line = (String)reader.next();
            ++this.currentLine;
            if (!this.isPreambleLine(line)) {
                this.header = Arrays.stream(line.split(this.delimiter)).map(x -> this.determinePrefixForHeader() + x).collect(Collectors.toCollection(ArrayList::new));
                this.headerToIndex = IntStream.range(0, this.header.size()).boxed().collect(Collectors.toMap(i -> this.header.get((int)i), Function.identity()));
                this.isHeaderInitialized = true;
                this.finalContigColumn = this.determineFinalColumn(this.inputContigColumn);
                this.finalStartColumn = this.determineFinalColumn(this.inputStartColumn);
                this.finalEndColumn = this.determineFinalColumn(this.inputEndColumn);
                this.validateFinalColumns();
                this.locatableColumns = Arrays.asList(this.finalContigColumn, this.finalStartColumn, this.finalEndColumn);
                this.assertLocatableColumnsInHeaderToIndex(this.locatableColumns, this.headerToIndex);
                return this.header;
            }
            this.preamble.add(line.substring(this.preambleLineStart.length()));
        }
        throw new UserException.BadInput("Given file is malformed - does not contain a header!");
    }

    private void validateFinalColumns() {
        if (this.finalContigColumn.equals(this.finalStartColumn) || this.finalContigColumn.equals(this.finalEndColumn)) {
            throw new UserException.BadInput("Contig column: " + this.finalContigColumn + " is the same as start or end column.  Start: " + this.finalStartColumn + "  End: " + this.finalEndColumn);
        }
    }

    @VisibleForTesting
    String determineFinalColumn(String rawInputListOrIndex) {
        return StringUtils.isNumeric((CharSequence)rawInputListOrIndex) ? this.header.get(Integer.valueOf(rawInputListOrIndex)) : this.determinePrefixForHeader() + this.determineColumnNameToUse(rawInputListOrIndex);
    }

    public static Pair<Boolean, Properties> getAndValidateConfigFileContentsOnPath(Path configFilePath, boolean errorOnMissingConfigKey) {
        Utils.nonNull(configFilePath);
        boolean isValid = true;
        Properties configProperties = new Properties();
        try (InputStream inputStream = Files.newInputStream(configFilePath, StandardOpenOption.READ);){
            configProperties.load(inputStream);
        }
        catch (Exception ex) {
            throw new UserException.BadInput("Unable to read from XSV config file: " + configFilePath.toUri().toString(), ex);
        }
        isValid = Stream.of("src_file", "version", "origin_location", "preprocessing_script", "contig_column", "start_column", "end_column", "xsv_delimiter", "name").map(key -> XsvLocatableTableCodec.configPropertiesContainsKey(configProperties, key, configFilePath, errorOnMissingConfigKey)).allMatch(result -> result);
        return Pair.of((Object)isValid, (Object)configProperties);
    }

    private List<String> getRawHeaders() {
        this.assertHeaderInitialized();
        return this.header.stream().map(h -> this.getHeaderWithoutPrefix((String)h)).collect(Collectors.toList());
    }

    private String determineColumnNameToUse(String rawInputListAsString) {
        List<String> rawHeaders = this.getRawHeaders();
        String[] rawInputList = StringUtils.split((String)rawInputListAsString, (String)",");
        Optional<String> candidateName = Stream.of(rawInputList).filter(c -> rawHeaders.contains(c)).findFirst();
        if (!candidateName.isPresent()) {
            throw new UserException.BadInput("Input did not contain any headers from the list: " + rawInputListAsString);
        }
        return candidateName.get();
    }

    private String getHeaderWithoutPrefix(String headerField) {
        if (StringUtils.isEmpty((CharSequence)this.determinePrefixForHeader())) {
            return headerField;
        }
        return StringUtils.replace((String)headerField, (String)this.determinePrefixForHeader(), (String)"", (int)1);
    }

    private void assertLocatableColumnsInHeaderToIndex(List<String> locatableColumns, Map<String, Integer> headerToIndex) {
        List missingColumns = locatableColumns.stream().filter(c -> headerToIndex.get(c) == null).map(c -> this.getHeaderWithoutPrefix((String)c)).collect(Collectors.toList());
        if (missingColumns.size() > 0) {
            String missingColumnsString = StringUtil.join((String)", ", missingColumns);
            throw new UserException.BadInput("Error in input file: cannot find the locatable column(s): " + missingColumnsString + ", though these were specified in the parsing configuration.  Do those columns need to be added to the input file?  Do you have a heterogenous preamble (e.g. lines that start with both '#' and '@') before the headers?  Does each line of your preamble start with the correct string ('" + this.preambleLineStart + "')?");
        }
    }

    private void assertHeaderInitialized() {
        if (!this.isHeaderInitialized) {
            throw new GATKException.ShouldNeverReachHereException("Method that needs an initialized header was called before header was initialized.");
        }
    }

    private String determinePrefixForHeader() {
        return StringUtils.isEmpty((CharSequence)this.dataSourceName) ? "" : this.dataSourceName + "_";
    }

    private boolean isPreambleLine(String line) {
        return line.startsWith(this.preambleLineStart);
    }

    public static Path getConfigFilePath(Path inputFilePath) {
        String configFilePath = IOUtils.replaceExtension(inputFilePath.toString(), CONFIG_FILE_EXTENSION);
        return Paths.get(configFilePath, new String[0]);
    }

    private static boolean configPropertiesContainsKey(Properties configProperties, String key, Path configFilePath, boolean errorOnMissingKey) {
        if (!configProperties.stringPropertyNames().contains(key)) {
            String logMessage = "Config file for datasource (" + configFilePath.toUri().toString() + ") does not contain required key: " + key;
            if (errorOnMissingKey) {
                logger.error(logMessage);
            } else {
                logger.warn(logMessage);
            }
            return false;
        }
        return true;
    }

    private boolean validateInputFileCanBeRead(Path filePath) {
        return Files.exists(filePath, new LinkOption[0]) && Files.isReadable(filePath) && !Files.isDirectory(filePath, new LinkOption[0]);
    }

    private void populateMetaDataFromConfigProperties(Properties configProperties) {
        this.inputContigColumn = configProperties.getProperty("contig_column").replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        this.inputStartColumn = configProperties.getProperty("start_column").replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        this.inputEndColumn = configProperties.getProperty("end_column").replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        this.dataSourceName = configProperties.getProperty("name").replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        this.delimiter = configProperties.getProperty("xsv_delimiter");
        if (this.delimiter.equals("\\t")) {
            this.delimiter = "\t";
        }
    }

    private ImmutableList<String> getPreamble() {
        this.assertHeaderInitialized();
        return ImmutableList.copyOf(this.preamble);
    }

    public List<String> getHeaderWithoutLocationColumns() {
        this.assertHeaderInitialized();
        return this.header.stream().filter(h -> !this.locatableColumns.contains(h)).collect(Collectors.toList());
    }

    public static void validateLocatableColumnName(String columnName) {
        Utils.validateArg(!StringUtils.isEmpty((CharSequence)columnName), "column header is blank.");
        Utils.validateArg(!NumberUtils.isCreatable((String)columnName), "column header cannot be a number: " + columnName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String determinePreambleLineStart(Path path) {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            byte[] buff = new byte[SAM_FILE_HEADER_START.length()];
            stream.read(buff, 0, SAM_FILE_HEADER_START.length());
            boolean eq = Arrays.equals(buff, SAM_FILE_HEADER_START.getBytes());
            if (eq) {
                String string = SAM_FILE_HEADER_LINE_START;
                return string;
            }
            String string = COMMENT_DELIMITER;
            return string;
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile("Could not read file: " + path.toString(), (Exception)e);
        }
    }

    public SAMFileHeader renderSamFileHeader() {
        this.assertHeaderInitialized();
        ImmutableList<String> preamble = this.getPreamble();
        if (this.isPreambleSamFileHeader((List<String>)preamble)) {
            List<String> samHeaderAsString = preamble.stream().map(p -> this.preambleLineStart + p).collect(Collectors.toList());
            return XsvLocatableTableCodec.createSamFileHeader(samHeaderAsString);
        }
        return XsvLocatableTableCodec.createSamFileHeaderWithCommentsOnly(preamble);
    }

    private boolean isPreambleSamFileHeader(List<String> preamble) {
        if (preamble == null || preamble.size() == 0) {
            return false;
        }
        String testPreambleFirstLine = this.preambleLineStart + preamble.get(0);
        return testPreambleFirstLine.startsWith(SAM_FILE_HEADER_START);
    }

    @VisibleForTesting
    static SAMFileHeader createSamFileHeader(List<String> samFileHeaderAsStrings) {
        BufferedLineReader reader = BufferedLineReader.fromString((String)StringUtils.join(samFileHeaderAsStrings, (String)"\n"));
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        return codec.decode((LineReader)reader, null);
    }

    @VisibleForTesting
    static SAMFileHeader createSamFileHeaderWithCommentsOnly(List<String> comments) {
        BufferedLineReader reader = BufferedLineReader.fromString((String)"");
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        SAMFileHeader result = codec.decode((LineReader)reader, null);
        ArrayList<String> finalComments = new ArrayList<String>();
        finalComments.addAll(result.getComments());
        finalComments.addAll(comments);
        result.setComments(finalComments);
        return result;
    }

    public String getContigColumn() {
        this.assertHeaderInitialized();
        return this.finalContigColumn;
    }

    public String getStartColumn() {
        this.assertHeaderInitialized();
        return this.finalStartColumn;
    }

    public String getEndColumn() {
        this.assertHeaderInitialized();
        return this.finalEndColumn;
    }
}

