/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable;

import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class XsvTableFeature
implements Feature {
    private final int contigColumn;
    private final int startColumn;
    private final int endColumn;
    private final List<Integer> locationColumnRemoveIndiciesInOrder;
    private final String dataSourceName;
    private final String contig;
    private final int start;
    private final int end;
    private final List<String> columnNames;
    private final List<String> columnValues;

    public XsvTableFeature(int contigColumn, int startColumn, int endColumn, List<String> columnNames, List<String> columnValues, String dataSourceName) {
        this.contigColumn = contigColumn;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.dataSourceName = dataSourceName;
        this.contig = columnValues.get(contigColumn);
        try {
            this.start = Integer.valueOf(columnValues.get(startColumn));
            this.end = Integer.valueOf(columnValues.get(endColumn));
        }
        catch (NumberFormatException ex) {
            throw new UserException.MalformedFile("Could not convert value (" + ex.getMessage() + ") from input file into a number for Data Source: " + dataSourceName);
        }
        if (columnNames.size() != columnValues.size()) {
            throw new UserException.BadInput("Number of columns in given header and data do not match: " + columnNames.size() + " != " + columnValues.size());
        }
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.locationColumnRemoveIndiciesInOrder = startColumn == endColumn ? new ArrayList<Integer>(Arrays.asList(contigColumn, startColumn)) : new ArrayList<Integer>(Arrays.asList(contigColumn, startColumn, endColumn));
        this.locationColumnRemoveIndiciesInOrder.sort(Collections.reverseOrder());
    }

    public String getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XsvTableFeature that = (XsvTableFeature)o;
        if (this.contigColumn != that.contigColumn) {
            return false;
        }
        if (this.startColumn != that.startColumn) {
            return false;
        }
        if (this.endColumn != that.endColumn) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (this.locationColumnRemoveIndiciesInOrder != null ? !this.locationColumnRemoveIndiciesInOrder.equals(that.locationColumnRemoveIndiciesInOrder) : that.locationColumnRemoveIndiciesInOrder != null) {
            return false;
        }
        if (this.dataSourceName != null ? !this.dataSourceName.equals(that.dataSourceName) : that.dataSourceName != null) {
            return false;
        }
        if (this.contig != null ? !this.contig.equals(that.contig) : that.contig != null) {
            return false;
        }
        if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) {
            return false;
        }
        return this.columnValues != null ? this.columnValues.equals(that.columnValues) : that.columnValues == null;
    }

    public int hashCode() {
        int result = this.contigColumn;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endColumn;
        result = 31 * result + (this.locationColumnRemoveIndiciesInOrder != null ? this.locationColumnRemoveIndiciesInOrder.hashCode() : 0);
        result = 31 * result + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
        result = 31 * result + (this.contig != null ? this.contig.hashCode() : 0);
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
        result = 31 * result + (this.columnValues != null ? this.columnValues.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "XsvTableFeature{contigColumn=" + this.contigColumn + ", startColumn=" + this.startColumn + ", endColumn=" + this.endColumn + ", locationColumnRemoveIndiciesInOrder=" + this.locationColumnRemoveIndiciesInOrder + ", dataSourceName='" + this.dataSourceName + '\'' + ", contig='" + this.contig + '\'' + ", start=" + this.start + ", end=" + this.end + ", columnNames=" + this.columnNames + ", columnValues=" + this.columnValues + '}';
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String get(String key) {
        int position = this.columnNames.indexOf(key);
        if (position < 0) {
            return null;
        }
        return this.columnValues.get(position);
    }

    public String get(int index) {
        ParamUtils.inRange(index, 0, this.columnNames.size() - 1, "Index out of range: " + index);
        return this.columnValues.get(index);
    }

    public List<String> getHeader() {
        return this.columnNames;
    }

    public List<String> getHeaderWithoutLocationColumns() {
        ArrayList<String> outList = new ArrayList<String>(this.columnNames);
        for (int indx : this.locationColumnRemoveIndiciesInOrder) {
            outList.remove(indx);
        }
        return outList;
    }

    public List<String> getValues() {
        return this.columnValues;
    }

    public List<String> getValuesWithoutLocationColumns() {
        ArrayList<String> outList = new ArrayList<String>(this.columnValues);
        for (int indx : this.locationColumnRemoveIndiciesInOrder) {
            outList.remove(indx);
        }
        return outList;
    }

    public int size() {
        return this.columnValues.size();
    }
}

