/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.collections;

import java.util.Collection;

public class AutoCloseableCollection<C extends Collection<? extends AutoCloseable>>
implements AutoCloseable {
    protected C autoCloseables;

    public AutoCloseableCollection(C autoCloseables) {
        this.autoCloseables = autoCloseables;
    }

    public int size() {
        return this.autoCloseables.size();
    }

    @Override
    public void close() {
        Throwable exception = null;
        for (AutoCloseable closeable : this.autoCloseables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new RuntimeException("Problem closing AutoCloseable object(s)");
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

