/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.collections;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.broadinstitute.hellbender.utils.Utils;

public final class IndexedSet<E>
extends AbstractSet<E> {
    private final List<E> elements;
    private List<E> unmodifiableElementsListView;
    private final Map<E, Integer> indexByElement;

    public IndexedSet(int initialCapacity) {
        this.elements = new ArrayList(initialCapacity);
        this.indexByElement = new LinkedHashMap<E, Integer>(initialCapacity);
    }

    public IndexedSet(Collection<E> values) {
        Utils.nonNull(values, "input values cannot be null");
        Utils.containsNoNull(values, "values can't contain nulls");
        int initialCapacity = values.size();
        this.elements = new ArrayList(initialCapacity);
        this.indexByElement = new LinkedHashMap<E, Integer>(initialCapacity);
        int nextIndex = 0;
        for (E value : values) {
            if (this.indexByElement.containsKey(value)) continue;
            this.indexByElement.put(value, nextIndex++);
            this.elements.add(value);
        }
    }

    @SafeVarargs
    public IndexedSet(E ... values) {
        Utils.nonNull(values, "input values cannot be null");
        int initialCapacity = values.length;
        this.elements = new ArrayList(initialCapacity);
        this.indexByElement = new LinkedHashMap<E, Integer>(initialCapacity);
        int nextIndex = 0;
        for (E value : values) {
            Utils.nonNull(value, "null element not allowed: index == " + nextIndex);
            if (this.indexByElement.containsKey(value)) continue;
            this.indexByElement.put(value, nextIndex++);
            this.elements.add(value);
        }
    }

    public List<E> asList() {
        if (this.unmodifiableElementsListView == null) {
            this.unmodifiableElementsListView = Collections.unmodifiableList(this.elements);
        }
        return this.unmodifiableElementsListView;
    }

    @Override
    public Iterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(Object o) {
        return o != null && this.indexByElement.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        Utils.nonNull(o, "the input argument cannot be null");
        if (this.contains(o)) {
            return false;
        }
        int nextIndex = this.size();
        this.elements.add(o);
        this.indexByElement.put(o, nextIndex);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.elements.remove(index);
        this.indexByElement.remove(o);
        ListIterator<E> it = this.elements.listIterator(index);
        int nextIndex = index;
        while (it.hasNext()) {
            this.indexByElement.put(it.next(), nextIndex++);
        }
        return true;
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.indexByElement.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexedSet)) {
            return false;
        }
        IndexedSet other = (IndexedSet)o;
        return this.equals(other);
    }

    public boolean equals(IndexedSet<?> other) {
        Utils.nonNull(other, "other cannot be null");
        List<E> otherElements = other.elements;
        int elementCount = this.elements.size();
        if (otherElements.size() != elementCount) {
            return false;
        }
        for (int i = 0; i < elementCount; ++i) {
            if (this.elements.get(i).equals(otherElements.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (E element : this.elements) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public E get(int index) {
        Utils.validIndex(index, this.size());
        return this.elements.get(index);
    }

    public int indexOf(Object o) {
        Utils.nonNull(o, "the query object cannot be null");
        return this.indexByElement.getOrDefault(o, -1);
    }
}

