/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;

public final class NestedIntegerArray<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(NestedIntegerArray.class);
    protected final Object[] data;
    protected final int numDimensions;
    protected final int[] dimensions;
    private static final int NUM_DIMENSIONS_TO_PREALLOCATE = 2;

    public NestedIntegerArray(int ... dimensions) {
        this.numDimensions = dimensions.length;
        Utils.validateArg(this.numDimensions > 0, "There must be at least one dimension to an NestedIntegerArray");
        this.dimensions = Arrays.copyOf(dimensions, dimensions.length);
        int dimensionsToPreallocate = Math.min(dimensions.length, 2);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Creating NestedIntegerArray with dimensions %s", Arrays.toString(dimensions)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Pre-allocating first %d dimensions", dimensionsToPreallocate));
        }
        this.data = new Object[dimensions[0]];
        this.preallocateArray(this.data, 0, dimensionsToPreallocate);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Done pre-allocating first %d dimensions", dimensionsToPreallocate));
        }
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    private void preallocateArray(Object[] subarray, int dimension, int dimensionsToPreallocate) {
        if (dimension >= dimensionsToPreallocate - 1) {
            return;
        }
        for (int i = 0; i < subarray.length; ++i) {
            subarray[i] = new Object[this.dimensions[dimension + 1]];
            this.preallocateArray((Object[])subarray[i], dimension + 1, dimensionsToPreallocate);
        }
    }

    public T get(int ... keys) {
        int numNestedDimensions = this.numDimensions - 1;
        Object[] myData = this.data;
        for (int i = 0; i < numNestedDimensions; ++i) {
            if (keys[i] >= this.dimensions[i]) {
                return null;
            }
            if ((myData = (Object[])myData[keys[i]]) != null) continue;
            return null;
        }
        return (T)((Serializable)myData[keys[numNestedDimensions]]);
    }

    private T leaf(int key, Object[] array) {
        return (T)(array == null ? null : (Serializable)array[key]);
    }

    private Object[] nextDimension(int key, Object[] array) {
        return array == null ? null : (Object[])array[key];
    }

    public T get1Key(int key0) {
        return this.leaf(key0, this.data);
    }

    public T get2Keys(int key0, int key1) {
        if (key0 >= this.dimensions[0] || key1 >= this.dimensions[1]) {
            return null;
        }
        return this.leaf(key1, this.nextDimension(key0, this.data));
    }

    public T get3Keys(int key0, int key1, int key2) {
        if (key0 >= this.dimensions[0] || key1 >= this.dimensions[1] || key2 >= this.dimensions[2]) {
            return null;
        }
        return this.leaf(key2, this.nextDimension(key1, this.nextDimension(key0, this.data)));
    }

    public T get4Keys(int key0, int key1, int key2, int key3) {
        if (key0 >= this.dimensions[0] || key1 >= this.dimensions[1] || key2 >= this.dimensions[2] || key3 >= this.dimensions[3]) {
            return null;
        }
        return this.leaf(key3, this.nextDimension(key2, this.nextDimension(key1, this.nextDimension(key0, this.data))));
    }

    public void put(T value, int ... keys) {
        Utils.validateArg(keys.length == this.numDimensions, () -> "Exactly " + this.numDimensions + " keys should be passed to this NestedIntegerArray but " + keys.length + " were provided");
        int numNestedDimensions = this.numDimensions - 1;
        Object[] myData = this.data;
        for (int i = 0; i < numNestedDimensions; ++i) {
            if (keys[i] >= this.dimensions[i]) {
                throw new IllegalArgumentException("Key " + keys[i] + " is too large for dimension " + i + " (max is " + (this.dimensions[i] - 1) + ")");
            }
            if (i >= 1 && myData[keys[i]] == null) {
                myData[keys[i]] = new Object[this.dimensions[i + 1]];
            }
            myData = (Object[])myData[keys[i]];
        }
        myData[keys[numNestedDimensions]] = value;
    }

    public List<T> getAllValues() {
        ArrayList result = new ArrayList();
        this.fillAllValues(this.data, result);
        return result;
    }

    private void fillAllValues(Object[] array, List<T> result) {
        for (Object value : array) {
            if (value == null) continue;
            if (value instanceof Object[]) {
                this.fillAllValues((Object[])value, result);
                continue;
            }
            result.add((Serializable)value);
        }
    }

    public List<Leaf<T>> getAllLeaves() {
        ArrayList<Leaf<T>> result = new ArrayList<Leaf<T>>();
        this.fillAllLeaves(this.data, new int[0], result);
        return result;
    }

    private void fillAllLeaves(Object[] array, int[] path, List<Leaf<T>> result) {
        for (int key = 0; key < array.length; ++key) {
            Object value = array[key];
            if (value == null) continue;
            int[] newPath = this.appendToPath(path, key);
            if (value instanceof Object[]) {
                this.fillAllLeaves((Object[])value, newPath, result);
                continue;
            }
            result.add(new Leaf<Serializable>(newPath, (Serializable)value));
        }
    }

    private int[] appendToPath(int[] path, int newKey) {
        int[] newPath = new int[path.length + 1];
        for (int i = 0; i < path.length; ++i) {
            newPath[i] = path[i];
        }
        newPath[path.length] = newKey;
        return newPath;
    }

    public static class Leaf<T> {
        public final int[] keys;
        public final T value;

        public Leaf(int[] keys, T value) {
            this.keys = keys;
            this.value = value;
        }
    }
}

