/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.config;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Log;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigCache;
import org.aeonbits.owner.Factory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.ClassUtils;
import org.broadinstitute.hellbender.utils.LoggingUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.GATKConfig;
import org.broadinstitute.hellbender.utils.config.SystemProperty;

public final class ConfigFactory {
    private static final Logger logger = LogManager.getLogger(ConfigFactory.class);
    private static final ConfigFactory instance = new ConfigFactory();
    private static final Pattern sourcesAnnotationPathVariablePattern = Pattern.compile("\\$\\{(.*)}");
    @VisibleForTesting
    static final String NO_PATH_VARIABLE_VALUE = "/dev/null";
    private final Set<Class<? extends Config>> alreadyResolvedPathVariables = new HashSet<Class<? extends Config>>();

    public static ConfigFactory getInstance() {
        return instance;
    }

    private ConfigFactory() {
    }

    @VisibleForTesting
    void checkFileNamePropertyExistenceAndSetConfigFactoryProperties(List<String> filenameProperties) {
        Properties systemProperties = System.getProperties();
        Map<String, String> environmentProperties = System.getenv();
        for (String property : filenameProperties) {
            if (environmentProperties.containsKey(property)) {
                logger.debug("Config path variable found in Environment Properties: " + property + "=" + environmentProperties.get(property) + " - will search for config here.");
                continue;
            }
            if (systemProperties.containsKey(property)) {
                logger.debug("Config path variable found in System Properties: " + property + "=" + systemProperties.get(property) + " - will search for config here.");
                continue;
            }
            if (org.aeonbits.owner.ConfigFactory.getProperties().containsKey(property)) {
                logger.debug("Config path variable found in Config Factory Properties(probably from the command-line): " + property + "=" + org.aeonbits.owner.ConfigFactory.getProperty((String)property) + " - will search for config here.");
                continue;
            }
            logger.debug("Config path variable not found: " + property + " - setting value to default empty variable: " + (NO_PATH_VARIABLE_VALUE == null ? "null" : String.valueOf(NO_PATH_VARIABLE_VALUE)));
            org.aeonbits.owner.ConfigFactory.setProperty((String)property, (String)NO_PATH_VARIABLE_VALUE);
        }
    }

    @VisibleForTesting
    List<String> getConfigPathVariableNamesFromConfigClasses(List<Class<?>> configurationClasses) {
        ArrayList<String> configPathVariableNames = new ArrayList<String>();
        Iterator<Class<?>> iterator = ClassUtils.getClassesOfType(Config.class, configurationClasses).iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            Class<?> castedClass = clazz = iterator.next();
            configPathVariableNames.addAll(this.getSourcesAnnotationPathVariables(castedClass));
        }
        return configPathVariableNames;
    }

    @VisibleForTesting
    <T extends Config> List<String> getSourcesAnnotationPathVariables(Class<? extends T> configClass) {
        ArrayList<String> configPathVariableNames = new ArrayList<String>();
        Config.Sources annotation = configClass.getAnnotation(Config.Sources.class);
        if (annotation != null) {
            for (String val : annotation.value()) {
                Matcher m = sourcesAnnotationPathVariablePattern.matcher(val);
                if (!m.find()) continue;
                configPathVariableNames.add(m.group(1));
            }
        }
        return configPathVariableNames;
    }

    @VisibleForTesting
    void injectToSystemProperties(Map<String, String> properties) {
        Properties systemProperties = System.getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (systemProperties.containsKey(entry.getKey())) {
                logger.debug("System property already exists.  Not overriding: " + entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), entry.getValue());
            String propertyValueThatWasSet = System.getProperty(entry.getKey());
            if (propertyValueThatWasSet == null) {
                throw new GATKException("Unable to set System Property (" + entry.getKey() + "=" + entry.getValue() + ")!");
            }
            if (propertyValueThatWasSet.equals(entry.getValue())) continue;
            throw new GATKException("System Property corrupted (" + entry.getKey() + "!=" + entry.getValue() + " -> " + propertyValueThatWasSet + ")!");
        }
    }

    public GATKConfig getGATKConfig() {
        return this.getOrCreate(GATKConfig.class, new Map[0]);
    }

    public static <T extends Config> void dumpConfigSettings(T config, Path outFilePath) {
        LinkedHashMap<String, Object> configMap = ConfigFactory.getConfigMap(config, false);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)ConfigFactory.convertConfigMapToStringStringMap(configMap));
        Date d = new Date();
        try (OutputStream outputStream = Files.newOutputStream(outFilePath, StandardOpenOption.CREATE_NEW);){
            properties.store(outputStream, "Created from " + config.getClass().getSimpleName() + " at " + new SimpleDateFormat("HH.mm.ss").format(d) + " on " + new SimpleDateFormat("yyyy.MM.dd").format(d));
        }
        catch (Exception ex) {
            throw new GATKException("Could not write config (" + config.getClass().getTypeName() + ") to file: " + outFilePath, ex);
        }
    }

    public <T extends Config> T create(Class<? extends T> clazz, Map<?, ?> ... imports) {
        Utils.nonNull(clazz);
        this.resolvePathVariables(clazz);
        return (T)org.aeonbits.owner.ConfigFactory.create(clazz, (Map[])imports);
    }

    public <T extends Config> T getOrCreate(Class<? extends T> clazz, Map<?, ?> ... imports) {
        Utils.nonNull(clazz);
        this.resolvePathVariables(clazz);
        return (T)ConfigCache.getOrCreate(clazz, (Map[])imports);
    }

    public <T extends Config> T getOrCreate(Factory factory, Class<? extends T> clazz, Map<?, ?> ... imports) {
        Utils.nonNull(factory);
        Utils.nonNull(clazz);
        this.resolvePathVariables(clazz);
        return (T)ConfigCache.getOrCreate((Factory)factory, clazz, (Map[])imports);
    }

    public <T extends Config> T getOrCreate(Object key, Class<? extends T> clazz, Map<?, ?> ... imports) {
        Utils.nonNull(key);
        Utils.nonNull(clazz);
        this.resolvePathVariables(clazz);
        return (T)ConfigCache.getOrCreate((Object)key, clazz, (Map[])imports);
    }

    public <T extends Config> T getOrCreate(Factory factory, Object key, Class<? extends T> clazz, Map<?, ?> ... imports) {
        Utils.nonNull(factory);
        Utils.nonNull(key);
        Utils.nonNull(clazz);
        this.resolvePathVariables(clazz);
        return (T)ConfigCache.getOrCreate((Object)key, clazz, (Map[])imports);
    }

    private synchronized <T extends Config> void resolvePathVariables(Class<? extends T> clazz) {
        if (!this.alreadyResolvedPathVariables.contains(clazz)) {
            this.checkFileNamePropertyExistenceAndSetConfigFactoryProperties(this.getSourcesAnnotationPathVariables(clazz));
            this.alreadyResolvedPathVariables.add(clazz);
        }
    }

    public <T extends Config> T get(Object key) {
        Utils.nonNull(key);
        return (T)ConfigCache.get((Object)key);
    }

    public static String getConfigFilenameFromArgs(String[] args, String configFileOption) {
        Utils.nonNull(args);
        Utils.nonNull(configFileOption);
        String configFileName = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(configFileOption)) continue;
            if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                configFileName = args[i + 1];
                break;
            }
            throw new UserException.BadInput("ERROR: Configuration file not given after config file option specified: " + configFileOption);
        }
        return configFileName;
    }

    public synchronized void initializeConfigurationsFromCommandLineArgs(String[] argList, String configFileOption) {
        this.initializeConfigurationsFromCommandLineArgs(argList, configFileOption, GATKConfig.class);
    }

    public synchronized <T extends Config> void initializeConfigurationsFromCommandLineArgs(String[] argList, String configFileOption, Class<? extends T> configClass) {
        Utils.nonNull(argList);
        Utils.nonNull(configFileOption);
        Utils.nonNull(configClass);
        String configFileName = ConfigFactory.getConfigFilenameFromArgs(argList, configFileOption);
        T configuration = this.getOrCreateConfigFromFile(configFileName, configClass);
        this.injectSystemPropertiesFromConfig(configuration);
    }

    @VisibleForTesting
    synchronized <T extends Config> T getOrCreateConfigFromFile(String configFileName, Class<? extends T> configClass) {
        if (configFileName != null) {
            org.aeonbits.owner.ConfigFactory.setProperty((String)"GATKConfig.pathToGatkConfig", (String)configFileName);
        }
        return ConfigFactory.getInstance().getOrCreate(configClass, new Map[0]);
    }

    @VisibleForTesting
    synchronized <T extends Config> T createConfigFromFile(String configFileName, Class<? extends T> configClass) {
        if (configFileName != null) {
            org.aeonbits.owner.ConfigFactory.setProperty((String)"GATKConfig.pathToGatkConfig", (String)configFileName);
        }
        return ConfigFactory.getInstance().create(configClass, new Map[0]);
    }

    public synchronized <T extends Config> void injectSystemPropertiesFromConfig(T config) {
        Utils.nonNull(config);
        LinkedHashMap<String, String> properties = ConfigFactory.getSystemPropertiesFromConfig(config);
        this.injectToSystemProperties(properties);
    }

    public static <T extends Config> void logConfigFields(T config) {
        ConfigFactory.logConfigFields(config, Log.LogLevel.DEBUG);
    }

    @VisibleForTesting
    static <T extends Config> LinkedHashMap<String, String> getSystemPropertiesFromConfig(T config) {
        Utils.nonNull(config);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : ConfigFactory.getConfigMap(config, true).entrySet()) {
            properties.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return properties;
    }

    public static <T extends Config> void logConfigFields(T config, Log.LogLevel logLevel) {
        Utils.nonNull(config);
        Utils.nonNull(logLevel);
        Level level = LoggingUtils.levelToLog4jLevel(logLevel);
        if (!logger.isEnabled(level)) {
            return;
        }
        logger.log(level, "Configuration file values: ");
        for (Map.Entry<String, Object> entry : ConfigFactory.getConfigMap(config, false).entrySet()) {
            logger.log(level, "\t" + entry.getKey() + " = " + entry.getValue());
        }
    }

    @VisibleForTesting
    static <T extends Config> LinkedHashMap<String, Object> getConfigMap(T config, boolean onlySystemProperties) {
        LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
        for (Class<?> classInterface : ClassUtils.getClassesOfType(Config.class, Arrays.asList(config.getClass().getInterfaces()))) {
            for (Method propertyMethod : classInterface.getDeclaredMethods()) {
                String propertyName = propertyMethod.getName();
                Config.Key key = propertyMethod.getAnnotation(Config.Key.class);
                if (key != null) {
                    propertyName = key.value();
                }
                try {
                    if (onlySystemProperties) {
                        if (!propertyMethod.isAnnotationPresent(SystemProperty.class)) continue;
                        configMap.put(propertyName, propertyMethod.invoke(config, new Object[0]));
                        continue;
                    }
                    configMap.put(propertyName, propertyMethod.invoke(config, new Object[0]));
                }
                catch (IllegalAccessException ex) {
                    throw new GATKException("Could not access the config getter: " + config.getClass().getSimpleName() + "." + propertyMethod.getName(), ex);
                }
                catch (InvocationTargetException ex) {
                    throw new GATKException("Could not invoke the config getter: " + config.getClass().getSimpleName() + "." + propertyMethod.getName(), ex);
                }
            }
        }
        return configMap;
    }

    private static LinkedHashMap<String, String> convertConfigMapToStringStringMap(LinkedHashMap<String, Object> configMap) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toString());
        }
        return map;
    }
}

