/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.config;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Mutable;
import org.broadinstitute.hellbender.utils.config.CustomBooleanConverter;
import org.broadinstitute.hellbender.utils.config.SystemProperty;

@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.Sources(value={"file:${GATKConfig.pathToGatkConfig}", "classpath:${GATKConfig.classPathToGatkConfig}", "file:GATKConfig.properties", "classpath:org/broadinstitute/hellbender/utils/config/GATKConfig.properties"})
public interface GATKConfig
extends Mutable,
Accessible {
    public static final String CONFIG_FILE_VARIABLE_FILE_NAME = "GATKConfig.pathToGatkConfig";
    public static final String CONFIG_FILE_VARIABLE_CLASS_PATH = "GATKConfig.classPathToGatkConfig";
    @VisibleForTesting
    public static final String DEFAULT_ANNOTATION_PACKAGES = "org.broadinstitute.hellbender.tools.walkers.annotator";

    @SystemProperty
    @Config.Key(value="gatk_stacktrace_on_user_exception")
    @Config.DefaultValue(value="false")
    public boolean gatk_stacktrace_on_user_exception();

    @SystemProperty
    @Config.Key(value="samjdk.use_async_io_read_samtools")
    @Config.ConverterClass(value=CustomBooleanConverter.class)
    @Config.DefaultValue(value="false")
    public Boolean samjdk_use_async_io_read_samtools();

    @SystemProperty
    @Config.Key(value="samjdk.use_async_io_write_samtools")
    @Config.DefaultValue(value="true")
    public boolean samjdk_use_async_io_write_samtools();

    @SystemProperty
    @Config.Key(value="samjdk.use_async_io_write_tribble")
    @Config.DefaultValue(value="false")
    public boolean samjdk_use_async_io_write_tribble();

    @SystemProperty
    @Config.Key(value="samjdk.compression_level")
    @Config.DefaultValue(value="2")
    public int samjdk_compression_level();

    @SystemProperty
    @Config.Key(value="spark.kryoserializer.buffer.max")
    @Config.DefaultValue(value="512m")
    public String spark_kryoserializer_buffer_max();

    @SystemProperty
    @Config.Key(value="spark.driver.maxResultSize")
    @Config.DefaultValue(value="0")
    public int spark_driver_maxResultSize();

    @SystemProperty
    @Config.Key(value="spark.driver.userClassPathFirst")
    @Config.DefaultValue(value="true")
    public boolean spark_driver_userClassPathFirst();

    @SystemProperty
    @Config.Key(value="spark.io.compression.codec")
    @Config.DefaultValue(value="lzf")
    public String spark_io_compression_codec();

    @SystemProperty
    @Config.Key(value="spark.executor.memoryOverhead")
    @Config.DefaultValue(value="600")
    public int spark_executor_memoryOverhead();

    @SystemProperty
    @Config.Key(value="spark.driver.extraJavaOptions")
    @Config.DefaultValue(value="")
    public String spark_driver_extraJavaOptions();

    @SystemProperty
    @Config.Key(value="spark.executor.extraJavaOptions")
    @Config.DefaultValue(value="")
    public String spark_executor_extraJavaOptions();

    @Config.DefaultValue(value="htsjdk.variant,htsjdk.tribble,org.broadinstitute.hellbender.utils.codecs")
    public List<String> codec_packages();

    @Config.DefaultValue(value="org.broadinstitute.hellbender.engine.filters")
    public List<String> read_filter_packages();

    @Config.DefaultValue(value="org.broadinstitute.hellbender.tools.walkers.annotator")
    public List<String> annotation_packages();

    @Config.DefaultValue(value="40")
    public int cloudPrefetchBuffer();

    @Config.DefaultValue(value="-1")
    public int cloudIndexPrefetchBuffer();

    @Config.DefaultValue(value="20")
    public int gcsMaxRetries();

    @Config.DefaultValue(value="")
    public String gcsProjectForRequesterPays();

    @Config.DefaultValue(value="true")
    public boolean createOutputBamIndex();
}

