/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import htsjdk.variant.variantcontext.Allele;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.map.DefaultedMap;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.text.XReadLines;

public final class AlleleBiasedDownsamplingUtils {
    private AlleleBiasedDownsamplingUtils() {
    }

    @VisibleForTesting
    static int[] targetAlleleCounts(int[] alleleCounts, int numReadsToRemove) {
        int numAlleles = alleleCounts.length;
        int maxScore = AlleleBiasedDownsamplingUtils.scoreAlleleCounts(alleleCounts);
        int[] alleleCountsOfMax = alleleCounts;
        int numReadsToRemovePerAllele = numReadsToRemove / 2;
        for (int i = 0; i < numAlleles; ++i) {
            for (int j = i; j < numAlleles; ++j) {
                int[] newCounts = (int[])alleleCounts.clone();
                if (i == j) {
                    newCounts[i] = Math.max(0, newCounts[i] - numReadsToRemove);
                } else {
                    newCounts[i] = Math.max(0, newCounts[i] - numReadsToRemovePerAllele);
                    newCounts[j] = Math.max(0, newCounts[j] - numReadsToRemovePerAllele);
                }
                int score = AlleleBiasedDownsamplingUtils.scoreAlleleCounts(newCounts);
                if (score >= maxScore) continue;
                maxScore = score;
                alleleCountsOfMax = newCounts;
            }
        }
        return alleleCountsOfMax;
    }

    private static int scoreAlleleCounts(int[] alleleCounts) {
        if (alleleCounts.length < 2) {
            return 0;
        }
        int[] alleleCountsCopy = (int[])alleleCounts.clone();
        Arrays.sort(alleleCountsCopy);
        int maxCount = alleleCountsCopy[alleleCounts.length - 1];
        int nextBestCount = alleleCountsCopy[alleleCounts.length - 2];
        int remainderCount = (int)MathUtils.sum(alleleCountsCopy) - maxCount - nextBestCount;
        return Math.min(maxCount - nextBestCount + remainderCount, Math.abs(nextBestCount + remainderCount));
    }

    public static <EVIDENCE, A extends Allele> List<EVIDENCE> selectAlleleBiasedEvidence(Map<A, List<EVIDENCE>> alleleEvidenceMap, double contaminationFraction) {
        int totalEvidence = Utils.nonNull(alleleEvidenceMap).values().stream().mapToInt(list -> list.size()).sum();
        int numEvidenceToRemove = (int)((double)totalEvidence * contaminationFraction);
        ArrayList alleles = new ArrayList(alleleEvidenceMap.keySet());
        alleles.remove(Allele.NO_CALL);
        int[] alleleCounts = alleles.stream().mapToInt(allele -> ((List)alleleEvidenceMap.get(allele)).size()).toArray();
        int[] targetAlleleCounts = AlleleBiasedDownsamplingUtils.targetAlleleCounts(alleleCounts, numEvidenceToRemove);
        return IntStream.range(0, alleles.size()).filter(i -> alleleCounts[i] > targetAlleleCounts[i]).mapToObj(i -> i).flatMap(i -> AlleleBiasedDownsamplingUtils.downsampleElements((List)alleleEvidenceMap.get(alleles.get((int)i)), alleleCounts[i] - targetAlleleCounts[i]).stream()).collect(Collectors.toList());
    }

    private static <EVIDENCE> List<EVIDENCE> downsampleElements(List<EVIDENCE> evidence, int numElementsToRemove) {
        if (numElementsToRemove == 0) {
            return Collections.emptyList();
        }
        if (numElementsToRemove >= evidence.size()) {
            return Collections.unmodifiableList(evidence);
        }
        return Collections.unmodifiableList(Arrays.stream(MathUtils.sampleIndicesWithoutReplacement(evidence.size(), numElementsToRemove)).mapToObj(evidence::get).collect(Collectors.toList()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultedMap<String, Double> loadContaminationFile(File file, double defaultContaminationFraction, Set<String> sampleIDs, Logger logger) {
        DefaultedMap sampleContamination = new DefaultedMap((Object)defaultContaminationFraction);
        LinkedHashSet<String> nonSamplesInContaminationFile = new LinkedHashSet<String>(sampleContamination.keySet());
        try (XReadLines reader = new XReadLines(Utils.nonNull(file).toPath(), true);){
            for (String line : reader) {
                double contamination;
                if (line.isEmpty()) continue;
                String[] fields = line.split("\t");
                if (fields.length != 2) {
                    throw new UserException.MalformedFile("Contamination file must have exactly two, tab-delimited columns. Offending line:\n" + line);
                }
                if (fields[0].isEmpty()) throw new UserException.MalformedFile("Contamination file can not have empty strings in either column. Offending line:\n" + line);
                if (fields[1].isEmpty()) {
                    throw new UserException.MalformedFile("Contamination file can not have empty strings in either column. Offending line:\n" + line);
                }
                try {
                    contamination = Double.parseDouble(fields[1]);
                }
                catch (NumberFormatException e) {
                    throw new UserException.MalformedFile("Contamination file contains unparsable double in the second field. Offending line: " + line);
                }
                String sampleName = fields[0];
                if (sampleContamination.containsKey((Object)sampleName)) {
                    throw new UserException.MalformedFile("Contamination file contains duplicate entries for input name " + sampleName);
                }
                if (contamination < 0.0) throw new UserException.MalformedFile("Contamination file contains unacceptable contamination value (must be 0<=x<=1): " + line);
                if (contamination > 1.0) {
                    throw new UserException.MalformedFile("Contamination file contains unacceptable contamination value (must be 0<=x<=1): " + line);
                }
                if (sampleIDs == null || sampleIDs.contains(sampleName)) {
                    sampleContamination.put((Object)sampleName, (Object)contamination);
                    continue;
                }
                nonSamplesInContaminationFile.add(sampleName);
            }
            if (!sampleContamination.isEmpty()) {
                Sets.SetView samplesNotInContaminationFile;
                logger.info(String.format("The following samples were found in the Contamination file and will be processed at the contamination level therein: %s", sampleContamination.keySet().toString()));
                if (sampleIDs != null && !(samplesNotInContaminationFile = Sets.difference(sampleIDs, (Set)sampleContamination.keySet())).isEmpty()) {
                    logger.info(String.format("The following samples were NOT found in the Contamination file and will be processed at the default contamination level: %s", samplesNotInContaminationFile.toString()));
                }
            }
            if (!nonSamplesInContaminationFile.isEmpty()) {
                logger.info(String.format("The following entries were found in the Contamination file but were not SAMPLEIDs. They will be ignored: %s", ((Object)nonSamplesInContaminationFile).toString()));
            }
            DefaultedMap defaultedMap = sampleContamination;
            return defaultedMap;
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile("I/O Error while reading sample-contamination file " + file.getAbsolutePath() + ": " + e.getMessage());
        }
    }
}

