/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.util.Collection;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.PushPullTransformer;

public abstract class Downsampler<T>
implements PushPullTransformer<T> {
    private int numDiscardedItems = 0;

    @Override
    public abstract void submit(T var1);

    @Override
    public void submit(Collection<T> items) {
        Utils.nonNull(items, "submitted items must not be null");
        for (T item : items) {
            this.submit(item);
        }
    }

    @Override
    public abstract boolean hasFinalizedItems();

    @Override
    public abstract List<T> consumeFinalizedItems();

    public abstract boolean hasPendingItems();

    public abstract T peekFinalized();

    public abstract T peekPending();

    public abstract int size();

    public int getNumberOfDiscardedItems() {
        return this.numDiscardedItems;
    }

    protected void incrementNumberOfDiscardedItems(int newlyDiscardedItems) {
        this.numDiscardedItems += newlyDiscardedItems;
    }

    @Override
    public abstract void signalEndOfInput();

    public abstract void clearItems();

    public void resetStats() {
        this.numDiscardedItems = 0;
    }
}

