/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.io.Serializable;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.downsampling.DownsampleType;

public final class DownsamplingMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final DownsampleType type;
    public final Integer toCoverage;
    public final Double toFraction;
    public static final DownsamplingMethod NONE = new DownsamplingMethod(DownsampleType.NONE, null, null);
    public static final DownsampleType DEFAULT_DOWNSAMPLING_TYPE = DownsampleType.BY_SAMPLE;

    public DownsamplingMethod(DownsampleType type, Integer toCoverage, Double toFraction) {
        DownsampleType downsampleType = this.type = type != null ? type : DEFAULT_DOWNSAMPLING_TYPE;
        if (type == DownsampleType.NONE) {
            this.toCoverage = null;
            this.toFraction = null;
        } else {
            this.toCoverage = toCoverage;
            this.toFraction = toFraction;
        }
        this.validate();
    }

    private void validate() {
        if (this.type != DownsampleType.NONE && this.toFraction == null && this.toCoverage == null) {
            throw new UserException("Must specify either toFraction or toCoverage when downsampling.");
        }
        if (this.toFraction != null && this.toCoverage != null) {
            throw new UserException("Downsampling coverage and fraction are both specified. Please choose only one.");
        }
        if (this.toCoverage != null && this.toCoverage <= 0) {
            throw new UserException("toCoverage must be > 0 when downsampling to coverage");
        }
        if (this.toFraction != null && (this.toFraction < 0.0 || this.toFraction > 1.0)) {
            throw new UserException("toFraction must be >= 0.0 and <= 1.0 when downsampling to a fraction of reads");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Downsampling Settings: ");
        if (this.type == DownsampleType.NONE) {
            builder.append("No downsampling");
        } else {
            builder.append(String.format("Method: %s, ", new Object[]{this.type}));
            if (this.toCoverage != null) {
                builder.append(String.format("Target Coverage: %d", this.toCoverage));
            } else {
                builder.append(String.format("Target Fraction: %.2f", this.toFraction));
            }
        }
        return builder.toString();
    }
}

