/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class FractionalDownsampler
extends ReadsDownsampler {
    private List<GATKRead> selectedReads;
    private final int cutoffForInclusion;
    private static final int RANDOM_POOL_SIZE = 10000;

    public FractionalDownsampler(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new IllegalArgumentException("Fraction of reads to include must be between 0.0 and 1.0, inclusive");
        }
        this.cutoffForInclusion = (int)(fraction * 10000.0);
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(GATKRead newRead) {
        Utils.nonNull(newRead, "newRead");
        if (Utils.getRandomGenerator().nextInt(10000) < this.cutoffForInclusion) {
            this.selectedReads.add(newRead);
        } else {
            this.incrementNumberOfDiscardedItems(1);
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.selectedReads.isEmpty();
    }

    @Override
    public List<GATKRead> consumeFinalizedItems() {
        List<GATKRead> downsampledItems = this.selectedReads;
        this.clearItems();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public GATKRead peekFinalized() {
        return this.selectedReads.isEmpty() ? null : this.selectedReads.get(0);
    }

    @Override
    public GATKRead peekPending() {
        return null;
    }

    @Override
    public int size() {
        return this.selectedReads.size();
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clearItems() {
        this.selectedReads = new ArrayList<GATKRead>();
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(GATKRead read) {
        Utils.nonNull(read);
    }
}

