/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.Downsampler;

public final class LevelingDownsampler<T extends List<E>, E>
extends Downsampler<T> {
    private final int minElementsPerStack;
    private final long targetSize;
    private List<T> groups;
    private boolean groupsAreFinalized;

    public LevelingDownsampler(long targetSize) {
        this(targetSize, 1);
    }

    public LevelingDownsampler(long targetSize, int minElementsPerStack) {
        Utils.validateArg(targetSize >= 0L, "targetSize must be >= 0 but got " + targetSize);
        Utils.validateArg(minElementsPerStack >= 0, "minElementsPerStack must be >= 0 but got " + minElementsPerStack);
        this.targetSize = targetSize;
        this.minElementsPerStack = minElementsPerStack;
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(T item) {
        Utils.nonNull(item, "item");
        this.groups.add(item);
    }

    @Override
    public void submit(Collection<T> items) {
        Utils.nonNull(items, "items");
        Utils.validateArg(!items.contains(null), "null item");
        this.groups.addAll(items);
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.groupsAreFinalized && !this.groups.isEmpty();
    }

    @Override
    public List<T> consumeFinalizedItems() {
        if (!this.hasFinalizedItems()) {
            return new ArrayList();
        }
        List<T> toReturn = this.groups;
        this.clearItems();
        return toReturn;
    }

    @Override
    public boolean hasPendingItems() {
        return !this.groupsAreFinalized && !this.groups.isEmpty();
    }

    @Override
    public T peekFinalized() {
        return (T)(this.hasFinalizedItems() ? (List)this.groups.get(0) : null);
    }

    @Override
    public T peekPending() {
        return (T)(this.hasPendingItems() ? (List)this.groups.get(0) : null);
    }

    @Override
    public int size() {
        return this.groups.stream().mapToInt(g -> g.size()).sum();
    }

    @Override
    public void signalEndOfInput() {
        this.levelGroups();
        this.groupsAreFinalized = true;
    }

    @Override
    public void clearItems() {
        this.groups = new ArrayList<T>();
        this.groupsAreFinalized = false;
    }

    private void levelGroups() {
        int[] groupSizes = new int[this.groups.size()];
        int totalSize = 0;
        int currentGroupIndex = 0;
        for (List group : this.groups) {
            groupSizes[currentGroupIndex] = group.size();
            totalSize += groupSizes[currentGroupIndex];
            ++currentGroupIndex;
        }
        if ((long)totalSize <= this.targetSize) {
            return;
        }
        long numItemsToRemove = (long)totalSize - this.targetSize;
        currentGroupIndex = 0;
        int numConsecutiveUmodifiableGroups = 0;
        while (numItemsToRemove > 0L && numConsecutiveUmodifiableGroups < groupSizes.length) {
            if (groupSizes[currentGroupIndex] > this.minElementsPerStack) {
                int n = currentGroupIndex;
                groupSizes[n] = groupSizes[n] - 1;
                --numItemsToRemove;
                numConsecutiveUmodifiableGroups = 0;
            } else {
                ++numConsecutiveUmodifiableGroups;
            }
            currentGroupIndex = (currentGroupIndex + 1) % groupSizes.length;
        }
        currentGroupIndex = 0;
        for (List group : this.groups) {
            this.downsampleOneGroup(group, groupSizes[currentGroupIndex]);
            ++currentGroupIndex;
        }
    }

    private void downsampleOneGroup(T group, int numItemsToKeep) {
        if (numItemsToKeep >= group.size()) {
            return;
        }
        BitSet itemsToKeep = new BitSet(group.size());
        int[] nArray = MathUtils.sampleIndicesWithoutReplacement(group.size(), numItemsToKeep);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer selectedIndex = nArray[i];
            itemsToKeep.set(selectedIndex);
        }
        int currentIndex = 0;
        if (group instanceof LinkedList) {
            Iterator iter = group.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!itemsToKeep.get(currentIndex)) {
                    iter.remove();
                    this.incrementNumberOfDiscardedItems(1);
                }
                ++currentIndex;
            }
        } else {
            ArrayList keptItems = new ArrayList(group.size());
            for (Object item : group) {
                if (itemsToKeep.get(currentIndex)) {
                    keptItems.add(item);
                }
                ++currentIndex;
            }
            this.incrementNumberOfDiscardedItems(group.size() - keptItems.size());
            group.clear();
            group.addAll(keptItems);
        }
    }
}

