/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.mutable.MutableInt;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReservoirDownsampler;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class MutectDownsampler
extends ReadsDownsampler {
    private static final int SUSPICIOUS_MAPPING_QUALITY = 50;
    private final MutableInt suspiciousReadCount;
    private final int maxSuspiciousReadsPerStride;
    private boolean rejectAllReadsInStride;
    private final int stride;
    private final int maxCoverage;
    private final List<GATKRead> pendingReads;
    private List<GATKRead> finalizedReads;
    private GATKRead firstReadInStride;

    public MutectDownsampler(int maxReadsPerAlignmentStart, int maxSuspiciousReadsPerAlignmentStart, int stride) {
        this.maxCoverage = maxReadsPerAlignmentStart <= 0 ? Integer.MAX_VALUE : maxReadsPerAlignmentStart * stride;
        this.stride = ParamUtils.isPositive(stride, "stride must be > 0");
        this.maxSuspiciousReadsPerStride = maxSuspiciousReadsPerAlignmentStart <= 0 ? Integer.MAX_VALUE : stride * ParamUtils.isPositive(maxSuspiciousReadsPerAlignmentStart, "maxSuspiciousReadsPerAlignmentStart must be > 0");
        this.pendingReads = new ArrayList<GATKRead>();
        this.finalizedReads = new ArrayList<GATKRead>();
        this.rejectAllReadsInStride = false;
        this.suspiciousReadCount = new MutableInt(0);
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(GATKRead newRead) {
        Utils.nonNull(newRead);
        if (ReadUtils.readHasNoAssignedPosition(newRead)) {
            this.finalizedReads.add(newRead);
            return;
        }
        this.handlePositionalChange(newRead);
        if (this.rejectAllReadsInStride) {
            return;
        }
        if (newRead.getMappingQuality() <= 50) {
            this.suspiciousReadCount.increment();
        }
        this.rejectAllReadsInStride |= this.suspiciousReadCount.intValue() >= this.maxSuspiciousReadsPerStride;
        this.pendingReads.add(newRead);
    }

    private void handlePositionalChange(GATKRead newRead) {
        if (ReadUtils.readHasNoAssignedPosition(newRead)) {
            return;
        }
        if (this.firstReadInStride == null) {
            this.firstReadInStride = newRead;
        } else {
            boolean newStride;
            boolean newContig = !newRead.getAssignedContig().equals(this.firstReadInStride.getAssignedContig());
            boolean bl = newStride = newContig || newRead.getAssignedStart() >= this.firstReadInStride.getAssignedStart() + this.stride;
            if (newStride) {
                this.finalizePendingReads();
                this.firstReadInStride = newRead;
                this.rejectAllReadsInStride = false;
                this.suspiciousReadCount.setValue(0);
            }
        }
    }

    private void finalizePendingReads() {
        if (!this.rejectAllReadsInStride) {
            if (this.pendingReads.size() <= this.maxCoverage) {
                this.finalizedReads.addAll(this.pendingReads);
            } else {
                ReservoirDownsampler wellMappedDownsampler = new ReservoirDownsampler(this.maxCoverage, false);
                this.pendingReads.stream().filter(read -> read.getMappingQuality() > 50).forEach(wellMappedDownsampler::submit);
                wellMappedDownsampler.signalEndOfInput();
                List<GATKRead> readsToFinalize = wellMappedDownsampler.consumeFinalizedItems();
                if (this.stride > 1) {
                    Collections.sort(readsToFinalize, Comparator.comparingInt(GATKRead::getAssignedStart));
                }
                this.finalizedReads.addAll(readsToFinalize);
            }
        }
        this.pendingReads.clear();
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.finalizedReads.isEmpty();
    }

    @Override
    public boolean hasPendingItems() {
        return !this.pendingReads.isEmpty();
    }

    @Override
    public GATKRead peekFinalized() {
        return this.finalizedReads.isEmpty() ? null : this.finalizedReads.get(0);
    }

    @Override
    public GATKRead peekPending() {
        return this.pendingReads.isEmpty() ? null : this.pendingReads.get(0);
    }

    @Override
    public List<GATKRead> consumeFinalizedItems() {
        Collections.sort(this.finalizedReads, Comparator.comparingInt(GATKRead::getAssignedStart));
        List<GATKRead> toReturn = this.finalizedReads;
        this.finalizedReads = new ArrayList<GATKRead>();
        return toReturn;
    }

    @Override
    public int size() {
        return this.finalizedReads.size() + this.pendingReads.size();
    }

    @Override
    public void signalEndOfInput() {
        this.finalizePendingReads();
    }

    @Override
    public void clearItems() {
        this.pendingReads.clear();
        this.finalizedReads.clear();
        this.firstReadInStride = null;
        this.rejectAllReadsInStride = false;
        this.suspiciousReadCount.setValue(0);
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return true;
    }

    @Override
    public void signalNoMoreReadsBefore(GATKRead read) {
        this.handlePositionalChange(read);
    }
}

